/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl.system;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.system.HeapIterator;
import org.apache.accumulo.core.iteratorsImpl.system.InterruptibleIterator;
import org.apache.commons.lang3.mutable.MutableLong;

public class LocalityGroupIterator
extends HeapIterator
implements InterruptibleIterator {
    private static final Collection<ByteSequence> EMPTY_CF_SET = Collections.emptySet();
    private final LocalityGroupContext lgContext;
    private LocalityGroupSeekCache lgCache;
    private AtomicBoolean interruptFlag;

    public LocalityGroupIterator(LocalityGroup[] groups) {
        super(groups.length);
        this.lgContext = new LocalityGroupContext(groups);
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    static final Collection<LocalityGroup> _seek(HeapIterator hiter, LocalityGroupContext lgContext, Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        hiter.clear();
        Set<ByteSequence> cfSet = LocalityGroupIterator.getCfSet(columnFamilies);
        Collection<LocalityGroup> groups = LocalityGroupIterator.getLocalityGroups(lgContext, inclusive, cfSet);
        for (LocalityGroup lgr : groups) {
            lgr.getIterator().seek(range, EMPTY_CF_SET, false);
            hiter.addSource(lgr.getIterator());
        }
        return groups;
    }

    private static Collection<LocalityGroup> getLocalityGroups(LocalityGroupContext lgContext, boolean inclusive, Set<ByteSequence> cfSet) {
        HashSet<LocalityGroup> groups;
        if (cfSet.isEmpty()) {
            groups = inclusive ? List.of() : lgContext.groups;
        } else {
            groups = new HashSet();
            if (lgContext.defaultGroup != null) {
                if (inclusive) {
                    if (!lgContext.groupByCf.keySet().containsAll(cfSet)) {
                        groups.add(lgContext.defaultGroup);
                    }
                } else {
                    groups.add(lgContext.defaultGroup);
                }
            }
            if (!inclusive) {
                lgContext.groupByCf.entrySet().stream().filter(entry -> !cfSet.contains(entry.getKey())).map(Map.Entry::getValue).forEach(groups::add);
            } else if (lgContext.groupByCf.size() <= cfSet.size()) {
                lgContext.groupByCf.entrySet().stream().filter(entry -> cfSet.contains(entry.getKey())).map(Map.Entry::getValue).forEach(groups::add);
            } else {
                cfSet.stream().map(lgContext.groupByCf::get).filter(Objects::nonNull).forEach(groups::add);
            }
        }
        return groups;
    }

    private static Set<ByteSequence> getCfSet(Collection<ByteSequence> columnFamilies) {
        Set<ByteSequence> cfSet = columnFamilies.isEmpty() ? Collections.emptySet() : (columnFamilies instanceof Set ? (Set<ByteSequence>)columnFamilies : Set.copyOf(columnFamilies));
        return cfSet;
    }

    public static LocalityGroupSeekCache seek(HeapIterator hiter, LocalityGroupContext lgContext, Range range, Collection<ByteSequence> columnFamilies, boolean inclusive, LocalityGroupSeekCache lgSeekCache) throws IOException {
        if (lgSeekCache == null) {
            lgSeekCache = new LocalityGroupSeekCache();
        }
        boolean sameArgs = false;
        Set<ByteSequence> cfSet = null;
        if (lgSeekCache.lastUsed != null && inclusive == lgSeekCache.lastInclusive) {
            if (columnFamilies instanceof Set) {
                sameArgs = lgSeekCache.lastColumnFamilies.equals(columnFamilies);
            } else {
                cfSet = Set.copyOf(columnFamilies);
                sameArgs = lgSeekCache.lastColumnFamilies.equals(cfSet);
            }
        }
        if (sameArgs) {
            hiter.clear();
            for (LocalityGroup lgr : lgSeekCache.lastUsed) {
                lgr.getIterator().seek(range, EMPTY_CF_SET, false);
                hiter.addSource(lgr.getIterator());
            }
        } else {
            lgSeekCache.lastColumnFamilies = cfSet == null ? Set.copyOf(columnFamilies) : cfSet;
            lgSeekCache.lastInclusive = inclusive;
            lgSeekCache.lastUsed = LocalityGroupIterator._seek(hiter, lgContext, range, columnFamilies, inclusive);
        }
        return lgSeekCache;
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.lgCache = LocalityGroupIterator.seek(this, this.lgContext, range, columnFamilies, inclusive, this.lgCache);
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        LocalityGroup[] groupsCopy = new LocalityGroup[this.lgContext.groups.size()];
        for (int i = 0; i < this.lgContext.groups.size(); ++i) {
            groupsCopy[i] = new LocalityGroup(this.lgContext.groups.get(i), env);
            if (this.interruptFlag == null) continue;
            groupsCopy[i].getIterator().setInterruptFlag(this.interruptFlag);
        }
        return new LocalityGroupIterator(groupsCopy);
    }

    @Override
    public void setInterruptFlag(AtomicBoolean flag) {
        this.interruptFlag = flag;
        for (LocalityGroup lgr : this.lgContext.groups) {
            lgr.getIterator().setInterruptFlag(flag);
        }
    }

    public static class LocalityGroupContext {
        final List<LocalityGroup> groups;
        final LocalityGroup defaultGroup;
        final Map<ByteSequence, LocalityGroup> groupByCf;

        public LocalityGroupContext(LocalityGroup[] groups) {
            this.groups = Collections.unmodifiableList(Arrays.asList(groups));
            this.groupByCf = new HashMap<ByteSequence, LocalityGroup>();
            LocalityGroup foundDefault = null;
            for (LocalityGroup group : groups) {
                if (group.isDefaultLocalityGroup && group.columnFamilies == null) {
                    if (foundDefault != null) {
                        throw new IllegalStateException("Found multiple default locality groups");
                    }
                    foundDefault = group;
                    continue;
                }
                for (Map.Entry<ByteSequence, MutableLong> entry : group.columnFamilies.entrySet()) {
                    if (entry.getValue().longValue() <= 0L) continue;
                    if (this.groupByCf.containsKey(entry.getKey())) {
                        throw new IllegalStateException("Found the same cf in multiple locality groups");
                    }
                    this.groupByCf.put(entry.getKey(), group);
                }
            }
            this.defaultGroup = foundDefault;
        }
    }

    public static class LocalityGroup {
        protected boolean isDefaultLocalityGroup;
        protected Map<ByteSequence, MutableLong> columnFamilies;
        private InterruptibleIterator iterator;

        private LocalityGroup(LocalityGroup localityGroup, IteratorEnvironment env) {
            this(localityGroup.columnFamilies, localityGroup.isDefaultLocalityGroup);
            this.iterator = (InterruptibleIterator)localityGroup.iterator.deepCopy(env);
        }

        public LocalityGroup(InterruptibleIterator iterator, Map<ByteSequence, MutableLong> columnFamilies, boolean isDefaultLocalityGroup) {
            this(columnFamilies, isDefaultLocalityGroup);
            this.iterator = iterator;
        }

        public LocalityGroup(Map<ByteSequence, MutableLong> columnFamilies, boolean isDefaultLocalityGroup) {
            this.isDefaultLocalityGroup = isDefaultLocalityGroup;
            this.columnFamilies = columnFamilies;
        }

        public InterruptibleIterator getIterator() {
            return this.iterator;
        }
    }

    public static class LocalityGroupSeekCache {
        private Set<ByteSequence> lastColumnFamilies;
        private volatile boolean lastInclusive;
        private Collection<LocalityGroup> lastUsed;

        public Set<ByteSequence> getLastColumnFamilies() {
            return this.lastColumnFamilies;
        }

        public boolean isLastInclusive() {
            return this.lastInclusive;
        }

        public Collection<LocalityGroup> getLastUsed() {
            return this.lastUsed;
        }

        public int getNumLGSeeked() {
            return this.lastUsed == null ? 0 : this.lastUsed.size();
        }
    }
}

