/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.master.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.master.thrift.Compacting;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TableInfo
implements TBase<TableInfo, _Fields>,
Serializable,
Cloneable,
Comparable<TableInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("TableInfo");
    private static final TField RECS_FIELD_DESC = new TField("recs", 10, 1);
    private static final TField RECS_IN_MEMORY_FIELD_DESC = new TField("recsInMemory", 10, 2);
    private static final TField TABLETS_FIELD_DESC = new TField("tablets", 8, 3);
    private static final TField ONLINE_TABLETS_FIELD_DESC = new TField("onlineTablets", 8, 4);
    private static final TField INGEST_RATE_FIELD_DESC = new TField("ingestRate", 4, 5);
    private static final TField INGEST_BYTE_RATE_FIELD_DESC = new TField("ingestByteRate", 4, 6);
    private static final TField QUERY_RATE_FIELD_DESC = new TField("queryRate", 4, 7);
    private static final TField QUERY_BYTE_RATE_FIELD_DESC = new TField("queryByteRate", 4, 8);
    private static final TField MINORS_FIELD_DESC = new TField("minors", 12, 9);
    private static final TField MAJORS_FIELD_DESC = new TField("majors", 12, 10);
    private static final TField SCANS_FIELD_DESC = new TField("scans", 12, 11);
    private static final TField SCAN_RATE_FIELD_DESC = new TField("scanRate", 4, 12);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TableInfoStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TableInfoTupleSchemeFactory();
    public long recs;
    public long recsInMemory;
    public int tablets;
    public int onlineTablets;
    public double ingestRate;
    public double ingestByteRate;
    public double queryRate;
    public double queryByteRate;
    @Nullable
    public Compacting minors;
    @Nullable
    public Compacting majors;
    @Nullable
    public Compacting scans;
    public double scanRate;
    private static final int __RECS_ISSET_ID = 0;
    private static final int __RECSINMEMORY_ISSET_ID = 1;
    private static final int __TABLETS_ISSET_ID = 2;
    private static final int __ONLINETABLETS_ISSET_ID = 3;
    private static final int __INGESTRATE_ISSET_ID = 4;
    private static final int __INGESTBYTERATE_ISSET_ID = 5;
    private static final int __QUERYRATE_ISSET_ID = 6;
    private static final int __QUERYBYTERATE_ISSET_ID = 7;
    private static final int __SCANRATE_ISSET_ID = 8;
    private short __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TableInfo() {
    }

    public TableInfo(long recs, long recsInMemory, int tablets, int onlineTablets, double ingestRate, double ingestByteRate, double queryRate, double queryByteRate, Compacting minors, Compacting majors, Compacting scans, double scanRate) {
        this();
        this.recs = recs;
        this.setRecsIsSet(true);
        this.recsInMemory = recsInMemory;
        this.setRecsInMemoryIsSet(true);
        this.tablets = tablets;
        this.setTabletsIsSet(true);
        this.onlineTablets = onlineTablets;
        this.setOnlineTabletsIsSet(true);
        this.ingestRate = ingestRate;
        this.setIngestRateIsSet(true);
        this.ingestByteRate = ingestByteRate;
        this.setIngestByteRateIsSet(true);
        this.queryRate = queryRate;
        this.setQueryRateIsSet(true);
        this.queryByteRate = queryByteRate;
        this.setQueryByteRateIsSet(true);
        this.minors = minors;
        this.majors = majors;
        this.scans = scans;
        this.scanRate = scanRate;
        this.setScanRateIsSet(true);
    }

    public TableInfo(TableInfo other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.recs = other.recs;
        this.recsInMemory = other.recsInMemory;
        this.tablets = other.tablets;
        this.onlineTablets = other.onlineTablets;
        this.ingestRate = other.ingestRate;
        this.ingestByteRate = other.ingestByteRate;
        this.queryRate = other.queryRate;
        this.queryByteRate = other.queryByteRate;
        if (other.isSetMinors()) {
            this.minors = new Compacting(other.minors);
        }
        if (other.isSetMajors()) {
            this.majors = new Compacting(other.majors);
        }
        if (other.isSetScans()) {
            this.scans = new Compacting(other.scans);
        }
        this.scanRate = other.scanRate;
    }

    public TableInfo deepCopy() {
        return new TableInfo(this);
    }

    public void clear() {
        this.setRecsIsSet(false);
        this.recs = 0L;
        this.setRecsInMemoryIsSet(false);
        this.recsInMemory = 0L;
        this.setTabletsIsSet(false);
        this.tablets = 0;
        this.setOnlineTabletsIsSet(false);
        this.onlineTablets = 0;
        this.setIngestRateIsSet(false);
        this.ingestRate = 0.0;
        this.setIngestByteRateIsSet(false);
        this.ingestByteRate = 0.0;
        this.setQueryRateIsSet(false);
        this.queryRate = 0.0;
        this.setQueryByteRateIsSet(false);
        this.queryByteRate = 0.0;
        this.minors = null;
        this.majors = null;
        this.scans = null;
        this.setScanRateIsSet(false);
        this.scanRate = 0.0;
    }

    public long getRecs() {
        return this.recs;
    }

    public TableInfo setRecs(long recs) {
        this.recs = recs;
        this.setRecsIsSet(true);
        return this;
    }

    public void unsetRecs() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)0);
    }

    public boolean isSetRecs() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)0);
    }

    public void setRecsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getRecsInMemory() {
        return this.recsInMemory;
    }

    public TableInfo setRecsInMemory(long recsInMemory) {
        this.recsInMemory = recsInMemory;
        this.setRecsInMemoryIsSet(true);
        return this;
    }

    public void unsetRecsInMemory() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)1);
    }

    public boolean isSetRecsInMemory() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)1);
    }

    public void setRecsInMemoryIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getTablets() {
        return this.tablets;
    }

    public TableInfo setTablets(int tablets) {
        this.tablets = tablets;
        this.setTabletsIsSet(true);
        return this;
    }

    public void unsetTablets() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)2);
    }

    public boolean isSetTablets() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)2);
    }

    public void setTabletsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getOnlineTablets() {
        return this.onlineTablets;
    }

    public TableInfo setOnlineTablets(int onlineTablets) {
        this.onlineTablets = onlineTablets;
        this.setOnlineTabletsIsSet(true);
        return this;
    }

    public void unsetOnlineTablets() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)3);
    }

    public boolean isSetOnlineTablets() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)3);
    }

    public void setOnlineTabletsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public double getIngestRate() {
        return this.ingestRate;
    }

    public TableInfo setIngestRate(double ingestRate) {
        this.ingestRate = ingestRate;
        this.setIngestRateIsSet(true);
        return this;
    }

    public void unsetIngestRate() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)4);
    }

    public boolean isSetIngestRate() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)4);
    }

    public void setIngestRateIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public double getIngestByteRate() {
        return this.ingestByteRate;
    }

    public TableInfo setIngestByteRate(double ingestByteRate) {
        this.ingestByteRate = ingestByteRate;
        this.setIngestByteRateIsSet(true);
        return this;
    }

    public void unsetIngestByteRate() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)5);
    }

    public boolean isSetIngestByteRate() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)5);
    }

    public void setIngestByteRateIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public double getQueryRate() {
        return this.queryRate;
    }

    public TableInfo setQueryRate(double queryRate) {
        this.queryRate = queryRate;
        this.setQueryRateIsSet(true);
        return this;
    }

    public void unsetQueryRate() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)6);
    }

    public boolean isSetQueryRate() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)6);
    }

    public void setQueryRateIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public double getQueryByteRate() {
        return this.queryByteRate;
    }

    public TableInfo setQueryByteRate(double queryByteRate) {
        this.queryByteRate = queryByteRate;
        this.setQueryByteRateIsSet(true);
        return this;
    }

    public void unsetQueryByteRate() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)7);
    }

    public boolean isSetQueryByteRate() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)7);
    }

    public void setQueryByteRateIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)7, (boolean)value);
    }

    @Nullable
    public Compacting getMinors() {
        return this.minors;
    }

    public TableInfo setMinors(@Nullable Compacting minors) {
        this.minors = minors;
        return this;
    }

    public void unsetMinors() {
        this.minors = null;
    }

    public boolean isSetMinors() {
        return this.minors != null;
    }

    public void setMinorsIsSet(boolean value) {
        if (!value) {
            this.minors = null;
        }
    }

    @Nullable
    public Compacting getMajors() {
        return this.majors;
    }

    public TableInfo setMajors(@Nullable Compacting majors) {
        this.majors = majors;
        return this;
    }

    public void unsetMajors() {
        this.majors = null;
    }

    public boolean isSetMajors() {
        return this.majors != null;
    }

    public void setMajorsIsSet(boolean value) {
        if (!value) {
            this.majors = null;
        }
    }

    @Nullable
    public Compacting getScans() {
        return this.scans;
    }

    public TableInfo setScans(@Nullable Compacting scans) {
        this.scans = scans;
        return this;
    }

    public void unsetScans() {
        this.scans = null;
    }

    public boolean isSetScans() {
        return this.scans != null;
    }

    public void setScansIsSet(boolean value) {
        if (!value) {
            this.scans = null;
        }
    }

    public double getScanRate() {
        return this.scanRate;
    }

    public TableInfo setScanRate(double scanRate) {
        this.scanRate = scanRate;
        this.setScanRateIsSet(true);
        return this;
    }

    public void unsetScanRate() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)8);
    }

    public boolean isSetScanRate() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)8);
    }

    public void setScanRateIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)8, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case RECS: {
                if (value == null) {
                    this.unsetRecs();
                    break;
                }
                this.setRecs((Long)value);
                break;
            }
            case RECS_IN_MEMORY: {
                if (value == null) {
                    this.unsetRecsInMemory();
                    break;
                }
                this.setRecsInMemory((Long)value);
                break;
            }
            case TABLETS: {
                if (value == null) {
                    this.unsetTablets();
                    break;
                }
                this.setTablets((Integer)value);
                break;
            }
            case ONLINE_TABLETS: {
                if (value == null) {
                    this.unsetOnlineTablets();
                    break;
                }
                this.setOnlineTablets((Integer)value);
                break;
            }
            case INGEST_RATE: {
                if (value == null) {
                    this.unsetIngestRate();
                    break;
                }
                this.setIngestRate((Double)value);
                break;
            }
            case INGEST_BYTE_RATE: {
                if (value == null) {
                    this.unsetIngestByteRate();
                    break;
                }
                this.setIngestByteRate((Double)value);
                break;
            }
            case QUERY_RATE: {
                if (value == null) {
                    this.unsetQueryRate();
                    break;
                }
                this.setQueryRate((Double)value);
                break;
            }
            case QUERY_BYTE_RATE: {
                if (value == null) {
                    this.unsetQueryByteRate();
                    break;
                }
                this.setQueryByteRate((Double)value);
                break;
            }
            case MINORS: {
                if (value == null) {
                    this.unsetMinors();
                    break;
                }
                this.setMinors((Compacting)value);
                break;
            }
            case MAJORS: {
                if (value == null) {
                    this.unsetMajors();
                    break;
                }
                this.setMajors((Compacting)value);
                break;
            }
            case SCANS: {
                if (value == null) {
                    this.unsetScans();
                    break;
                }
                this.setScans((Compacting)value);
                break;
            }
            case SCAN_RATE: {
                if (value == null) {
                    this.unsetScanRate();
                    break;
                }
                this.setScanRate((Double)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case RECS: {
                return this.getRecs();
            }
            case RECS_IN_MEMORY: {
                return this.getRecsInMemory();
            }
            case TABLETS: {
                return this.getTablets();
            }
            case ONLINE_TABLETS: {
                return this.getOnlineTablets();
            }
            case INGEST_RATE: {
                return this.getIngestRate();
            }
            case INGEST_BYTE_RATE: {
                return this.getIngestByteRate();
            }
            case QUERY_RATE: {
                return this.getQueryRate();
            }
            case QUERY_BYTE_RATE: {
                return this.getQueryByteRate();
            }
            case MINORS: {
                return this.getMinors();
            }
            case MAJORS: {
                return this.getMajors();
            }
            case SCANS: {
                return this.getScans();
            }
            case SCAN_RATE: {
                return this.getScanRate();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case RECS: {
                return this.isSetRecs();
            }
            case RECS_IN_MEMORY: {
                return this.isSetRecsInMemory();
            }
            case TABLETS: {
                return this.isSetTablets();
            }
            case ONLINE_TABLETS: {
                return this.isSetOnlineTablets();
            }
            case INGEST_RATE: {
                return this.isSetIngestRate();
            }
            case INGEST_BYTE_RATE: {
                return this.isSetIngestByteRate();
            }
            case QUERY_RATE: {
                return this.isSetQueryRate();
            }
            case QUERY_BYTE_RATE: {
                return this.isSetQueryByteRate();
            }
            case MINORS: {
                return this.isSetMinors();
            }
            case MAJORS: {
                return this.isSetMajors();
            }
            case SCANS: {
                return this.isSetScans();
            }
            case SCAN_RATE: {
                return this.isSetScanRate();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TableInfo) {
            return this.equals((TableInfo)that);
        }
        return false;
    }

    public boolean equals(TableInfo that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_recs = true;
        boolean that_present_recs = true;
        if (this_present_recs || that_present_recs) {
            if (!this_present_recs || !that_present_recs) {
                return false;
            }
            if (this.recs != that.recs) {
                return false;
            }
        }
        boolean this_present_recsInMemory = true;
        boolean that_present_recsInMemory = true;
        if (this_present_recsInMemory || that_present_recsInMemory) {
            if (!this_present_recsInMemory || !that_present_recsInMemory) {
                return false;
            }
            if (this.recsInMemory != that.recsInMemory) {
                return false;
            }
        }
        boolean this_present_tablets = true;
        boolean that_present_tablets = true;
        if (this_present_tablets || that_present_tablets) {
            if (!this_present_tablets || !that_present_tablets) {
                return false;
            }
            if (this.tablets != that.tablets) {
                return false;
            }
        }
        boolean this_present_onlineTablets = true;
        boolean that_present_onlineTablets = true;
        if (this_present_onlineTablets || that_present_onlineTablets) {
            if (!this_present_onlineTablets || !that_present_onlineTablets) {
                return false;
            }
            if (this.onlineTablets != that.onlineTablets) {
                return false;
            }
        }
        boolean this_present_ingestRate = true;
        boolean that_present_ingestRate = true;
        if (this_present_ingestRate || that_present_ingestRate) {
            if (!this_present_ingestRate || !that_present_ingestRate) {
                return false;
            }
            if (this.ingestRate != that.ingestRate) {
                return false;
            }
        }
        boolean this_present_ingestByteRate = true;
        boolean that_present_ingestByteRate = true;
        if (this_present_ingestByteRate || that_present_ingestByteRate) {
            if (!this_present_ingestByteRate || !that_present_ingestByteRate) {
                return false;
            }
            if (this.ingestByteRate != that.ingestByteRate) {
                return false;
            }
        }
        boolean this_present_queryRate = true;
        boolean that_present_queryRate = true;
        if (this_present_queryRate || that_present_queryRate) {
            if (!this_present_queryRate || !that_present_queryRate) {
                return false;
            }
            if (this.queryRate != that.queryRate) {
                return false;
            }
        }
        boolean this_present_queryByteRate = true;
        boolean that_present_queryByteRate = true;
        if (this_present_queryByteRate || that_present_queryByteRate) {
            if (!this_present_queryByteRate || !that_present_queryByteRate) {
                return false;
            }
            if (this.queryByteRate != that.queryByteRate) {
                return false;
            }
        }
        boolean this_present_minors = this.isSetMinors();
        boolean that_present_minors = that.isSetMinors();
        if (this_present_minors || that_present_minors) {
            if (!this_present_minors || !that_present_minors) {
                return false;
            }
            if (!this.minors.equals(that.minors)) {
                return false;
            }
        }
        boolean this_present_majors = this.isSetMajors();
        boolean that_present_majors = that.isSetMajors();
        if (this_present_majors || that_present_majors) {
            if (!this_present_majors || !that_present_majors) {
                return false;
            }
            if (!this.majors.equals(that.majors)) {
                return false;
            }
        }
        boolean this_present_scans = this.isSetScans();
        boolean that_present_scans = that.isSetScans();
        if (this_present_scans || that_present_scans) {
            if (!this_present_scans || !that_present_scans) {
                return false;
            }
            if (!this.scans.equals(that.scans)) {
                return false;
            }
        }
        boolean this_present_scanRate = true;
        boolean that_present_scanRate = true;
        if (this_present_scanRate || that_present_scanRate) {
            if (!this_present_scanRate || !that_present_scanRate) {
                return false;
            }
            if (this.scanRate != that.scanRate) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.recs);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.recsInMemory);
        hashCode = hashCode * 8191 + this.tablets;
        hashCode = hashCode * 8191 + this.onlineTablets;
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((double)this.ingestRate);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((double)this.ingestByteRate);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((double)this.queryRate);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((double)this.queryByteRate);
        hashCode = hashCode * 8191 + (this.isSetMinors() ? 131071 : 524287);
        if (this.isSetMinors()) {
            hashCode = hashCode * 8191 + this.minors.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMajors() ? 131071 : 524287);
        if (this.isSetMajors()) {
            hashCode = hashCode * 8191 + this.majors.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetScans() ? 131071 : 524287);
        if (this.isSetScans()) {
            hashCode = hashCode * 8191 + this.scans.hashCode();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((double)this.scanRate);
        return hashCode;
    }

    @Override
    public int compareTo(TableInfo other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetRecs(), other.isSetRecs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRecs() && (lastComparison = TBaseHelper.compareTo((long)this.recs, (long)other.recs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRecsInMemory(), other.isSetRecsInMemory());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRecsInMemory() && (lastComparison = TBaseHelper.compareTo((long)this.recsInMemory, (long)other.recsInMemory)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTablets(), other.isSetTablets());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTablets() && (lastComparison = TBaseHelper.compareTo((int)this.tablets, (int)other.tablets)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOnlineTablets(), other.isSetOnlineTablets());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOnlineTablets() && (lastComparison = TBaseHelper.compareTo((int)this.onlineTablets, (int)other.onlineTablets)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIngestRate(), other.isSetIngestRate());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIngestRate() && (lastComparison = TBaseHelper.compareTo((double)this.ingestRate, (double)other.ingestRate)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIngestByteRate(), other.isSetIngestByteRate());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIngestByteRate() && (lastComparison = TBaseHelper.compareTo((double)this.ingestByteRate, (double)other.ingestByteRate)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetQueryRate(), other.isSetQueryRate());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetQueryRate() && (lastComparison = TBaseHelper.compareTo((double)this.queryRate, (double)other.queryRate)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetQueryByteRate(), other.isSetQueryByteRate());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetQueryByteRate() && (lastComparison = TBaseHelper.compareTo((double)this.queryByteRate, (double)other.queryByteRate)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMinors(), other.isSetMinors());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMinors() && (lastComparison = TBaseHelper.compareTo((Comparable)this.minors, (Comparable)other.minors)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMajors(), other.isSetMajors());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMajors() && (lastComparison = TBaseHelper.compareTo((Comparable)this.majors, (Comparable)other.majors)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetScans(), other.isSetScans());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetScans() && (lastComparison = TBaseHelper.compareTo((Comparable)this.scans, (Comparable)other.scans)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetScanRate(), other.isSetScanRate());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetScanRate() && (lastComparison = TBaseHelper.compareTo((double)this.scanRate, (double)other.scanRate)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TableInfo.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TableInfo.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TableInfo(");
        boolean first = true;
        sb.append("recs:");
        sb.append(this.recs);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("recsInMemory:");
        sb.append(this.recsInMemory);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tablets:");
        sb.append(this.tablets);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("onlineTablets:");
        sb.append(this.onlineTablets);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ingestRate:");
        sb.append(this.ingestRate);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ingestByteRate:");
        sb.append(this.ingestByteRate);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("queryRate:");
        sb.append(this.queryRate);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("queryByteRate:");
        sb.append(this.queryByteRate);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("minors:");
        if (this.minors == null) {
            sb.append("null");
        } else {
            sb.append(this.minors);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("majors:");
        if (this.majors == null) {
            sb.append("null");
        } else {
            sb.append(this.majors);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("scans:");
        if (this.scans == null) {
            sb.append("null");
        } else {
            sb.append(this.scans);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("scanRate:");
        sb.append(this.scanRate);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.minors != null) {
            this.minors.validate();
        }
        if (this.majors != null) {
            this.majors.validate();
        }
        if (this.scans != null) {
            this.scans.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    private static void unusedMethod() {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.RECS, new FieldMetaData("recs", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.RECS_IN_MEMORY, new FieldMetaData("recsInMemory", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TABLETS, new FieldMetaData("tablets", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.ONLINE_TABLETS, new FieldMetaData("onlineTablets", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.INGEST_RATE, new FieldMetaData("ingestRate", 3, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.INGEST_BYTE_RATE, new FieldMetaData("ingestByteRate", 3, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.QUERY_RATE, new FieldMetaData("queryRate", 3, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.QUERY_BYTE_RATE, new FieldMetaData("queryByteRate", 3, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.MINORS, new FieldMetaData("minors", 3, (FieldValueMetaData)new StructMetaData(12, Compacting.class)));
        tmpMap.put(_Fields.MAJORS, new FieldMetaData("majors", 3, (FieldValueMetaData)new StructMetaData(12, Compacting.class)));
        tmpMap.put(_Fields.SCANS, new FieldMetaData("scans", 3, (FieldValueMetaData)new StructMetaData(12, Compacting.class)));
        tmpMap.put(_Fields.SCAN_RATE, new FieldMetaData("scanRate", 3, new FieldValueMetaData(4)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TableInfo.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        RECS(1, "recs"),
        RECS_IN_MEMORY(2, "recsInMemory"),
        TABLETS(3, "tablets"),
        ONLINE_TABLETS(4, "onlineTablets"),
        INGEST_RATE(5, "ingestRate"),
        INGEST_BYTE_RATE(6, "ingestByteRate"),
        QUERY_RATE(7, "queryRate"),
        QUERY_BYTE_RATE(8, "queryByteRate"),
        MINORS(9, "minors"),
        MAJORS(10, "majors"),
        SCANS(11, "scans"),
        SCAN_RATE(12, "scanRate");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return RECS;
                }
                case 2: {
                    return RECS_IN_MEMORY;
                }
                case 3: {
                    return TABLETS;
                }
                case 4: {
                    return ONLINE_TABLETS;
                }
                case 5: {
                    return INGEST_RATE;
                }
                case 6: {
                    return INGEST_BYTE_RATE;
                }
                case 7: {
                    return QUERY_RATE;
                }
                case 8: {
                    return QUERY_BYTE_RATE;
                }
                case 9: {
                    return MINORS;
                }
                case 10: {
                    return MAJORS;
                }
                case 11: {
                    return SCANS;
                }
                case 12: {
                    return SCAN_RATE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class TableInfoStandardSchemeFactory
    implements SchemeFactory {
        private TableInfoStandardSchemeFactory() {
        }

        public TableInfoStandardScheme getScheme() {
            return new TableInfoStandardScheme();
        }
    }

    private static class TableInfoTupleSchemeFactory
    implements SchemeFactory {
        private TableInfoTupleSchemeFactory() {
        }

        public TableInfoTupleScheme getScheme() {
            return new TableInfoTupleScheme();
        }
    }

    private static class TableInfoTupleScheme
    extends TupleScheme<TableInfo> {
        private TableInfoTupleScheme() {
        }

        public void write(TProtocol prot, TableInfo struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetRecs()) {
                optionals.set(0);
            }
            if (struct.isSetRecsInMemory()) {
                optionals.set(1);
            }
            if (struct.isSetTablets()) {
                optionals.set(2);
            }
            if (struct.isSetOnlineTablets()) {
                optionals.set(3);
            }
            if (struct.isSetIngestRate()) {
                optionals.set(4);
            }
            if (struct.isSetIngestByteRate()) {
                optionals.set(5);
            }
            if (struct.isSetQueryRate()) {
                optionals.set(6);
            }
            if (struct.isSetQueryByteRate()) {
                optionals.set(7);
            }
            if (struct.isSetMinors()) {
                optionals.set(8);
            }
            if (struct.isSetMajors()) {
                optionals.set(9);
            }
            if (struct.isSetScans()) {
                optionals.set(10);
            }
            if (struct.isSetScanRate()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetRecs()) {
                oprot.writeI64(struct.recs);
            }
            if (struct.isSetRecsInMemory()) {
                oprot.writeI64(struct.recsInMemory);
            }
            if (struct.isSetTablets()) {
                oprot.writeI32(struct.tablets);
            }
            if (struct.isSetOnlineTablets()) {
                oprot.writeI32(struct.onlineTablets);
            }
            if (struct.isSetIngestRate()) {
                oprot.writeDouble(struct.ingestRate);
            }
            if (struct.isSetIngestByteRate()) {
                oprot.writeDouble(struct.ingestByteRate);
            }
            if (struct.isSetQueryRate()) {
                oprot.writeDouble(struct.queryRate);
            }
            if (struct.isSetQueryByteRate()) {
                oprot.writeDouble(struct.queryByteRate);
            }
            if (struct.isSetMinors()) {
                struct.minors.write((TProtocol)oprot);
            }
            if (struct.isSetMajors()) {
                struct.majors.write((TProtocol)oprot);
            }
            if (struct.isSetScans()) {
                struct.scans.write((TProtocol)oprot);
            }
            if (struct.isSetScanRate()) {
                oprot.writeDouble(struct.scanRate);
            }
        }

        public void read(TProtocol prot, TableInfo struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.recs = iprot.readI64();
                struct.setRecsIsSet(true);
            }
            if (incoming.get(1)) {
                struct.recsInMemory = iprot.readI64();
                struct.setRecsInMemoryIsSet(true);
            }
            if (incoming.get(2)) {
                struct.tablets = iprot.readI32();
                struct.setTabletsIsSet(true);
            }
            if (incoming.get(3)) {
                struct.onlineTablets = iprot.readI32();
                struct.setOnlineTabletsIsSet(true);
            }
            if (incoming.get(4)) {
                struct.ingestRate = iprot.readDouble();
                struct.setIngestRateIsSet(true);
            }
            if (incoming.get(5)) {
                struct.ingestByteRate = iprot.readDouble();
                struct.setIngestByteRateIsSet(true);
            }
            if (incoming.get(6)) {
                struct.queryRate = iprot.readDouble();
                struct.setQueryRateIsSet(true);
            }
            if (incoming.get(7)) {
                struct.queryByteRate = iprot.readDouble();
                struct.setQueryByteRateIsSet(true);
            }
            if (incoming.get(8)) {
                struct.minors = new Compacting();
                struct.minors.read((TProtocol)iprot);
                struct.setMinorsIsSet(true);
            }
            if (incoming.get(9)) {
                struct.majors = new Compacting();
                struct.majors.read((TProtocol)iprot);
                struct.setMajorsIsSet(true);
            }
            if (incoming.get(10)) {
                struct.scans = new Compacting();
                struct.scans.read((TProtocol)iprot);
                struct.setScansIsSet(true);
            }
            if (incoming.get(11)) {
                struct.scanRate = iprot.readDouble();
                struct.setScanRateIsSet(true);
            }
        }
    }

    private static class TableInfoStandardScheme
    extends StandardScheme<TableInfo> {
        private TableInfoStandardScheme() {
        }

        public void read(TProtocol iprot, TableInfo struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.recs = iprot.readI64();
                            struct.setRecsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.recsInMemory = iprot.readI64();
                            struct.setRecsInMemoryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.tablets = iprot.readI32();
                            struct.setTabletsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.onlineTablets = iprot.readI32();
                            struct.setOnlineTabletsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 4) {
                            struct.ingestRate = iprot.readDouble();
                            struct.setIngestRateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 4) {
                            struct.ingestByteRate = iprot.readDouble();
                            struct.setIngestByteRateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 4) {
                            struct.queryRate = iprot.readDouble();
                            struct.setQueryRateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 4) {
                            struct.queryByteRate = iprot.readDouble();
                            struct.setQueryByteRateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 12) {
                            struct.minors = new Compacting();
                            struct.minors.read(iprot);
                            struct.setMinorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 12) {
                            struct.majors = new Compacting();
                            struct.majors.read(iprot);
                            struct.setMajorsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 12) {
                            struct.scans = new Compacting();
                            struct.scans.read(iprot);
                            struct.setScansIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 4) {
                            struct.scanRate = iprot.readDouble();
                            struct.setScanRateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TableInfo struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(RECS_FIELD_DESC);
            oprot.writeI64(struct.recs);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(RECS_IN_MEMORY_FIELD_DESC);
            oprot.writeI64(struct.recsInMemory);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(TABLETS_FIELD_DESC);
            oprot.writeI32(struct.tablets);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(ONLINE_TABLETS_FIELD_DESC);
            oprot.writeI32(struct.onlineTablets);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(INGEST_RATE_FIELD_DESC);
            oprot.writeDouble(struct.ingestRate);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(INGEST_BYTE_RATE_FIELD_DESC);
            oprot.writeDouble(struct.ingestByteRate);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(QUERY_RATE_FIELD_DESC);
            oprot.writeDouble(struct.queryRate);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(QUERY_BYTE_RATE_FIELD_DESC);
            oprot.writeDouble(struct.queryByteRate);
            oprot.writeFieldEnd();
            if (struct.minors != null) {
                oprot.writeFieldBegin(MINORS_FIELD_DESC);
                struct.minors.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.majors != null) {
                oprot.writeFieldBegin(MAJORS_FIELD_DESC);
                struct.majors.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.scans != null) {
                oprot.writeFieldBegin(SCANS_FIELD_DESC);
                struct.scans.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(SCAN_RATE_FIELD_DESC);
            oprot.writeDouble(struct.scanRate);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

