/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster;

public enum MemoryUnit {
    BYTE(1L, ""),
    KILOBYTE(1024L, "K"),
    MEGABYTE(0x100000L, "M"),
    GIGABYTE(0x40000000L, "G");

    private final long multiplier;
    private final String suffix;

    private MemoryUnit(long multiplier, String suffix) {
        this.multiplier = multiplier;
        this.suffix = suffix;
    }

    public long toBytes(long memory) {
        return memory * this.multiplier;
    }

    public String suffix() {
        return this.suffix;
    }

    public static MemoryUnit fromSuffix(String suffix) {
        for (MemoryUnit memoryUnit : MemoryUnit.values()) {
            if (!memoryUnit.suffix.equals(suffix)) continue;
            return memoryUnit;
        }
        return null;
    }
}

