/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;

public class AMQPTunneledCoreLargeMessageReader
implements MessageReader {
    private final ProtonAbstractReceiver serverReceiver;
    private final CompositeByteBuf pendingRecvBuffer = Unpooled.compositeBuffer();
    private final NettyReadable pendingReadable = new NettyReadable((ByteBuf)this.pendingRecvBuffer);
    private DeliveryAnnotations deliveryAnnotations;
    private ByteBuf coreHeadersBuffer;
    private LargeServerMessage coreLargeMessage;
    private int largeMessageSectionRemaining;
    private State state = State.CLOSED;

    public AMQPTunneledCoreLargeMessageReader(ProtonAbstractReceiver serverReceiver) {
        this.serverReceiver = serverReceiver;
    }

    @Override
    public DeliveryAnnotations getDeliveryAnnotations() {
        return this.deliveryAnnotations;
    }

    @Override
    public void close() {
        if (this.state != State.CLOSED) {
            if (this.coreLargeMessage != null) {
                try {
                    this.coreLargeMessage.deleteFile();
                }
                catch (Throwable error) {
                    ActiveMQServerLogger.LOGGER.errorDeletingLargeMessageFile(error);
                }
                finally {
                    this.coreLargeMessage = null;
                }
            }
            this.pendingRecvBuffer.clear();
            this.deliveryAnnotations = null;
            this.coreHeadersBuffer = null;
            this.largeMessageSectionRemaining = 0;
            this.state = State.CLOSED;
        }
    }

    @Override
    public AMQPTunneledCoreLargeMessageReader open() {
        if (this.state != State.CLOSED) {
            throw new IllegalStateException("Reader the reader was not closed before call to open.");
        }
        this.state = State.INITIALIZING;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message readBytes(Delivery delivery) throws Exception {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("Core over AMQP Large Message Reader is closed and read cannot proceed");
        }
        if (this.state == State.DONE) {
            throw new IllegalStateException("The reader already read a message and was not reset");
        }
        Receiver receiver = (Receiver)delivery.getLink();
        ReadableBuffer recieved = receiver.recv();
        this.pendingRecvBuffer.addComponent(true, Unpooled.wrappedBuffer((ByteBuffer)recieved.byteBuffer()));
        DecoderImpl decoder = TLSEncode.getDecoder();
        decoder.setBuffer((ReadableBuffer)this.pendingReadable);
        try {
            while (this.pendingRecvBuffer.isReadable()) {
                this.pendingRecvBuffer.markReaderIndex();
                try {
                    if (this.state == State.CORE_HEADER_BUFFERING) {
                        this.tryReadHeadersAndProperties((ByteBuf)this.pendingRecvBuffer);
                    } else if (this.state == State.BODY_BUFFERING) {
                        this.tryReadMessageBody(delivery, (ByteBuf)this.pendingRecvBuffer);
                    } else {
                        this.scanForNextMessageSection(decoder);
                    }
                    this.pendingRecvBuffer.markReaderIndex();
                }
                catch (ActiveMQException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    if (delivery.isPartial()) {
                        this.pendingRecvBuffer.resetReaderIndex();
                        break;
                    }
                    throw new ActiveMQAMQPInternalErrorException("Decoding error encounted in tunneled core large message.", e);
                }
                finally {
                    this.pendingRecvBuffer.discardReadComponents();
                }
            }
            if (!delivery.isPartial()) {
                if (this.coreLargeMessage == null) {
                    throw new ActiveMQAMQPInternalErrorException("Tunneled Core large message delivery contained no large message body.");
                }
                Message result = this.coreLargeMessage.toMessage();
                this.coreLargeMessage.releaseResources(this.serverReceiver.getConnection().isLargeMessageSync(), true);
                this.coreLargeMessage = null;
                this.state = State.DONE;
                Message message = result;
                return message;
            }
            Message message = null;
            return message;
        }
        finally {
            decoder.setBuffer(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scanForNextMessageSection(DecoderImpl decoder) throws ActiveMQException {
        TypeConstructor constructor = decoder.readConstructor();
        if (Header.class.equals((Object)constructor.getTypeClass())) {
            constructor.skipValue();
            return;
        } else if (DeliveryAnnotations.class.equals((Object)constructor.getTypeClass())) {
            this.deliveryAnnotations = (DeliveryAnnotations)constructor.readValue();
            return;
        } else if (MessageAnnotations.class.equals((Object)constructor.getTypeClass())) {
            constructor.skipValue();
            return;
        } else if (Properties.class.equals((Object)constructor.getTypeClass())) {
            constructor.skipValue();
            return;
        } else if (ApplicationProperties.class.equals((Object)constructor.getTypeClass())) {
            constructor.skipValue();
            return;
        } else if (Data.class.equals((Object)constructor.getTypeClass())) {
            int dataSectionRemaining = AMQPTunneledCoreLargeMessageReader.readNextDataSectionSize(this.pendingReadable);
            if (this.state.ordinal() < State.CORE_HEADER_BUFFERING.ordinal()) {
                this.coreHeadersBuffer = Unpooled.buffer((int)dataSectionRemaining, (int)dataSectionRemaining);
                this.state = State.CORE_HEADER_BUFFERING;
                return;
            } else {
                if (this.state.ordinal() >= State.BODY_BUFFERING.ordinal()) throw new IllegalStateException("Data section found when not expecting any more input.");
                this.largeMessageSectionRemaining = dataSectionRemaining;
                this.state = State.BODY_BUFFERING;
            }
            return;
        } else {
            if (AmqpValue.class.equals((Object)constructor.getTypeClass())) {
                throw new IllegalArgumentException("Received an AmqpValue payload in core tunneled AMQP message");
            }
            if (AmqpSequence.class.equals((Object)constructor.getTypeClass())) {
                throw new IllegalArgumentException("Received an AmqpSequence payload in core tunneled AMQP message");
            }
            if (!Footer.class.equals((Object)constructor.getTypeClass())) return;
            if (this.coreLargeMessage == null) {
                throw new IllegalArgumentException("Received an Footer but no actual message paylod in core tunneled AMQP message");
            }
            constructor.skipValue();
        }
    }

    private static int readNextDataSectionSize(ReadableBuffer buffer) throws ActiveMQException {
        byte encodingCode = buffer.get();
        return switch (encodingCode) {
            case -96 -> buffer.get() & 0xFF;
            case -80 -> buffer.getInt();
            case 64 -> 0;
            default -> throw new ActiveMQException("Expected Binary type but found encoding: " + encodingCode);
        };
    }

    private boolean tryReadHeadersAndProperties(ByteBuf buffer) throws Exception {
        int writeSize = Math.min(this.coreHeadersBuffer.writableBytes(), buffer.readableBytes());
        if (writeSize > 0) {
            this.coreHeadersBuffer.writeBytes(buffer, writeSize);
        }
        if (this.coreHeadersBuffer.isWritable()) {
            return false;
        }
        try {
            AMQPSessionCallback sessionSPI = this.serverReceiver.getSessionContext().getSessionSPI();
            long id = sessionSPI.getStorageManager().generateID();
            CoreMessage coreMessage = new CoreMessage();
            coreMessage.decodeHeadersAndProperties(this.coreHeadersBuffer);
            this.coreLargeMessage = sessionSPI.getStorageManager().createCoreLargeMessage(id, (Message)coreMessage);
            this.coreHeadersBuffer = null;
            this.state = State.BODY_SECTION_PENDING;
        }
        catch (ActiveMQException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ActiveMQAMQPInternalErrorException("Encountered error while attempting to create a Core Large message instance", ex);
        }
        return true;
    }

    private void tryReadMessageBody(Delivery delivery, ByteBuf buffer) throws Exception {
        int writeSize = Math.min(this.largeMessageSectionRemaining, buffer.readableBytes());
        try {
            ActiveMQBuffer bodyBuffer = ActiveMQBuffers.wrappedBuffer((ByteBuf)buffer.slice(buffer.readerIndex(), writeSize));
            this.coreLargeMessage.addBytes(bodyBuffer);
        }
        catch (ActiveMQException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ActiveMQAMQPInternalErrorException("Error while adding body bytes to Core Large message", ex);
        }
        this.largeMessageSectionRemaining -= writeSize;
        buffer.readerIndex(buffer.readerIndex() + writeSize);
        if (this.largeMessageSectionRemaining == 0) {
            this.state = State.BODY_SECTION_PENDING;
        }
    }

    private static enum State {
        INITIALIZING,
        CORE_HEADER_BUFFERING,
        BODY_SECTION_PENDING,
        BODY_BUFFERING,
        DONE,
        CLOSED;

    }
}

