/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.asterix.common.exceptions.RuntimeDataException;

public class LocalFileSystemUtils {
    public static void traverse(final List<File> files, File root, final String expression, final LinkedList<Path> dirs) throws IOException {
        Path path = root.toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new RuntimeDataException(3077, new Serializable[]{path.toString()});
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            LocalFileSystemUtils.validateAndAdd(path, expression, files);
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                    return FileVisitResult.TERMINATE;
                }
                if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                    File[] content;
                    if (dirs != null) {
                        dirs.add(path);
                    }
                    for (File file : content = path.toFile().listFiles()) {
                        if (file.isDirectory()) continue;
                        LocalFileSystemUtils.validateAndAdd(file.toPath(), expression, files);
                    }
                } else {
                    LocalFileSystemUtils.validateAndAdd(path, expression, files);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static boolean fileNotExistsInList(List<File> files, Path path) {
        for (File file : files) {
            if (!file.getPath().equals(path.toString())) continue;
            return false;
        }
        return true;
    }

    public static void validateAndAdd(Path path, String expression, List<File> files) {
        if ((expression == null || Pattern.matches(expression, path.toString())) && LocalFileSystemUtils.fileNotExistsInList(files, path)) {
            files.add(new File(path.toString()));
        }
    }
}

