/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.FloatPointable;

public class FloatToInt16TypeConvertComputer
implements ITypeConvertComputer {
    private static final FloatToInt16TypeConvertComputer INSTANCE_STRICT = new FloatToInt16TypeConvertComputer(true);
    private static final FloatToInt16TypeConvertComputer INSTANCE_LAX = new FloatToInt16TypeConvertComputer(false);
    private final boolean strict;

    private FloatToInt16TypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    public static FloatToInt16TypeConvertComputer getInstance(boolean strict) {
        return strict ? INSTANCE_STRICT : INSTANCE_LAX;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        float sourceValue = FloatPointable.getFloat((byte[])data, (int)start);
        short targetValue = this.convert(sourceValue);
        out.writeByte(ATypeTag.SMALLINT.serialize());
        out.writeShort(targetValue);
    }

    @Override
    public IAObject convertType(IAObject sourceObject, ATypeHierarchy.TypeCastingMathFunctionType mathFunction) throws HyracksDataException {
        float sourceValue = ATypeHierarchy.applyMathFunctionToFloatValue(sourceObject, mathFunction);
        short targetValue = this.convert(sourceValue);
        return new AInt16(targetValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private short convert(float sourceValue) throws HyracksDataException {
        if (Float.isNaN(sourceValue)) {
            if (!this.strict) return 0;
            this.raiseBoundaryException(sourceValue);
        }
        if (sourceValue > 32767.0f) {
            if (!this.strict) return Short.MAX_VALUE;
            this.raiseBoundaryException(sourceValue);
            return (short)Math.floor(sourceValue);
        } else {
            if (!(sourceValue < -32768.0f)) return (short)Math.floor(sourceValue);
            if (!this.strict) return Short.MIN_VALUE;
            this.raiseBoundaryException(sourceValue);
        }
        return (short)Math.floor(sourceValue);
    }

    private void raiseBoundaryException(float sourceValue) throws HyracksDataException {
        throw new RuntimeDataException(21, new Serializable[]{Float.valueOf(sourceValue), ATypeTag.SMALLINT, Short.valueOf((short)Short.MAX_VALUE), Short.valueOf((short)Short.MIN_VALUE)});
    }
}

