/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.log;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import java.util.concurrent.TimeUnit;

public class ReadMarker {
    private final String identifier;
    private final long sinceEpoch;
    private final TimeUnit unit;
    private Timepoint startTime;

    private ReadMarker(String identifier, long sinceEpoch, TimeUnit unit) {
        this.identifier = identifier;
        this.sinceEpoch = sinceEpoch;
        this.unit = unit;
    }

    public boolean hasIdentifier() {
        return this.identifier != null;
    }

    public String getIdentifier() {
        Preconditions.checkArgument((this.identifier != null ? 1 : 0) != 0, (Object)"ReadMarker does not have a configured identifier");
        return this.identifier;
    }

    public boolean hasStartTime() {
        return this.unit != null;
    }

    public synchronized Timepoint getStartTime(TimestampProvider times) {
        if (this.startTime == null) {
            this.startTime = this.unit == null ? times.getTime() : times.getTime(this.sinceEpoch, this.unit);
        }
        return this.startTime;
    }

    public boolean isCompatible(ReadMarker newMarker) {
        if (newMarker.hasIdentifier()) {
            return this.hasIdentifier() && this.identifier.equals(newMarker.identifier);
        }
        return !newMarker.hasStartTime();
    }

    public static ReadMarker fromNow() {
        return new ReadMarker(null, 0L, null);
    }

    public static ReadMarker fromTime(long timestamp, TimeUnit unit) {
        return new ReadMarker(null, timestamp, unit);
    }

    public static ReadMarker fromIdentifierOrTime(String id, long timestamp, TimeUnit unit) {
        return new ReadMarker(id, timestamp, unit);
    }

    public static ReadMarker fromIdentifierOrNow(String id) {
        return new ReadMarker(id, 0L, null);
    }
}

