/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;

public class StandardBaseTransactionConfig
implements BaseTransactionConfig {
    private volatile Timepoint commitTime;
    private final TimestampProvider times;
    private final String groupName;
    private final Configuration customOptions;

    private StandardBaseTransactionConfig(String groupName, TimestampProvider times, Timepoint commitTime, Configuration customOptions) {
        Preconditions.checkArgument((customOptions != null ? 1 : 0) != 0);
        Preconditions.checkArgument((null != times || null != commitTime ? 1 : 0) != 0);
        this.groupName = groupName;
        this.times = times;
        this.commitTime = commitTime;
        this.customOptions = customOptions;
    }

    @Override
    public synchronized Timepoint getCommitTime() {
        if (this.commitTime == null) {
            this.commitTime = this.times.getTime();
        }
        return this.commitTime;
    }

    @Override
    public synchronized void setCommitTime(Timepoint time) {
        Preconditions.checkArgument((this.commitTime == null ? 1 : 0) != 0, (Object)"A commit time has already been set");
        this.commitTime = time;
    }

    @Override
    public boolean hasCommitTime() {
        return this.commitTime != null;
    }

    @Override
    public TimestampProvider getTimestampProvider() {
        return this.times;
    }

    @Override
    public boolean hasGroupName() {
        return this.groupName != null;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public <V> V getCustomOption(ConfigOption<V> opt) {
        return this.customOptions.get(opt, new String[0]);
    }

    @Override
    public Configuration getCustomOptions() {
        return this.customOptions;
    }

    public static StandardBaseTransactionConfig of(TimestampProvider times) {
        return new Builder().timestampProvider(times).build();
    }

    public static StandardBaseTransactionConfig of(TimestampProvider times, Configuration customOptions) {
        return new Builder().timestampProvider(times).customOptions(customOptions).build();
    }

    public static class Builder {
        private Timepoint commitTime = null;
        private TimestampProvider times;
        private String groupName = GraphDatabaseConfiguration.getSystemMetricsPrefix();
        private Configuration customOptions = Configuration.EMPTY;

        public Builder() {
        }

        public Builder(BaseTransactionConfig template) {
            this.customOptions(template.getCustomOptions());
            this.groupName(template.getGroupName());
            this.timestampProvider(template.getTimestampProvider());
        }

        public Builder groupName(String group) {
            this.groupName = group;
            return this;
        }

        public Builder commitTime(Timepoint commit) {
            this.commitTime = commit;
            return this;
        }

        public Builder timestampProvider(TimestampProvider times) {
            this.times = times;
            return this;
        }

        public Builder customOptions(Configuration c) {
            this.customOptions = c;
            Preconditions.checkNotNull((Object)this.customOptions, (Object)"Null custom options disallowed; use an empty Configuration object instead");
            return this;
        }

        public StandardBaseTransactionConfig build() {
            return new StandardBaseTransactionConfig(this.groupName, this.times, this.commitTime, this.customOptions);
        }
    }
}

