/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Contain;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.ConditionUtil;
import com.thinkaurelius.titan.graphdb.query.condition.MultiCondition;
import com.thinkaurelius.titan.graphdb.query.condition.Not;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class QueryUtil {
    public static int adjustLimitForTxModifications(StandardTitanTx tx, int uncoveredAndConditions, int limit) {
        assert (limit > 0 && limit <= 1000000000);
        assert (uncoveredAndConditions >= 0);
        if (uncoveredAndConditions > 0) {
            int maxMultiplier = Integer.MAX_VALUE / limit;
            limit *= Math.min(maxMultiplier, (int)Math.pow(2.0, uncoveredAndConditions));
        }
        if (tx.hasModifications()) {
            limit += Math.min(Integer.MAX_VALUE - limit, 5);
        }
        return limit;
    }

    public static InternalRelationType getType(StandardTitanTx tx, String typeName) {
        RelationType t = tx.getRelationType(typeName);
        if (t == null && !tx.getConfiguration().getAutoSchemaMaker().ignoreUndefinedQueryTypes()) {
            throw new IllegalArgumentException("Undefined type used in query: " + typeName);
        }
        return (InternalRelationType)t;
    }

    public static boolean isQueryNormalForm(Condition<?> condition) {
        if (QueryUtil.isQNFLiteralOrNot(condition)) {
            return true;
        }
        if (condition instanceof And) {
            for (Condition child : ((And)condition).getChildren()) {
                if (QueryUtil.isQNFLiteralOrNot(child)) continue;
                if (child instanceof Or) {
                    for (Condition child2 : ((Or)child).getChildren()) {
                        if (QueryUtil.isQNFLiteralOrNot(child2)) continue;
                        return false;
                    }
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static final boolean isQNFLiteralOrNot(Condition<?> condition) {
        if (condition instanceof Not) {
            Condition child = ((Not)condition).getChild();
            if (!QueryUtil.isQNFLiteral(child)) {
                return false;
            }
            if (child instanceof PredicateCondition) {
                return !((PredicateCondition)child).getPredicate().hasNegation();
            }
            return true;
        }
        return QueryUtil.isQNFLiteral(condition);
    }

    private static final boolean isQNFLiteral(Condition<?> condition) {
        if (condition.getType() != Condition.Type.LITERAL) {
            return false;
        }
        if (condition instanceof PredicateCondition) {
            return ((PredicateCondition)condition).getPredicate().isQNF();
        }
        return true;
    }

    private static final <E extends TitanElement> Condition<E> inlineNegation(Condition<E> condition) {
        if (ConditionUtil.containsType(condition, Condition.Type.NOT)) {
            return ConditionUtil.transformation(condition, new Function<Condition<E>, Condition<E>>(){

                @Nullable
                public Condition<E> apply(@Nullable Condition<E> cond) {
                    if (cond instanceof Not) {
                        PredicateCondition pc;
                        Condition child = ((Not)cond).getChild();
                        Preconditions.checkArgument((child.getType() == Condition.Type.LITERAL ? 1 : 0) != 0);
                        if (child instanceof PredicateCondition && (pc = (PredicateCondition)child).getPredicate().hasNegation()) {
                            return new PredicateCondition(pc.getKey(), pc.getPredicate().negate(), pc.getValue());
                        }
                    }
                    return null;
                }
            });
        }
        return condition;
    }

    public static final <E extends TitanElement> Condition<E> simplifyQNF(Condition<E> condition) {
        Object child;
        Preconditions.checkArgument((boolean)QueryUtil.isQueryNormalForm(condition));
        if (condition.numChildren() == 1 && (child = ((And)condition).get(0)).getType() == Condition.Type.LITERAL) {
            return child;
        }
        return condition;
    }

    public static boolean isEmpty(Condition<?> condition) {
        return condition.getType() != Condition.Type.LITERAL && condition.numChildren() == 0;
    }

    public static <E extends TitanElement> And<E> constraints2QNF(StandardTitanTx tx, List<PredicateCondition<String, E>> constraints) {
        And conditions = new And(constraints.size() + 4);
        for (PredicateCondition<String, E> atom : constraints) {
            InternalRelationType type = QueryUtil.getType(tx, atom.getKey());
            if (type == null) {
                if (atom.getPredicate() == Cmp.EQUAL && atom.getValue() == null || atom.getPredicate() == Cmp.NOT_EQUAL && atom.getValue() != null) continue;
                return null;
            }
            Object value = atom.getValue();
            TitanPredicate predicate = atom.getPredicate();
            if (type.isPropertyKey()) {
                PropertyKey key = (PropertyKey)((Object)type);
                assert (predicate.isValidCondition(value));
                Preconditions.checkArgument((key.getDataType() == Object.class || predicate.isValidValueType(key.getDataType()) ? 1 : 0) != 0, (Object)"Data type of key is not compatible with condition");
            } else {
                Preconditions.checkArgument((boolean)((EdgeLabel)((Object)type)).isUnidirected());
                Preconditions.checkArgument((boolean)predicate.isValidValueType(TitanVertex.class), (Object)"Data type of key is not compatible with condition");
            }
            if (predicate instanceof Contain) {
                Collection values = (Collection)value;
                if (predicate == Contain.NOT_IN) {
                    for (Object invalue : values) {
                        QueryUtil.addConstraint(type, Cmp.NOT_EQUAL, invalue, conditions, tx);
                    }
                    continue;
                }
                Preconditions.checkArgument((predicate == Contain.IN ? 1 : 0) != 0);
                if (values.size() == 1) {
                    QueryUtil.addConstraint(type, Cmp.EQUAL, values.iterator().next(), conditions, tx);
                    continue;
                }
                Or nested = new Or(values.size());
                for (Object invalue : values) {
                    QueryUtil.addConstraint(type, Cmp.EQUAL, invalue, nested, tx);
                }
                conditions.add(nested);
                continue;
            }
            QueryUtil.addConstraint(type, predicate, value, conditions, tx);
        }
        return conditions;
    }

    private static <E extends TitanElement> void addConstraint(RelationType type, TitanPredicate predicate, Object value, MultiCondition<E> conditions, StandardTitanTx tx) {
        PredicateCondition pc;
        if (type.isPropertyKey()) {
            if (value != null) {
                value = tx.verifyAttribute((PropertyKey)type, value);
            }
        } else {
            Preconditions.checkArgument((boolean)(value instanceof TitanVertex));
        }
        if (!conditions.contains(pc = new PredicateCondition(type, predicate, value))) {
            conditions.add(pc);
        }
    }

    public static Map.Entry<RelationType, Collection> extractOrCondition(Or<TitanRelation> condition) {
        RelationType masterType = null;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Condition c : condition.getChildren()) {
            if (!(c instanceof PredicateCondition)) {
                return null;
            }
            PredicateCondition atom = (PredicateCondition)c;
            if (atom.getPredicate() != Cmp.EQUAL) {
                return null;
            }
            Object value = atom.getValue();
            if (value == null) {
                return null;
            }
            RelationType type = (RelationType)atom.getKey();
            if (masterType == null) {
                masterType = type;
            } else if (!masterType.equals(type)) {
                return null;
            }
            values.add(value);
        }
        if (masterType == null) {
            return null;
        }
        assert (!values.isEmpty());
        return new AbstractMap.SimpleImmutableEntry(masterType, values);
    }

    public static <R> List<R> processIntersectingRetrievals(List<IndexCall<R>> retrievals, int limit) {
        boolean exhaustedResults;
        List results;
        Preconditions.checkArgument((!retrievals.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"Invalid limit: %s", (Object[])new Object[]{limit});
        int multiplier = Math.min(16, (int)Math.pow(2.0, retrievals.size() - 1));
        int sublimit = Integer.MAX_VALUE;
        if (Integer.MAX_VALUE / multiplier >= limit) {
            sublimit = limit * multiplier;
        }
        do {
            exhaustedResults = true;
            results = null;
            for (IndexCall<R> call : retrievals) {
                Collection<R> subresult;
                try {
                    subresult = call.call(sublimit);
                }
                catch (Exception e) {
                    throw new TitanException("Could not process individual retrieval call ", e);
                }
                if (subresult.size() >= sublimit) {
                    exhaustedResults = false;
                }
                if (results == null) {
                    results = Lists.newArrayList(subresult);
                    continue;
                }
                ImmutableSet subresultset = ImmutableSet.copyOf(subresult);
                Iterator riter = results.iterator();
                while (riter.hasNext()) {
                    if (subresultset.contains(riter.next())) continue;
                    riter.remove();
                }
            }
            sublimit = (int)Math.min(2.147483646E9, Math.max(Math.pow(sublimit, 1.5), (double)((sublimit + 1) * 2)));
        } while (results.size() < limit && !exhaustedResults);
        return results;
    }

    public static interface IndexCall<R> {
        public Collection<R> call(int var1);
    }
}

