/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.condition;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.query.condition.Literal;
import com.tinkerpop.blueprints.Direction;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IncidenceDirectionCondition<E extends TitanRelation>
extends Literal<E> {
    private final Direction direction;
    private final TitanVertex otherVertex;

    public IncidenceDirectionCondition(Direction direction, TitanVertex otherVertex) {
        Preconditions.checkNotNull((Object)direction);
        Preconditions.checkNotNull((Object)otherVertex);
        this.direction = direction;
        this.otherVertex = otherVertex;
    }

    @Override
    public boolean evaluate(E relation) {
        return relation.isEdge() && ((TitanEdge)relation).getVertex(this.direction).equals(this.otherVertex);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.direction).append((Object)this.otherVertex).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        IncidenceDirectionCondition oth = (IncidenceDirectionCondition)other;
        return this.direction == oth.direction && this.otherVertex.equals(oth.otherVertex);
    }

    @Override
    public String toString() {
        return "incidence[" + this.direction + "-" + this.otherVertex + "]";
    }
}

