/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.schema.RelationTypeMaker;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.graphdb.database.IndexSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeHandling;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.thinkaurelius.titan.graphdb.types.system.SystemTypeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class StandardRelationTypeMaker
implements RelationTypeMaker {
    static final char[] RESERVED_CHARS = new char[]{'{', '}', '\"', '$', '%'};
    protected final StandardTitanTx tx;
    protected final IndexSerializer indexSerializer;
    protected final AttributeHandling attributeHandler;
    private String name;
    private boolean isHidden;
    private List<RelationType> sortKey;
    private Order sortOrder;
    private List<RelationType> signature;
    private Multiplicity multiplicity;
    private SchemaStatus status = SchemaStatus.ENABLED;

    public StandardRelationTypeMaker(StandardTitanTx tx, IndexSerializer indexSerializer, AttributeHandling attributeHandler) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)indexSerializer);
        Preconditions.checkNotNull((Object)attributeHandler);
        this.tx = tx;
        this.indexSerializer = indexSerializer;
        this.attributeHandler = attributeHandler;
        this.name = null;
        this.isHidden = false;
        this.sortKey = new ArrayList<RelationType>(4);
        this.sortOrder = Order.ASC;
        this.signature = new ArrayList<RelationType>(4);
        this.multiplicity = Multiplicity.MULTI;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean hasSortKey() {
        return !this.sortKey.isEmpty();
    }

    protected Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public static void checkName(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Need to specify name");
        for (char c : RESERVED_CHARS) {
            Preconditions.checkArgument((name.indexOf(c) < 0 ? 1 : 0) != 0, (String)"Name can not contains reserved character %s: %s", (Object[])new Object[]{Character.valueOf(c), name});
        }
        Preconditions.checkArgument((!name.startsWith("system%&%") ? 1 : 0) != 0, (Object)"Name starts with a reserved keyword: system%&%");
        Preconditions.checkArgument((!SystemTypeManager.isSystemType(name.toLowerCase()) ? 1 : 0) != 0, (String)"Name is reserved by system and cannot be used: %s", (Object[])new Object[]{name});
    }

    private void checkGeneralArguments() {
        StandardRelationTypeMaker.checkName(this.name);
        this.checkSortKey(this.sortKey);
        Preconditions.checkArgument((this.sortOrder == Order.ASC || this.hasSortKey() ? 1 : 0) != 0, (Object)"Must define a sort key to use ordering");
        StandardRelationTypeMaker.checkSignature(this.signature);
        Preconditions.checkArgument((boolean)Sets.intersection((Set)Sets.newHashSet(this.sortKey), (Set)Sets.newHashSet(this.signature)).isEmpty(), (Object)"Signature and sort key must be disjoined");
        Preconditions.checkArgument((!this.hasSortKey() || !this.multiplicity.isConstrained() ? 1 : 0) != 0, (Object)"Cannot define a sort-key on constrained edge labels");
    }

    private long[] checkSortKey(List<RelationType> sig) {
        for (RelationType t : sig) {
            Preconditions.checkArgument((t.isEdgeLabel() || this.attributeHandler.isOrderPreservingDatatype(((PropertyKey)t).getDataType()) ? 1 : 0) != 0, (Object)("Key must have an order-preserving data type to be used as sort key: " + t));
        }
        return StandardRelationTypeMaker.checkSignature(sig);
    }

    private static long[] checkSignature(List<RelationType> sig) {
        Preconditions.checkArgument((sig.size() == Sets.newHashSet(sig).size() ? 1 : 0) != 0, (Object)"Signature and sort key cannot contain duplicate types");
        long[] signature = new long[sig.size()];
        for (int i = 0; i < sig.size(); ++i) {
            RelationType et = sig.get(i);
            Preconditions.checkNotNull((Object)et);
            Preconditions.checkArgument((!et.isEdgeLabel() || ((EdgeLabel)et).isUnidirected() ? 1 : 0) != 0, (String)"Label must be unidirectional: %s", (Object[])new Object[]{et.getName()});
            Preconditions.checkArgument((!et.isPropertyKey() || !((PropertyKey)et).getDataType().equals(Object.class) ? 1 : 0) != 0, (String)"Signature and sort keys must have a proper declared datatype: %s", (Object[])new Object[]{et.getName()});
            signature[i] = et.getLongId();
        }
        return signature;
    }

    protected final TypeDefinitionMap makeDefinition() {
        this.checkGeneralArguments();
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.HIDDEN, this.isHidden);
        def.setValue(TypeDefinitionCategory.SORT_KEY, this.checkSortKey(this.sortKey));
        def.setValue(TypeDefinitionCategory.SORT_ORDER, (Object)this.sortOrder);
        def.setValue(TypeDefinitionCategory.SIGNATURE, StandardRelationTypeMaker.checkSignature(this.signature));
        def.setValue(TypeDefinitionCategory.MULTIPLICITY, (Object)this.multiplicity);
        def.setValue(TypeDefinitionCategory.STATUS, (Object)this.status);
        return def;
    }

    public StandardRelationTypeMaker multiplicity(Multiplicity multiplicity) {
        Preconditions.checkNotNull((Object)((Object)multiplicity));
        this.multiplicity = multiplicity;
        return this;
    }

    @Override
    public StandardRelationTypeMaker signature(RelationType ... types) {
        Preconditions.checkArgument((types != null && types.length > 0 ? 1 : 0) != 0);
        this.signature.addAll(Arrays.asList(types));
        return this;
    }

    public StandardRelationTypeMaker status(SchemaStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0);
        this.status = status;
        return this;
    }

    public StandardRelationTypeMaker sortKey(RelationType ... types) {
        Preconditions.checkArgument((types != null && types.length > 0 ? 1 : 0) != 0);
        this.sortKey.addAll(Arrays.asList(types));
        return this;
    }

    public StandardRelationTypeMaker sortOrder(Order order) {
        Preconditions.checkNotNull((Object)((Object)order));
        this.sortOrder = order;
        return this;
    }

    public StandardRelationTypeMaker name(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        this.name = name;
        return this;
    }

    public StandardRelationTypeMaker hidden() {
        this.isHidden = true;
        return this;
    }
}

