/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import org.jibx.binding.Utility;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.runtime.JiBXException;
import org.jibx.util.ClasspathUrlExtender;

public class Loader
extends URLClassLoader {
    private ArrayList m_bindings = new ArrayList();
    private boolean m_isBound;
    private HashMap m_classMap = new HashMap();

    public Loader(URL[] paths, ClassLoader parent) {
        super(paths, parent);
        ArrayList<String> fpaths = new ArrayList<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            URL path = paths[i];
            if (!"file".equals(path.getProtocol())) continue;
            fpaths.add(path.getPath());
        }
        String[] dirs = fpaths.toArray(new String[0]);
        ClassCache.setPaths(dirs);
        ClassFile.setPaths(dirs);
        ClasspathUrlExtender.setClassLoader(ClassFile.getClassLoader());
        BoundClass.reset();
        MungedClass.reset();
        BindingDefinition.reset();
    }

    public Loader(URL[] paths) {
        this(paths, ClassLoader.getSystemClassLoader().getParent());
    }

    public Loader() throws MalformedURLException {
        this(Loader.getClassPaths());
    }

    public void reset() {
        this.m_bindings.clear();
        this.m_classMap.clear();
        this.m_isBound = false;
        BoundClass.reset();
        MungedClass.reset();
        BindingDefinition.reset();
    }

    public static URL[] getClassPaths() throws MalformedURLException {
        String[] paths = Utility.getClassPaths();
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = new File(paths[i]).toURI().toURL();
        }
        return urls;
    }

    public void loadBinding(String fname, String sname, InputStream is, URL url) throws JiBXException, IOException {
        if (this.m_isBound) {
            throw new IllegalStateException("Call not allowed after bindings compiled");
        }
        this.m_bindings.add(Utility.loadBinding(fname, sname, is, url, true));
    }

    public void loadFileBinding(String path) throws JiBXException, IOException {
        if (this.m_isBound) {
            throw new IllegalStateException("Call not allowed after bindings compiled");
        }
        this.m_bindings.add(Utility.loadFileBinding(path, true));
    }

    public void loadResourceBinding(String path) throws JiBXException, IOException {
        InputStream is;
        if (this.m_isBound) {
            throw new IllegalStateException("Call not allowed after bindings compiled");
        }
        String fname = path;
        int split = fname.lastIndexOf(47);
        if (split >= 0) {
            fname = fname.substring(split + 1);
        }
        if ((is = this.getResourceAsStream(path)) == null) {
            throw new IOException("Resource " + path + " not found");
        }
        String bname = Utility.bindingFromFileName(fname);
        this.loadBinding(fname, bname, is, null);
    }

    public void processBindings() throws JiBXException {
        if (!this.m_isBound) {
            int i;
            int count = this.m_bindings.size();
            for (int i2 = 0; i2 < count; ++i2) {
                BindingDefinition binding = (BindingDefinition)this.m_bindings.get(i2);
                binding.generateCode(false, false);
            }
            ClassFile[][] lists = MungedClass.fixDispositions();
            for (i = 0; i < count; ++i) {
                BindingDefinition binding = (BindingDefinition)this.m_bindings.get(i);
                binding.addClassList(lists[0], lists[1]);
            }
            count = lists[0].length;
            for (i = 0; i < count; ++i) {
                ClassFile clas = lists[0][i];
                this.m_classMap.put(clas.getName(), clas);
            }
            this.m_isBound = true;
        }
    }

    protected boolean isBoundClass(String name) {
        if (!this.m_isBound) {
            try {
                this.processBindings();
            }
            catch (JiBXException e) {
                e.printStackTrace();
            }
        }
        return this.m_classMap.containsKey(name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.isBoundClass(name)) {
            try {
                ClassFile clas = (ClassFile)this.m_classMap.get(name);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                clas.writeFile(bos);
                byte[] bytes = bos.toByteArray();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Unable to load modified class " + name);
            }
        }
        return super.findClass(name);
    }

    public static class NondelegatingLoader
    extends Loader {
        public NondelegatingLoader() throws MalformedURLException {
            super(NondelegatingLoader.getClassPaths(), ClassLoader.getSystemClassLoader());
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.isBoundClass(name)) {
                Class clas = this.findLoadedClass(name);
                if (clas == null) {
                    clas = this.findClass(name);
                }
                return clas;
            }
            return super.loadClass(name, resolve);
        }
    }
}

