/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi.migrator;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.handler.MessageContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.handler.MEPContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigrator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationContextMigratorUtil {
    private static final Log log = LogFactory.getLog(ApplicationContextMigrator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addApplicationContextMigrator(ConfigurationContext configurationContext, String contextMigratorListID, ApplicationContextMigrator migrator) {
        LinkedList<ApplicationContextMigrator> migratorList = (LinkedList<ApplicationContextMigrator>)configurationContext.getProperty(contextMigratorListID);
        if (migratorList == null) {
            migratorList = new LinkedList<ApplicationContextMigrator>();
            configurationContext.setProperty(contextMigratorListID, migratorList);
        }
        LinkedList<ApplicationContextMigrator> linkedList = migratorList;
        synchronized (linkedList) {
            ListIterator itr = migratorList.listIterator();
            while (itr.hasNext()) {
                ApplicationContextMigrator m = (ApplicationContextMigrator)itr.next();
                if (!m.getClass().equals(migrator.getClass())) continue;
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding ApplicationContextMigrator: " + migrator.getClass().getName()));
            }
            migratorList.add(migrator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performMigrationToMessageContext(String contextMigratorListID, Map<String, Object> requestContext, MessageContext messageContext) {
        ConfigurationContext configCtx;
        List migratorList;
        if (messageContext == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"nullMsgCtxErr"));
        }
        ServiceDescription sd = messageContext.getEndpointDescription().getServiceDescription();
        if (sd != null && (migratorList = (List)(configCtx = sd.getAxisConfigContext()).getProperty(contextMigratorListID)) != null) {
            ArrayList listCPM = null;
            List list = migratorList;
            synchronized (list) {
                listCPM = new ArrayList(migratorList);
            }
            ListIterator itr = listCPM.listIterator();
            while (itr.hasNext()) {
                ApplicationContextMigrator cpm = (ApplicationContextMigrator)itr.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("migrator: " + cpm.getClass().getName() + ".migratePropertiesToMessageContext"));
                }
                cpm.migratePropertiesToMessageContext(new ApplicationPropertyMapReader(requestContext, messageContext.getMEPContext()), messageContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performMigrationFromMessageContext(String contextMigratorListID, Map<String, Object> responseContext, MessageContext messageContext) {
        ConfigurationContext configCtx;
        List migratorList;
        if (messageContext == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"nullMsgCtxErr"));
        }
        ServiceDescription sd = messageContext.getEndpointDescription().getServiceDescription();
        if (sd != null && (migratorList = (List)(configCtx = sd.getAxisConfigContext()).getProperty(contextMigratorListID)) != null) {
            ArrayList listCPM = null;
            List list = migratorList;
            synchronized (list) {
                listCPM = new ArrayList(migratorList);
            }
            ListIterator itr = listCPM.listIterator();
            while (itr.hasNext()) {
                ApplicationContextMigrator cpm = (ApplicationContextMigrator)itr.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("migrator: " + cpm.getClass().getName() + ".migratePropertiesFromMessageContext"));
                }
                cpm.migratePropertiesFromMessageContext(new ApplicationPropertyMapWriter(responseContext, messageContext.getMEPContext()), messageContext);
            }
        }
    }

    private static class ApplicationPropertyMapWriter
    extends HashMap<String, Object> {
        private Map<String, Object> userMap;
        private MEPContext mepCtx;

        public ApplicationPropertyMapWriter(Map<String, Object> userMap, MEPContext mepCtx) {
            this.userMap = userMap;
            this.mepCtx = mepCtx;
        }

        @Override
        public Object put(String key, Object value) {
            if (this.mepCtx.getScope(key) == MessageContext.Scope.APPLICATION) {
                return this.userMap.put(key, value);
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public boolean containsKey(Object key) {
            if (this.mepCtx.getScope((String)key) == MessageContext.Scope.APPLICATION) {
                return this.userMap.containsKey(key);
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.userMap.containsValue(value);
        }

        @Override
        public Set entrySet() {
            return this.userMap.entrySet();
        }

        @Override
        public Object get(Object key) {
            return this.userMap.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.userMap.isEmpty();
        }

        @Override
        public Set keySet() {
            return this.userMap.keySet();
        }

        @Override
        public Object remove(Object key) {
            return this.userMap.remove(key);
        }

        @Override
        public int size() {
            return this.userMap.size();
        }

        @Override
        public Collection values() {
            return this.userMap.values();
        }
    }

    private static class ApplicationPropertyMapReader
    extends HashMap<String, Object> {
        private Map<String, Object> userMap;
        private MEPContext mepCtx;

        public ApplicationPropertyMapReader(Map<String, Object> userMap, MEPContext mepCtx) {
            this.userMap = userMap;
            this.mepCtx = mepCtx;
        }

        @Override
        public Object put(String key, Object value) {
            return this.userMap.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.userMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.userMap.containsValue(value);
        }

        @Override
        public Set entrySet() {
            return new ApplicationPropertyMapEntrySet(this.userMap.entrySet(), this.mepCtx);
        }

        @Override
        public Object get(Object key) {
            Object obj = this.userMap.get(key);
            if (obj != null) {
                this.mepCtx.setScope((String)key, MessageContext.Scope.APPLICATION);
            }
            return obj;
        }

        @Override
        public boolean isEmpty() {
            return this.userMap.isEmpty();
        }

        @Override
        public Set keySet() {
            return this.userMap.keySet();
        }

        @Override
        public Object remove(Object key) {
            return this.userMap.remove(key);
        }

        @Override
        public int size() {
            return this.userMap.size();
        }

        @Override
        public Collection values() {
            return this.userMap.values();
        }

        private class EntrySetIterator
        implements Iterator {
            private Iterator containedIterator;
            private MEPContext mepCtx;

            private EntrySetIterator(Iterator containedIterator, MEPContext mepCtx) {
                this.containedIterator = containedIterator;
                this.mepCtx = mepCtx;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.containedIterator.hasNext();
            }

            public Object next() {
                Map.Entry entry = (Map.Entry)this.containedIterator.next();
                this.mepCtx.setScope((String)entry.getKey(), MessageContext.Scope.APPLICATION);
                return entry;
            }
        }

        private class ApplicationPropertyMapEntrySet
        extends AbstractSet {
            Set containedSet;
            MEPContext mepCtx;

            public ApplicationPropertyMapEntrySet(Set set, MEPContext mepCtx) {
                this.containedSet = set;
                this.mepCtx = mepCtx;
            }

            public EntrySetIterator iterator() {
                return new EntrySetIterator(this.containedSet.iterator(), this.mepCtx);
            }

            @Override
            public int size() {
                return this.containedSet.size();
            }
        }
    }
}

