/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.factory;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.common.factory.OMFactoryImpl;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.Sequence;
import org.apache.axiom.om.impl.intf.factory.AxiomElementType;
import org.apache.axiom.om.impl.intf.factory.AxiomNodeFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.intf.AxiomSOAPElement;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeaderBlock;
import org.apache.axiom.soap.impl.intf.AxiomSOAPMessage;
import org.apache.axiom.soap.impl.intf.SOAPHelper;

public abstract class SOAPFactoryImpl
extends OMFactoryImpl
implements SOAPFactory {
    private static final Sequence envelopeSequence = new Sequence(SOAPHeader.class, SOAPBody.class);

    public SOAPFactoryImpl(AxiomNodeFactory nodeFactory) {
        super(nodeFactory);
    }

    public abstract SOAPHelper getSOAPHelper();

    public final String getSoapVersionURI() {
        return this.getSOAPHelper().getEnvelopeURI();
    }

    public final SOAPVersion getSOAPVersion() {
        return this.getSOAPHelper().getVersion();
    }

    public final OMNamespace getNamespace() {
        return this.getSOAPHelper().getNamespace();
    }

    protected final <T extends AxiomSOAPElement> T createSOAPElement(AxiomElementType<T> type, OMElement parent, QName qname) {
        return this.createSOAPElement(type, parent, qname, null, -1);
    }

    protected final <T extends AxiomSOAPElement> T createSOAPElement(AxiomElementType<T> type, OMElement parent, QName qname, Sequence sequence, int pos) {
        AxiomSOAPElement element = (AxiomSOAPElement)type.create(this.nodeFactory);
        if (parent != null) {
            if (sequence != null) {
                ((AxiomElement)parent).insertChild(sequence, pos, element, false);
            } else {
                ((AxiomElement)parent).addChild(element);
            }
        }
        if (qname.getNamespaceURI().length() == 0) {
            element.initName(qname.getLocalPart(), null, true);
        } else if (parent != null) {
            element.initName(qname.getLocalPart(), parent.getNamespace(), false);
        } else {
            element.initName(qname.getLocalPart(), this.getNamespace(), true);
        }
        return (T)element;
    }

    public final SOAPMessage createSOAPMessage() {
        AxiomSOAPMessage message = this.nodeFactory.createSOAPMessage();
        message.initSOAPFactory(this);
        return message;
    }

    public final SOAPEnvelope createSOAPEnvelope() {
        return this.createSOAPEnvelope(this.getNamespace());
    }

    public final SOAPEnvelope createSOAPEnvelope(OMNamespace ns) {
        return this.createAxiomElement(this.getSOAPHelper().getEnvelopeType(), null, "Envelope", ns);
    }

    public final SOAPHeader createSOAPHeader(SOAPEnvelope parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getHeaderType(), (OMElement)parent, helper.getHeaderQName(), envelopeSequence, 0);
    }

    public final SOAPHeader createSOAPHeader() {
        return this.createSOAPHeader(null);
    }

    public final SOAPHeaderBlock createSOAPHeaderBlock(String localName, OMNamespace ns, SOAPHeader parent) {
        return this.createAxiomElement(this.getSOAPHelper().getHeaderBlockType(), (OMContainer)parent, localName, ns);
    }

    public final SOAPHeaderBlock createSOAPHeaderBlock(String localName, OMNamespace ns) {
        return this.createAxiomElement(this.getSOAPHelper().getHeaderBlockType(), null, localName, ns);
    }

    public final SOAPHeaderBlock createSOAPHeaderBlock(OMDataSource source) {
        AxiomSOAPHeaderBlock element = this.getSOAPHelper().getHeaderBlockType().create(this.nodeFactory);
        element.init(source);
        return element;
    }

    public final SOAPHeaderBlock createSOAPHeaderBlock(String localName, OMNamespace ns, OMDataSource ds) {
        AxiomSOAPHeaderBlock element = this.getSOAPHelper().getHeaderBlockType().create(this.nodeFactory);
        element.init(localName, ns, ds);
        return element;
    }

    public final SOAPHeaderBlock createSOAPHeaderBlock(OMElement element) {
        return this.importElement(element, this.getSOAPHelper().getHeaderBlockType());
    }

    public final SOAPBody createSOAPBody(SOAPEnvelope parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getBodyType(), (OMElement)parent, helper.getBodyQName(), envelopeSequence, 1);
    }

    public final SOAPBody createSOAPBody() {
        return this.createSOAPBody(null);
    }

    public final SOAPFault createSOAPFault(SOAPBody parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultType(), (OMElement)parent, helper.getFaultQName());
    }

    public final SOAPFault createSOAPFault() {
        return this.createSOAPFault(null);
    }

    public final SOAPFault createSOAPFault(SOAPBody parent, Exception e) {
        SOAPFault fault = this.createSOAPFault(parent);
        fault.setException(e);
        return fault;
    }

    public final SOAPFaultCode createSOAPFaultCode(SOAPFault parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultCodeType(), (OMElement)parent, helper.getFaultCodeQName());
    }

    public final SOAPFaultCode createSOAPFaultCode() {
        return this.createSOAPFaultCode(null);
    }

    public final SOAPFaultReason createSOAPFaultReason(SOAPFault parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultReasonType(), (OMElement)parent, helper.getFaultReasonQName());
    }

    public final SOAPFaultReason createSOAPFaultReason() {
        return this.createSOAPFaultReason(null);
    }

    public final SOAPFaultRole createSOAPFaultRole(SOAPFault parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultRoleType(), (OMElement)parent, helper.getFaultRoleQName());
    }

    public final SOAPFaultRole createSOAPFaultRole() {
        return this.createSOAPFaultRole(null);
    }

    public final SOAPFaultDetail createSOAPFaultDetail(SOAPFault parent) {
        SOAPHelper helper = this.getSOAPHelper();
        return this.createSOAPElement(helper.getFaultDetailType(), (OMElement)parent, helper.getFaultDetailQName());
    }

    public final SOAPFaultDetail createSOAPFaultDetail() {
        return this.createSOAPFaultDetail(null);
    }

    public final SOAPMessage createDefaultSOAPMessage() {
        SOAPMessage message = this.createSOAPMessage();
        SOAPEnvelope env = this.createSOAPEnvelope();
        message.addChild((OMNode)env);
        this.createSOAPBody(env);
        return message;
    }

    public final SOAPEnvelope getDefaultEnvelope() {
        SOAPEnvelope env = this.createSOAPEnvelope();
        this.createSOAPHeader(env);
        this.createSOAPBody(env);
        return env;
    }
}

