/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.OsgiUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkLookup {
    private static final Logger LOG = LoggerFactory.getLogger(FrameworkLookup.class);

    public static <T> Maybe<T> lookup(Class<T> clazz) {
        return FrameworkLookup.lookup(clazz, null);
    }

    public static <T> Maybe<T> lookup(Class<T> clazz, ClassLoader loader) {
        Maybe<T> result = OsgiUtil.isBrooklynInsideFramework() ? FrameworkLookup.lookupInOsgi(clazz) : FrameworkLookup.lookupViaServiceLoader(clazz, loader);
        return result;
    }

    public static <T> Iterable<T> lookupAll(Class<T> clazz) {
        return FrameworkLookup.lookupAll(clazz, null);
    }

    public static <T> Iterable<T> lookupAll(Class<T> clazz, ClassLoader loader) {
        Iterable<T> result = OsgiUtil.isBrooklynInsideFramework() ? FrameworkLookup.lookupAllInOsgi(clazz) : FrameworkLookup.lookupAllViaServiceLoader(clazz, loader);
        return result;
    }

    private static <T> ServiceLoader<T> lookupAllViaServiceLoader(Class<T> clazz, ClassLoader loader) {
        LOG.trace("Looking up all " + clazz.getSimpleName() + "  via ServiceLoader");
        if (null == loader) {
            return ServiceLoader.load(clazz);
        }
        return ServiceLoader.load(clazz, loader);
    }

    private static <T> Iterable<T> lookupAllInOsgi(Class<T> clazz) {
        ArrayList<Object> result = new ArrayList<Object>();
        Bundle bundle = FrameworkUtil.getBundle(FrameworkLookup.class);
        if (bundle != null) {
            LOG.trace("Looking up all " + clazz.getSimpleName() + " in OSGI");
            BundleContext ctx = bundle.getBundleContext();
            for (ServiceReference<T> reference : FrameworkLookup.getServiceReferences(clazz, ctx)) {
                result.add(ctx.getService(reference));
            }
        }
        return result;
    }

    private static <T> Maybe<T> lookupViaServiceLoader(Class<T> clazz, ClassLoader loader) {
        LOG.trace("Looking up " + clazz.getSimpleName() + "  via ServiceLoader");
        Maybe result = Maybe.absent((String)("No class " + clazz.getSimpleName() + " found with ServiceLoader"));
        ServiceLoader<T> LOADER = FrameworkLookup.lookupAllViaServiceLoader(clazz, loader);
        Iterator<T> iterator = LOADER.iterator();
        if (iterator.hasNext()) {
            T item = iterator.next();
            return Maybe.of(item);
        }
        return result;
    }

    private static <T> Maybe<T> lookupInOsgi(Class<T> clazz) {
        Maybe result = Maybe.absent((String)("No class " + clazz.getSimpleName() + " found with OSGI"));
        Bundle bundle = FrameworkUtil.getBundle(FrameworkLookup.class);
        if (bundle != null) {
            LOG.trace("Looking up " + clazz.getSimpleName() + " in OSGI");
            BundleContext ctx = bundle.getBundleContext();
            ServiceReference reference = ctx.getServiceReference(clazz);
            Object service = ctx.getService(reference);
            result = Maybe.of((Object)service);
        }
        return result;
    }

    private static <T> Collection<ServiceReference<T>> getServiceReferences(Class<T> clazz, BundleContext ctx) {
        try {
            return ctx.getServiceReferences(clazz, null);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

