/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.listing;

import io.swagger.annotations.ApiOperation;
import io.swagger.config.FilterFactory;
import io.swagger.config.Scanner;
import io.swagger.config.ScannerFactory;
import io.swagger.config.SwaggerConfig;
import io.swagger.core.filter.SpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.JaxrsScanner;
import io.swagger.jaxrs.config.ReaderConfigUtils;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ApiListingResource {
    private static volatile boolean initialized = false;
    Logger LOGGER = LoggerFactory.getLogger(ApiListingResource.class);
    @Context
    ServletContext context;

    protected synchronized Swagger scan(Application app, ServletConfig sc) {
        Swagger swagger = null;
        Scanner scanner = ScannerFactory.getScanner();
        this.LOGGER.debug("using scanner " + scanner);
        if (scanner != null) {
            Set<Class<?>> classes;
            SwaggerSerializers.setPrettyPrint(scanner.getPrettyPrint());
            swagger = (Swagger)this.context.getAttribute("swagger");
            if (scanner instanceof JaxrsScanner) {
                JaxrsScanner jaxrsScanner = (JaxrsScanner)scanner;
                classes = jaxrsScanner.classesFromContext(app, sc);
            } else {
                classes = scanner.classes();
            }
            if (classes != null) {
                Reader reader = new Reader(swagger, ReaderConfigUtils.getReaderConfig(this.context));
                swagger = reader.read(classes);
                if (scanner instanceof SwaggerConfig) {
                    swagger = ((SwaggerConfig)scanner).configure(swagger);
                } else {
                    SwaggerConfig configurator = (SwaggerConfig)this.context.getAttribute("reader");
                    if (configurator != null) {
                        this.LOGGER.debug("configuring swagger with " + configurator);
                        configurator.configure(swagger);
                    } else {
                        this.LOGGER.debug("no configurator");
                    }
                }
                this.context.setAttribute("swagger", (Object)swagger);
            }
        }
        initialized = true;
        return swagger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Swagger process(Application app, ServletConfig sc, HttpHeaders headers, UriInfo uriInfo) {
        Swagger swagger = (Swagger)this.context.getAttribute("swagger");
        Class<ApiListingResource> clazz = ApiListingResource.class;
        synchronized (ApiListingResource.class) {
            SwaggerSpecFilter filterImpl;
            if (!initialized) {
                swagger = this.scan(app, sc);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (swagger != null && (filterImpl = FilterFactory.getFilter()) != null) {
                SpecFilter f = new SpecFilter();
                swagger = f.filter(swagger, filterImpl, this.getQueryParams((MultivaluedMap<String, String>)uriInfo.getQueryParameters()), this.getCookies(headers), this.getHeaders(headers));
            }
            return swagger;
        }
    }

    @GET
    @Produces(value={"application/json", "application/yaml"})
    @ApiOperation(value="The swagger definition in either JSON or YAML", hidden=true)
    @Path(value="/swagger.{type:json|yaml}")
    public Response getListing(@Context Application app, @Context ServletConfig sc, @Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="type") String type) {
        if (StringUtils.isNotBlank((CharSequence)type) && type.trim().equalsIgnoreCase("yaml")) {
            return this.getListingYaml(app, sc, headers, uriInfo);
        }
        return this.getListingJson(app, sc, headers, uriInfo);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/swagger")
    @ApiOperation(value="The swagger definition in JSON", hidden=true)
    public Response getListingJson(@Context Application app, @Context ServletConfig sc, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Swagger swagger = this.process(app, sc, headers, uriInfo);
        if (swagger != null) {
            return Response.ok().entity((Object)swagger).build();
        }
        return Response.status((int)404).build();
    }

    @GET
    @Produces(value={"application/yaml"})
    @Path(value="/swagger")
    @ApiOperation(value="The swagger definition in YAML", hidden=true)
    public Response getListingYaml(@Context Application app, @Context ServletConfig sc, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Swagger swagger = this.process(app, sc, headers, uriInfo);
        try {
            if (swagger != null) {
                String[] parts;
                String yaml = Yaml.mapper().writeValueAsString((Object)swagger);
                StringBuilder b = new StringBuilder();
                for (String part : parts = yaml.split("\n")) {
                    b.append(part);
                    b.append("\n");
                }
                return Response.ok().entity((Object)b.toString()).type("application/yaml").build();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.status((int)404).build();
    }

    protected Map<String, List<String>> getQueryParams(MultivaluedMap<String, String> params) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (params != null) {
            for (String key : params.keySet()) {
                List values = (List)params.get((Object)key);
                output.put(key, values);
            }
        }
        return output;
    }

    protected Map<String, String> getCookies(HttpHeaders headers) {
        HashMap<String, String> output = new HashMap<String, String>();
        if (headers != null) {
            for (String key : headers.getCookies().keySet()) {
                Cookie cookie = (Cookie)headers.getCookies().get(key);
                output.put(key, cookie.getValue());
            }
        }
        return output;
    }

    protected Map<String, List<String>> getHeaders(HttpHeaders headers) {
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        if (headers != null) {
            for (String key : headers.getRequestHeaders().keySet()) {
                List values = (List)headers.getRequestHeaders().get((Object)key);
                output.put(key, values);
            }
        }
        return output;
    }
}

