/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.google.inject.CreationException;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.jclouds.concurrent.TransformParallelException;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.RateLimitExceededException;
import org.jclouds.rest.ResourceAlreadyExistsException;
import org.jclouds.rest.ResourceNotFoundException;

public class Throwables2 {
    private static final ImmutableList<Class<? extends Throwable>> PROPAGATABLE_EXCEPTION_TYPES = ImmutableList.of(IllegalStateException.class, AssertionError.class, UnsupportedOperationException.class, IllegalArgumentException.class, AuthorizationException.class, ResourceAlreadyExistsException.class, ResourceNotFoundException.class, InsufficientResourcesException.class, RateLimitExceededException.class, ConcurrentModificationException.class, HttpResponseException.class);

    public static <T extends Throwable> Predicate<Throwable> containsThrowable(final Class<T> throwableType) {
        return new Predicate<Throwable>(){

            public boolean apply(Throwable input) {
                return Throwables2.getFirstThrowableOfType(input, throwableType) != null;
            }

            public String toString() {
                return "containsThrowable()";
            }
        };
    }

    public static <T extends Throwable> T getFirstThrowableOfType(Throwable from, Class<T> clazz) {
        if (from instanceof ProvisionException) {
            return Throwables2.getFirstThrowableOfType((ProvisionException)((Object)ProvisionException.class.cast(from)), clazz);
        }
        if (from instanceof TransformParallelException) {
            return Throwables2.getFirstThrowableOfType((TransformParallelException)TransformParallelException.class.cast(from), clazz);
        }
        if (from instanceof CreationException) {
            return Throwables2.getFirstThrowableOfType((CreationException)CreationException.class.cast(from), clazz);
        }
        try {
            return (T)((Throwable)Iterables.find((Iterable)Throwables.getCausalChain((Throwable)from), (Predicate)Predicates.instanceOf(clazz)));
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @VisibleForTesting
    static <T extends Throwable> T getFirstThrowableOfType(TransformParallelException e, Class<T> clazz) {
        for (Exception exception : e.getFromToException().values()) {
            T cause = Throwables2.getFirstThrowableOfType(exception, clazz);
            if (cause == null) continue;
            return cause;
        }
        return null;
    }

    @VisibleForTesting
    static <T extends Throwable> T getFirstThrowableOfType(ProvisionException e, Class<T> clazz) {
        for (Message message : e.getErrorMessages()) {
            if (message.getCause() == null) continue;
            T cause = Throwables2.getFirstThrowableOfType(message.getCause(), clazz);
            if (cause instanceof ProvisionException) {
                return Throwables2.getFirstThrowableOfType((ProvisionException)((Object)ProvisionException.class.cast(cause)), clazz);
            }
            if (cause instanceof TransformParallelException) {
                return Throwables2.getFirstThrowableOfType((TransformParallelException)TransformParallelException.class.cast(cause), clazz);
            }
            if (cause instanceof CreationException) {
                return Throwables2.getFirstThrowableOfType((CreationException)CreationException.class.cast(cause), clazz);
            }
            return cause;
        }
        return null;
    }

    @VisibleForTesting
    static <T extends Throwable> T getFirstThrowableOfType(CreationException e, Class<T> clazz) {
        for (Message message : e.getErrorMessages()) {
            if (message.getCause() == null) continue;
            T cause = Throwables2.getFirstThrowableOfType(message.getCause(), clazz);
            if (cause instanceof ProvisionException) {
                return Throwables2.getFirstThrowableOfType((ProvisionException)((Object)ProvisionException.class.cast(cause)), clazz);
            }
            if (cause instanceof TransformParallelException) {
                return Throwables2.getFirstThrowableOfType((TransformParallelException)TransformParallelException.class.cast(cause), clazz);
            }
            if (cause instanceof CreationException) {
                return Throwables2.getFirstThrowableOfType((CreationException)CreationException.class.cast(cause), clazz);
            }
            return cause;
        }
        return null;
    }

    public static <T> T propagateAuthorizationOrOriginalException(Exception e) {
        AuthorizationException aex = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
        if (aex != null) {
            throw aex;
        }
        throw Throwables.propagate((Throwable)e);
    }

    public static void propagateIfPossible(Throwable exception, Iterable<TypeToken<? extends Throwable>> throwables) throws Throwable {
        Object throwable;
        for (TypeToken<? extends Throwable> type : throwables) {
            throwable = Throwables2.getFirstThrowableOfType(exception, type.getRawType());
            if (throwable == null) continue;
            throw throwable;
        }
        for (Class propagatableExceptionType : PROPAGATABLE_EXCEPTION_TYPES) {
            throwable = Throwables2.getFirstThrowableOfType(exception, propagatableExceptionType);
            if (throwable == null) continue;
            throw throwable;
        }
    }
}

