/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.loadbalancing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.policy.loadbalancing.BalanceablePoolModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBalanceablePoolModel<ContainerType, ItemType>
implements BalanceablePoolModel<ContainerType, ItemType> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBalanceablePoolModel.class);
    private static final String NULL_CONTAINER = "null-container";
    private final String name;
    private final Set<ContainerType> containers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<ContainerType, Double> containerToLowThreshold = new ConcurrentHashMap<ContainerType, Double>();
    private final Map<ContainerType, Double> containerToHighThreshold = new ConcurrentHashMap<ContainerType, Double>();
    private final Map<ItemType, ContainerType> itemToContainer = new ConcurrentHashMap<ItemType, ContainerType>();
    private final SetMultimap<ContainerType, ItemType> containerToItems = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final Map<ItemType, Double> itemToWorkrate = new ConcurrentHashMap<ItemType, Double>();
    private final Set<ItemType> immovableItems = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile double poolLowThreshold = 0.0;
    private volatile double poolHighThreshold = 0.0;
    private volatile double currentPoolWorkrate = 0.0;

    public DefaultBalanceablePoolModel(String name) {
        this.name = name;
    }

    public ContainerType getParentContainer(ItemType item) {
        ContainerType result = this.itemToContainer.get(item);
        return (ContainerType)(result != NULL_CONTAINER ? result : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ItemType> getItemsForContainer(ContainerType node) {
        Set result = this.containerToItems.get(node);
        SetMultimap<ContainerType, ItemType> setMultimap = this.containerToItems;
        synchronized (setMultimap) {
            return result != null ? ImmutableSet.copyOf((Collection)result) : Collections.emptySet();
        }
    }

    public Double getItemWorkrate(ItemType item) {
        return this.itemToWorkrate.get(item);
    }

    @Override
    public double getPoolLowThreshold() {
        return this.poolLowThreshold;
    }

    @Override
    public double getPoolHighThreshold() {
        return this.poolHighThreshold;
    }

    @Override
    public double getCurrentPoolWorkrate() {
        return this.currentPoolWorkrate;
    }

    @Override
    public boolean isHot() {
        return !this.containers.isEmpty() && this.currentPoolWorkrate > this.poolHighThreshold;
    }

    @Override
    public boolean isCold() {
        return !this.containers.isEmpty() && this.currentPoolWorkrate < this.poolLowThreshold;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPoolSize() {
        return this.containers.size();
    }

    @Override
    public Set<ContainerType> getPoolContents() {
        return this.containers;
    }

    @Override
    public String getName(ContainerType container) {
        return container.toString();
    }

    @Override
    public Location getLocation(ContainerType container) {
        return null;
    }

    @Override
    public double getLowThreshold(ContainerType container) {
        Double result = this.containerToLowThreshold.get(container);
        return result != null ? result : -1.0;
    }

    @Override
    public double getHighThreshold(ContainerType container) {
        Double result = this.containerToHighThreshold.get(container);
        return result != null ? result : -1.0;
    }

    @Override
    public double getTotalWorkrate(ContainerType container) {
        double totalWorkrate = 0.0;
        for (ItemType item : this.getItemsForContainer(container)) {
            Double workrate = this.itemToWorkrate.get(item);
            if (workrate == null) continue;
            totalWorkrate += Math.abs(workrate);
        }
        return totalWorkrate;
    }

    @Override
    public Map<ContainerType, Double> getContainerWorkrates() {
        LinkedHashMap<ContainerType, Double> result = new LinkedHashMap<ContainerType, Double>();
        for (ContainerType node : this.containers) {
            result.put(node, this.getTotalWorkrate(node));
        }
        return result;
    }

    @Override
    public Map<ItemType, Double> getItemWorkrates(ContainerType node) {
        LinkedHashMap<ItemType, Double> result = new LinkedHashMap<ItemType, Double>();
        for (ItemType item : this.getItemsForContainer(node)) {
            result.put(item, this.itemToWorkrate.get(item));
        }
        return result;
    }

    @Override
    public boolean isItemMoveable(ItemType item) {
        return this.itemToContainer.containsKey(item) && !this.immovableItems.contains(item);
    }

    @Override
    public boolean isItemAllowedIn(ItemType item, Location location) {
        return true;
    }

    @Override
    public void onItemMoved(ItemType item, ContainerType newNode) {
        if (!this.itemToContainer.containsKey(item)) {
            LOG.info("Balanceable pool model ignoring onItemMoved for unknown item {} to container {}; if onItemAdded subsequently received will get new container then", item, newNode);
            return;
        }
        ContainerType newNodeNonNull = this.toNonNullContainer(newNode);
        ContainerType oldNode = this.itemToContainer.put(item, newNodeNonNull);
        if (oldNode != null && oldNode != NULL_CONTAINER) {
            this.containerToItems.remove(oldNode, item);
        }
        if (newNode != null) {
            this.containerToItems.put(newNode, item);
        }
    }

    @Override
    public void onContainerAdded(ContainerType newContainer, double lowThreshold, double highThreshold) {
        boolean added = this.containers.add(newContainer);
        if (!added) {
            LOG.debug("Duplicate container-added event for {}; ignoring", newContainer);
            return;
        }
        this.containerToLowThreshold.put(newContainer, lowThreshold);
        this.containerToHighThreshold.put(newContainer, highThreshold);
        this.poolLowThreshold += lowThreshold;
        this.poolHighThreshold += highThreshold;
    }

    @Override
    public void onContainerRemoved(ContainerType oldContainer) {
        this.containers.remove(oldContainer);
        Double containerLowThreshold = this.containerToLowThreshold.remove(oldContainer);
        Double containerHighThresold = this.containerToHighThreshold.remove(oldContainer);
        this.poolLowThreshold -= containerLowThreshold != null ? containerLowThreshold : 0.0;
        this.poolHighThreshold -= containerHighThresold != null ? containerHighThresold : 0.0;
    }

    @Override
    public void onItemAdded(ItemType item, ContainerType parentContainer) {
        this.onItemAdded(item, parentContainer, false);
    }

    @Override
    public void onItemAdded(ItemType item, ContainerType parentContainer, boolean immovable) {
        ContainerType parentContainerNonNull;
        ContainerType oldNode;
        if (immovable) {
            this.immovableItems.add(item);
        }
        if ((oldNode = this.itemToContainer.put(item, parentContainerNonNull = this.toNonNullContainer(parentContainer))) != null && oldNode != NULL_CONTAINER) {
            this.containerToItems.remove(oldNode, item);
        }
        if (parentContainer != null) {
            this.containerToItems.put(parentContainer, item);
        }
    }

    @Override
    public void onItemRemoved(ItemType item) {
        Double workrate;
        ContainerType oldNode = this.itemToContainer.remove(item);
        if (oldNode != null && oldNode != NULL_CONTAINER) {
            this.containerToItems.remove(oldNode, item);
        }
        if ((workrate = this.itemToWorkrate.remove(item)) != null) {
            this.currentPoolWorkrate -= workrate.doubleValue();
        }
        this.immovableItems.remove(item);
    }

    @Override
    public void onItemWorkrateUpdated(ItemType item, double newValue) {
        if (this.hasItem(item)) {
            Double oldValue = this.itemToWorkrate.put(item, newValue);
            double delta = newValue - (oldValue != null ? oldValue : 0.0);
            this.currentPoolWorkrate += delta;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring setting of workrate for unknown item {}, to {}", item, (Object)newValue);
        }
    }

    private boolean hasItem(ItemType item) {
        return this.itemToContainer.containsKey(item);
    }

    @VisibleForTesting
    public String itemDistributionToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.dumpItemDistribution(new PrintStream(baos));
        return new String(baos.toByteArray());
    }

    @VisibleForTesting
    public void dumpItemDistribution() {
        this.dumpItemDistribution(System.out);
    }

    @VisibleForTesting
    public void dumpItemDistribution(PrintStream out) {
        for (ContainerType container : this.getPoolContents()) {
            out.println("Container '" + container + "': ");
            for (ItemType item : this.getItemsForContainer(container)) {
                Double workrate = this.getItemWorkrate(item);
                out.println("\tItem '" + item + "' (" + workrate + ")");
            }
        }
        out.flush();
    }

    private ContainerType nullContainer() {
        return (ContainerType)NULL_CONTAINER;
    }

    private ContainerType toNonNullContainer(ContainerType container) {
        return container != null ? container : this.nullContainer();
    }
}

