/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.catalog.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.LocationsSupplier;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.location.suppliers.RegionIdsSupplier;
import org.jclouds.location.suppliers.all.RegionToProvider;
import org.jclouds.location.suppliers.derived.RegionIdsFromRegionIdToURIKeySet;
import org.jclouds.location.suppliers.implicit.FirstRegion;
import org.jclouds.openstack.keystone.catalog.ServiceEndpoint;
import org.jclouds.openstack.keystone.catalog.suppliers.LocationIdToURIFromServiceEndpointsForTypeAndVersion;
import org.jclouds.openstack.keystone.catalog.suppliers.RegionIdToAdminURIFromServiceEndpointsForTypeAndVersion;
import org.jclouds.openstack.keystone.catalog.suppliers.RegionIdToAdminURISupplier;
import org.jclouds.openstack.keystone.catalog.suppliers.RegionIdToURIFromServiceEndpointsForTypeAndVersion;
import org.jclouds.openstack.keystone.v2_0.catalog.V2ServiceCatalog;
import org.jclouds.openstack.keystone.v3.catalog.V3ServiceCatalog;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Suppliers2;

public class ServiceCatalogModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    protected final Supplier<List<ServiceEndpoint>> provideServiceCatalog(Injector i, @Named(value="jclouds.keystone.version") String keystoneVersion) {
        HashMap serviceCatalogs = Maps.newHashMap();
        serviceCatalogs.put("2", i.getInstance(V2ServiceCatalog.class));
        serviceCatalogs.put("3", i.getInstance(V3ServiceCatalog.class));
        return (Supplier)serviceCatalogs.get(keystoneVersion);
    }

    public static class RegionModule
    extends AbstractModule {
        protected void configure() {
            this.install(new FactoryModuleBuilder().implement(RegionIdToURISupplier.class, RegionIdToURIFromServiceEndpointsForTypeAndVersion.class).build(RegionIdToURISupplier.Factory.class));
            this.install(new FactoryModuleBuilder().implement(RegionIdToAdminURISupplier.class, RegionIdToAdminURIFromServiceEndpointsForTypeAndVersion.class).build(RegionIdToAdminURISupplier.Factory.class));
            this.bind(RegionIdsSupplier.class).to(RegionIdsFromRegionIdToURIKeySet.class);
            this.bind(ImplicitLocationSupplier.class).to(FirstRegion.class).in(Scopes.SINGLETON);
            this.bind(LocationsSupplier.class).to(RegionToProvider.class).in(Scopes.SINGLETON);
        }

        @Provides
        @Singleton
        protected final RegionIdToURISupplier guiceProvideRegionIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToURISupplier.Factory factory) {
            return this.provideRegionIdToURISupplierForApiVersion(serviceType, apiVersion, factory);
        }

        protected RegionIdToURISupplier provideRegionIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }

        @Provides
        @Singleton
        protected final RegionIdToAdminURISupplier guiceProvideRegionIdToAdminURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToAdminURISupplier.Factory factory) {
            return this.provideRegionIdToAdminURISupplierForApiVersion(serviceType, apiVersion, factory);
        }

        protected RegionIdToAdminURISupplier provideRegionIdToAdminURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, RegionIdToAdminURISupplier.Factory factory) {
            return factory.createForApiTypeAndVersion(serviceType, apiVersion);
        }
    }

    public static class ProviderModule
    extends AbstractModule {
        protected void configure() {
            this.install(new FactoryModuleBuilder().build(LocationIdToURIFromServiceEndpointsForTypeAndVersion.Factory.class));
        }

        @Provides
        @Singleton
        protected final Supplier<URI> provideZoneIdToURISupplierForApiVersion(@Named(value="jclouds.keystone.service-type") String serviceType, @ApiVersion String apiVersion, LocationIdToURIFromServiceEndpointsForTypeAndVersion.Factory factory) {
            return Suppliers2.getLastValueInMap((Supplier)factory.createForApiTypeAndVersion(serviceType, apiVersion));
        }

        @Provides
        @Singleton
        final Function<ServiceEndpoint, String> provideProvider(final @Provider String provider) {
            return new Function<ServiceEndpoint, String>(){

                public String apply(ServiceEndpoint in) {
                    return provider;
                }
            };
        }
    }
}

