/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.functions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.openstack.keystone.v2_0.config.NamespaceAliases;
import org.jclouds.openstack.v2_0.predicates.ExtensionPredicates;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.reflect.InvocationSuccess;
import org.jclouds.rest.functions.ImplicitOptionalConverter;
import org.jclouds.util.Optionals2;

public class PresentWhenExtensionAnnotationMatchesExtensionSet
implements ImplicitOptionalConverter {
    private final LoadingCache<String, Set<? extends org.jclouds.openstack.v2_0.domain.Extension>> extensions;
    private final Map<URI, Set<URI>> aliases;

    @Inject
    PresentWhenExtensionAnnotationMatchesExtensionSet(LoadingCache<String, Set<? extends org.jclouds.openstack.v2_0.domain.Extension>> extensions, @NamespaceAliases Map<URI, Set<URI>> aliases) {
        this.extensions = extensions;
        this.aliases = aliases == null ? ImmutableMap.of() : ImmutableMap.copyOf(aliases);
    }

    private boolean checkExtension(String invocationArg, URI namespace, Set<URI> aliasesForNamespace, String alias, String name) {
        if (Iterables.any((Iterable)((Iterable)this.extensions.getUnchecked((Object)invocationArg)), ExtensionPredicates.namespaceOrAliasEquals(namespace, aliasesForNamespace))) {
            return true;
        }
        if (!"".equals(alias) && Iterables.any((Iterable)((Iterable)this.extensions.getUnchecked((Object)invocationArg)), ExtensionPredicates.aliasEquals(alias))) {
            return true;
        }
        return !"".equals(name) && Iterables.any((Iterable)((Iterable)this.extensions.getUnchecked((Object)invocationArg)), ExtensionPredicates.nameEquals(name));
    }

    public Optional<Object> apply(InvocationSuccess input) {
        Class target = Optionals2.unwrapIfOptional((TypeToken)input.getInvocation().getInvokable().getReturnType());
        Optional ext = Optional.fromNullable((Object)target.getAnnotation(Extension.class));
        if (ext.isPresent()) {
            URI namespace = URI.create(((Extension)ext.get()).namespace());
            List args = input.getInvocation().getArgs();
            HashSet aliasesForNamespace = this.aliases.containsKey(namespace) ? this.aliases.get(namespace) : Sets.newHashSet();
            String name = ((Extension)ext.get()).name();
            String alias = ((Extension)ext.get()).alias();
            if (args.isEmpty()) {
                if (this.checkExtension("", namespace, aliasesForNamespace, alias, name)) {
                    return input.getResult();
                }
            } else if (args.size() == 1) {
                String arg0 = Preconditions.checkNotNull(args.get(0), (String)"arg[0] in %s", (Object[])new Object[]{input}).toString();
                if (this.checkExtension(arg0, namespace, aliasesForNamespace, alias, name)) {
                    return input.getResult();
                }
            } else {
                throw new RuntimeException(String.format("expecting zero or one args %s", input));
            }
            return Optional.absent();
        }
        return input.getResult();
    }

    public String toString() {
        return "PresentWhenExtensionAnnotationMatchesExtensionSet()";
    }
}

