/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.config;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.config.ConfigValueAtContainer;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.guava.Maybe;

public class ConfigInheritances {
    public static <TContainer, TValue> ReferenceWithError<ConfigValueAtContainer<TContainer, TValue>> resolveInheriting(@Nullable TContainer container, ConfigKey<TValue> key, @Nullable Maybe<TValue> localValue, @Nullable Maybe<TValue> defaultValue, Iterator<? extends ConfigValueAtContainer<TContainer, TValue>> ancestorContainerKeyValues, ConfigInheritance.ConfigInheritanceContext context, ConfigInheritance defaultInheritance) {
        return ConfigInheritances.resolveInheriting(new BasicConfigValueAtContainer<TContainer, TValue>(container, key, localValue, localValue.isPresent(), defaultValue), ancestorContainerKeyValues, key, context, defaultInheritance);
    }

    public static <TContainer, TValue> ReferenceWithError<ConfigValueAtContainer<TContainer, TValue>> resolveInheriting(ConfigValueAtContainer<TContainer, TValue> local, Iterator<? extends ConfigValueAtContainer<TContainer, TValue>> ancestorContainerKeyValues, ConfigKey<TValue> queryKey, ConfigInheritance.ConfigInheritanceContext context, ConfigInheritance defaultInheritance) {
        ReferenceWithError<ConfigValueAtContainer<TContainer, TValue>> parentResult;
        ReferenceWithError<ConfigValueAtContainer<TContainer, TValue>> resultWithParent;
        ConfigInheritance currentInheritance;
        ConfigValueAtContainer<TContainer, TValue> parent;
        ConfigInheritance parentInheritance;
        BasicConfigValueAtContainer<TContainer, TValue> result = null;
        if (ancestorContainerKeyValues.hasNext() && ((parentInheritance = ConfigInheritances.findInheritance(parent = ancestorContainerKeyValues.next(), context, null)) == null || parentInheritance.isReinheritable(parent, context)) && (currentInheritance = ConfigInheritances.findInheritance(local, context, ConfigInheritances.findInheritance(queryKey, context, defaultInheritance))).considerParent(local, parent, context) && (resultWithParent = currentInheritance.resolveWithParent(local, (parentResult = ConfigInheritances.resolveInheriting(parent, ancestorContainerKeyValues, queryKey, context, currentInheritance)).getWithoutError(), context)) != null) {
            if (resultWithParent.getWithoutError() != null && resultWithParent.getWithoutError().isValueExplicitlySet()) {
                if (!resultWithParent.hasError() && parentResult != null && parentResult.hasError()) {
                    return ReferenceWithError.newInstanceThrowingError(resultWithParent.getWithoutError(), parentResult.getError());
                }
                return resultWithParent;
            }
            result = new BasicConfigValueAtContainer<TContainer, TValue>(resultWithParent.getWithoutError());
        }
        if (result == null) {
            result = new BasicConfigValueAtContainer<TContainer, TValue>(local);
            if (!local.isValueExplicitlySet() && local.getDefaultValue().isPresent()) {
                result.value = local.getDefaultValue();
            }
        } else if (!result.isValueExplicitlySet()) {
            result.value = result.getDefaultValue();
        }
        return ReferenceWithError.newInstanceWithoutError(result);
    }

    public static ConfigInheritance findInheritance(ConfigValueAtContainer<?, ?> local, ConfigInheritance.ConfigInheritanceContext context, ConfigInheritance defaultInheritance) {
        if (local == null) {
            return defaultInheritance;
        }
        return ConfigInheritances.findInheritance(local.getKey(), context, defaultInheritance);
    }

    public static ConfigInheritance findInheritance(ConfigKey<?> localKey, ConfigInheritance.ConfigInheritanceContext context, ConfigInheritance defaultInheritance) {
        if (localKey == null) {
            return defaultInheritance;
        }
        ConfigInheritance keyInheritance = localKey.getInheritanceByContext(context);
        if (keyInheritance == null) {
            return defaultInheritance;
        }
        return keyInheritance;
    }

    public static <T> boolean isKeyReinheritable(ConfigKey<T> key, ConfigInheritance.ConfigInheritanceContext context) {
        ConfigInheritance inh = ConfigInheritances.findInheritance(key, context, null);
        if (inh == null) {
            return true;
        }
        return inh.isReinheritable(null, null);
    }

    public static class BasicConfigValueAtContainer<TContainer, TValue>
    implements ConfigValueAtContainer<TContainer, TValue> {
        @Nullable
        TContainer container = null;
        @Nonnull
        Maybe<? extends TValue> value = Maybe.absent();
        boolean valueWasExplicitlySet = false;
        @Nullable
        ConfigKey<? extends TValue> key = null;
        @Nullable
        Maybe<TValue> defaultValue = null;

        public BasicConfigValueAtContainer() {
        }

        public BasicConfigValueAtContainer(ConfigValueAtContainer<TContainer, TValue> toCopy) {
            this(toCopy.getContainer(), toCopy.getKey(), toCopy.asMaybe(), toCopy.isValueExplicitlySet(), toCopy.getDefaultValue());
        }

        public BasicConfigValueAtContainer(@Nullable TContainer container, @Nullable ConfigKey<? extends TValue> key, @Nullable Maybe<? extends TValue> value) {
            this(container, key, value, value.isPresent());
        }

        public BasicConfigValueAtContainer(@Nullable TContainer container, @Nullable ConfigKey<? extends TValue> key, @Nullable Maybe<? extends TValue> value, boolean isValueSet) {
            this(container, key, value, isValueSet, null);
        }

        public BasicConfigValueAtContainer(@Nullable TContainer container, @Nullable ConfigKey<? extends TValue> key, @Nullable Maybe<? extends TValue> value, boolean isValueSet, @Nullable Maybe<TValue> defaultValue) {
            this.container = container;
            this.key = key;
            this.valueWasExplicitlySet = isValueSet;
            this.defaultValue = defaultValue;
            this.value = value != null && (value.isPresent() || isValueSet || this.getDefaultValue().isPresent()) ? value : this.getDefaultValue();
        }

        @Override
        public TContainer getContainer() {
            return this.container;
        }

        @Override
        public TValue get() {
            return this.value.orNull();
        }

        @Override
        public Maybe<? extends TValue> asMaybe() {
            return this.value;
        }

        @Override
        public boolean isValueExplicitlySet() {
            return this.valueWasExplicitlySet;
        }

        @Override
        public ConfigKey<? extends TValue> getKey() {
            return this.key;
        }

        public void setContainer(TContainer container) {
            this.container = container;
        }

        public void setValue(Maybe<? extends TValue> value) {
            this.value = value;
        }

        public void setValueWasExplicitlySet(boolean valueWasExplicitlySet) {
            this.valueWasExplicitlySet = valueWasExplicitlySet;
        }

        public void setKey(ConfigKey<? extends TValue> key) {
            this.key = key;
        }

        @Override
        public Maybe<TValue> getDefaultValue() {
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            return this.key != null && this.key.hasDefaultValue() ? Maybe.ofAllowingNull(this.key.getDefaultValue()) : Maybe.absent();
        }

        public String toString() {
            return super.toString() + "[key=" + this.key + "; value=" + this.value + "; container=" + this.container + "]";
        }
    }
}

