/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.guava;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;

public class AnyExceptionSupplier<T extends Throwable>
implements Supplier<T> {
    protected final Class<? extends T> type;
    protected final Supplier<String> message;
    protected final Throwable cause;

    public AnyExceptionSupplier(Class<T> type) {
        this(type, (Supplier<String>)((Supplier)null), null);
    }

    public AnyExceptionSupplier(Class<T> type, String message) {
        this(type, message, null);
    }

    public AnyExceptionSupplier(Class<T> type, Throwable cause) {
        this(type, new Exceptions.CollapseTextSupplier(cause), cause);
    }

    public AnyExceptionSupplier(Class<T> type, String message, Throwable cause) {
        this(type, (Supplier<String>)Suppliers.ofInstance((Object)message), cause);
    }

    public AnyExceptionSupplier(Class<? extends T> type, Supplier<String> message, Throwable cause) {
        this.type = type;
        this.message = message;
        this.cause = cause;
    }

    public T get() {
        String msg = this.message == null ? null : (String)this.message.get();
        Maybe<Object> result = Maybe.absent();
        if (result.isAbsent() && msg == null && this.cause == null) {
            result = Reflections.invokeConstructorFromArgs(this.type, new Object[0]);
        }
        if (result.isAbsent() && this.cause == null) {
            result = Reflections.invokeConstructorFromArgs(this.type, msg);
        }
        if (result.isAbsent() && msg == null) {
            result = Reflections.invokeConstructorFromArgs(this.type, this.cause);
        }
        if (result.isAbsent()) {
            result = Reflections.invokeConstructorFromArgs(this.type, msg, this.cause);
        }
        if (result.isAbsent()) {
            throw new IllegalStateException("Cannot create desired " + this.type + " (missing constructor)", new IllegalStateException(this.message == null ? null : (String)this.message.get(), this.cause));
        }
        return (T)((Throwable)result.get());
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Supplier<String> getMessageSupplier() {
        return this.message;
    }
}

