/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.config;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.domain.Credentials;
import org.jclouds.openstack.keystone.auth.AuthenticationApi;
import org.jclouds.openstack.keystone.auth.config.AuthenticationModule;
import org.jclouds.openstack.keystone.auth.config.CredentialTypes;
import org.jclouds.openstack.keystone.auth.domain.AuthInfo;
import org.jclouds.openstack.keystone.auth.functions.AuthenticatePasswordCredentials;
import org.jclouds.rackspace.cloudidentity.v2_0.CloudIdentityAuthenticationApi;
import org.jclouds.rackspace.cloudidentity.v2_0.functions.AuthenticateApiKeyCredentials;
import org.jclouds.rest.config.BinderUtils;

public class CloudIdentityAuthenticationModule
extends AuthenticationModule {
    protected void configure() {
        super.configure();
        BinderUtils.bindHttpApi((Binder)this.binder(), CloudIdentityAuthenticationApi.class);
    }

    protected Map<String, AuthenticationApi> authenticationApis(Injector i) {
        HashMap authenticationApis = Maps.newHashMap();
        authenticationApis.put("2", i.getInstance(CloudIdentityAuthenticationApi.class));
        authenticationApis.put("3", i.getInstance(CloudIdentityAuthenticationApi.class));
        return authenticationApis;
    }

    protected Map<String, Function<Credentials, AuthInfo>> authenticationMethods(Injector i) {
        ImmutableSet.Builder fns = ImmutableSet.builder();
        fns.add(i.getInstance(AuthenticatePasswordCredentials.class));
        fns.add(i.getInstance(AuthenticateApiKeyCredentials.class));
        return CredentialTypes.indexByCredentialType((Iterable)fns.build());
    }
}

