/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.binders;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.rest.Binder;

public class SetPayload
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Date expires;
        Long contentLength;
        HttpRequest.Builder builder = request.toBuilder();
        Payload payload = (Payload)Payload.class.cast(input);
        if (payload.getContentMetadata().getContentType() == null) {
            payload.getContentMetadata().setContentType("application/octet-stream");
        }
        if ((contentLength = payload.getContentMetadata().getContentLength()) != null && contentLength >= 0L) {
            Preconditions.checkArgument((contentLength <= 0x140000000L ? 1 : 0) != 0, (String)"maximum size for put object is 5GB, %s", (Object[])new Object[]{contentLength});
        } else {
            ((HttpRequest.Builder)builder.replaceHeader("Transfer-Encoding", new String[]{"chunked"})).build();
        }
        HashCode md5 = payload.getContentMetadata().getContentMD5AsHashCode();
        if (md5 != null) {
            builder.replaceHeader("ETag", new String[]{BaseEncoding.base16().lowerCase().encode(md5.asBytes())});
        }
        if ((expires = payload.getContentMetadata().getExpires()) != null) {
            ((HttpRequest.Builder)builder.addHeader("X-Delete-At", new String[]{String.valueOf(TimeUnit.MILLISECONDS.toSeconds(expires.getTime()))})).build();
        }
        return (R)((HttpRequest.Builder)builder.payload(payload)).build();
    }
}

