/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.classloading;

import com.google.common.base.Objects;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.classloading.AbstractBrooklynClassLoadingContext;
import org.apache.brooklyn.core.mgmt.classloading.JavaBrooklynClassLoadingContext;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrooklynClassLoadingContextSequential
extends AbstractBrooklynClassLoadingContext {
    private static final Logger log = LoggerFactory.getLogger(BrooklynClassLoadingContextSequential.class);
    private final List<BrooklynClassLoadingContext> primaries = MutableList.of();
    private final Set<BrooklynClassLoadingContext> secondaries = MutableSet.of();

    public BrooklynClassLoadingContextSequential(ManagementContext mgmt, BrooklynClassLoadingContext ... targets) {
        super(mgmt);
        for (BrooklynClassLoadingContext target : targets) {
            this.add(target);
        }
    }

    public void add(BrooklynClassLoadingContext target) {
        if (target instanceof BrooklynClassLoadingContextSequential) {
            for (BrooklynClassLoadingContext targetN : ((BrooklynClassLoadingContextSequential)target).primaries) {
                this.add(targetN);
            }
            for (BrooklynClassLoadingContext targetN : ((BrooklynClassLoadingContextSequential)target).secondaries) {
                this.addSecondary(targetN);
            }
        } else {
            this.primaries.add(target);
        }
    }

    public void addSecondary(BrooklynClassLoadingContext target) {
        if (!(target instanceof JavaBrooklynClassLoadingContext)) {
            log.warn("Only Java classloaders should be secondary");
        }
        this.secondaries.add(target);
    }

    @Override
    public Maybe<Class<?>> tryLoadClass(String className) {
        MutableList errors = MutableList.of();
        for (BrooklynClassLoadingContext target : this.primaries) {
            Maybe clazz = target.tryLoadClass(className);
            if (clazz.isPresent()) {
                return clazz;
            }
            errors.add(Maybe.getException((Maybe)clazz));
        }
        boolean noPrimaryErrors = errors.isEmpty();
        for (BrooklynClassLoadingContext target : this.secondaries) {
            Maybe clazz = target.tryLoadClass(className);
            if (clazz.isPresent()) {
                return clazz;
            }
            if (!noPrimaryErrors) continue;
            errors.add(Maybe.getException((Maybe)clazz));
        }
        return Maybe.absent((Throwable)Exceptions.create((String)("Unable to load " + className + " from " + this.primaries), (Iterable)errors));
    }

    public URL getResource(String resourceInThatDir) {
        URL result;
        for (BrooklynClassLoadingContext target : this.primaries) {
            result = target.getResource(resourceInThatDir);
            if (result == null) continue;
            return result;
        }
        for (BrooklynClassLoadingContext target : this.secondaries) {
            result = target.getResource(resourceInThatDir);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Iterable<URL> getResources(String name) {
        MutableSet result = MutableSet.of();
        for (BrooklynClassLoadingContext target : this.primaries) {
            result.addAll(target.getResources(name));
        }
        for (BrooklynClassLoadingContext target : this.secondaries) {
            result.addAll(target.getResources(name));
        }
        return result;
    }

    @Override
    public String toString() {
        return "classload:" + this.primaries + ";" + this.secondaries;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.primaries, this.secondaries});
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof BrooklynClassLoadingContextSequential)) {
            return false;
        }
        if (!Objects.equal(this.primaries, ((BrooklynClassLoadingContextSequential)obj).primaries)) {
            return false;
        }
        return Objects.equal(this.secondaries, ((BrooklynClassLoadingContextSequential)obj).secondaries);
    }

    public List<BrooklynClassLoadingContext> getPrimaries() {
        return this.primaries;
    }
}

