/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.entitlement;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.BasicEntitlementClassDefinition;
import org.apache.brooklyn.core.mgmt.entitlement.NotEntitledException;
import org.apache.brooklyn.core.mgmt.persist.DeserializingClassRenamesProvider;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class Entitlements {
    private static final Logger log = LoggerFactory.getLogger(Entitlements.class);
    public static EntitlementClass<String> SEE_CATALOG_ITEM = new BasicEntitlementClassDefinition<String>("catalog.see", String.class);
    public static EntitlementClass<Object> ADD_CATALOG_ITEM = new BasicEntitlementClassDefinition<Object>("catalog.add", Object.class);
    public static EntitlementClass<StringAndArgument> MODIFY_CATALOG_ITEM = new BasicEntitlementClassDefinition<StringAndArgument>("catalog.modify", StringAndArgument.class);
    public static EntitlementClass<Entity> SEE_ENTITY = new BasicEntitlementClassDefinition<Entity>("entity.see", Entity.class);
    public static EntitlementClass<Entity> RENAME_ENTITY = new BasicEntitlementClassDefinition<Entity>("entity.rename", Entity.class);
    public static EntitlementClass<EntityAndItem<String>> SEE_SENSOR = new BasicEntitlementClassDefinition<EntityAndItem<String>>("sensor.see", EntityAndItem.typeToken(String.class));
    public static EntitlementClass<EntityAndItem<String>> SEE_CONFIG = new BasicEntitlementClassDefinition<EntityAndItem<String>>("config.see", EntityAndItem.typeToken(String.class));
    public static EntitlementClass<TaskAndItem<String>> SEE_ACTIVITY_STREAMS = new BasicEntitlementClassDefinition<TaskAndItem<String>>("activity.streams.see", TaskAndItem.typeToken(String.class));
    public static EntitlementClass<EntityAndItem<StringAndArgument>> INVOKE_EFFECTOR = new BasicEntitlementClassDefinition<EntityAndItem<StringAndArgument>>("effector.invoke", EntityAndItem.typeToken(StringAndArgument.class));
    public static EntitlementClass<Entity> MODIFY_ENTITY = new BasicEntitlementClassDefinition<Entity>("entity.modify", Entity.class);
    public static EntitlementClass<EntityAdjunct> DELETE_ADJUNCT = new BasicEntitlementClassDefinition<EntityAdjunct>("adjunct.delete", EntityAdjunct.class);
    public static EntitlementClass<StringAndArgument> ADD_LOCATION = new BasicEntitlementClassDefinition<StringAndArgument>("location.add", StringAndArgument.class);
    public static EntitlementClass<StringAndArgument> DELETE_LOCATION = new BasicEntitlementClassDefinition<StringAndArgument>("location.delete", StringAndArgument.class);
    public static EntitlementClass<StringAndArgument> SEE_LOCATION = new BasicEntitlementClassDefinition<StringAndArgument>("location.see", StringAndArgument.class);
    public static EntitlementClass<StringAndArgument> ADD_POLICY = new BasicEntitlementClassDefinition<StringAndArgument>("policy.add", StringAndArgument.class);
    public static EntitlementClass<Policy> DELETE_POLICY = new BasicEntitlementClassDefinition<Policy>("policy.delete", Policy.class);
    public static EntitlementClass<Policy> START_POLICY = new BasicEntitlementClassDefinition<Policy>("policy.start", Policy.class);
    public static EntitlementClass<Policy> STOP_POLICY = new BasicEntitlementClassDefinition<Policy>("policy.stop", Policy.class);
    public static EntitlementClass<Void> SYSTEM_ADMIN = new BasicEntitlementClassDefinition<Void>("system.admin", Void.class);
    public static EntitlementClass<Void> HA_STATS = new BasicEntitlementClassDefinition<Void>("system.ha.stats", Void.class);
    public static EntitlementClass<Void> HA_ADMIN = new BasicEntitlementClassDefinition<Void>("system.ha.admin", Void.class);
    public static EntitlementClass<Void> SHUTDOWN = new BasicEntitlementClassDefinition<Void>("system.shutdown", Void.class);
    public static EntitlementClass<Void> USAGE = new BasicEntitlementClassDefinition<Void>("system.usage", Void.class);
    public static EntitlementClass<Object> DEPLOY_APPLICATION = new BasicEntitlementClassDefinition<Object>("app.deploy", Object.class);
    public static EntitlementClass<Void> SEE_ALL_SERVER_INFO = new BasicEntitlementClassDefinition<Void>("server.info.all.see", Void.class);
    public static EntitlementClass<Void> SERVER_STATUS = new BasicEntitlementClassDefinition<Void>("server.status", Void.class);
    public static EntitlementClass<Void> ROOT = new BasicEntitlementClassDefinition<Void>("root", Void.class);
    public static final String ENTITLEMENTS_CONFIG_PREFIX = "brooklyn.entitlements";
    public static final ConfigKey<String> GLOBAL_ENTITLEMENT_MANAGER = ConfigKeys.newStringConfigKey("brooklyn.entitlements.global", "Class for entitlements in effect globally; short names 'minimal', 'readonly', 'user' or 'root' are permitted here, with the default 'root' giving full access to all declared users; or supply the name of an " + EntitlementManager.class + " class to instantiate, taking a 1-arg BrooklynProperties constructor or a 0-arg constructor", "root");

    public static EntitlementManager root() {
        return new EntitlementManager(){

            public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> permission, T typeArgument) {
                return true;
            }

            public String toString() {
                return "Entitlements.root";
            }
        };
    }

    public static EntitlementManager user() {
        return new EntitlementManager(){

            public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> permission, T entitlementClassArgument) {
                return !SEE_ALL_SERVER_INFO.equals(permission) && !ROOT.equals(permission);
            }

            public String toString() {
                return "Entitlements.user";
            }
        };
    }

    public static EntitlementManager minimal() {
        return new EntitlementManager(){

            public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> permission, T typeArgument) {
                return false;
            }

            public String toString() {
                return "Entitlements.minimal";
            }
        };
    }

    public static EntitlementManager readOnly() {
        return FineGrainedEntitlements.anyOf(FineGrainedEntitlements.allowing(SEE_ENTITY), FineGrainedEntitlements.allowing(SEE_ACTIVITY_STREAMS), FineGrainedEntitlements.allowing(SEE_CATALOG_ITEM), FineGrainedEntitlements.allowing(SERVER_STATUS), FineGrainedEntitlements.allowing(SEE_LOCATION), FineGrainedEntitlements.allowing(HA_STATS), FineGrainedEntitlements.seeNonSecretSensors(), FineGrainedEntitlements.seeNonSecretConfig());
    }

    public static EntitlementManager serverStatusOnly() {
        return FineGrainedEntitlements.allowing(SERVER_STATUS);
    }

    public static EntitlementContext getEntitlementContext() {
        EntitlementContext context = PerThreadEntitlementContextHolder.perThreadEntitlementsContextHolder.get();
        if (context != null) {
            return context;
        }
        for (Task task = Tasks.current(); task != null; task = task.getSubmittedByTask()) {
            context = BrooklynTaskTags.getEntitlement(task);
            if (context == null) continue;
            return context;
        }
        return null;
    }

    public static void setEntitlementContext(EntitlementContext context) {
        EntitlementContext oldContext = PerThreadEntitlementContextHolder.perThreadEntitlementsContextHolder.get();
        if (oldContext != null && context != null) {
            log.warn("Changing entitlement context from " + oldContext + " to " + context + "; context should have been reset or extended, not replaced");
            log.debug("Trace for entitlement context duplicate overwrite", new Throwable("Trace for entitlement context overwrite"));
        }
        PerThreadEntitlementContextHolder.perThreadEntitlementsContextHolder.set(context);
    }

    public static void clearEntitlementContext() {
        PerThreadEntitlementContextHolder.perThreadEntitlementsContextHolder.set(null);
    }

    public static <T> boolean isEntitled(EntitlementManager checker, EntitlementClass<T> permission, T typeArgument) {
        return checker.isEntitled(Entitlements.getEntitlementContext(), permission, typeArgument);
    }

    public static <T> void checkEntitled(EntitlementManager checker, EntitlementClass<T> permission, T typeArgument) {
        if (!Entitlements.isEntitled(checker, permission, typeArgument)) {
            throw new NotEntitledException(Entitlements.getEntitlementContext(), permission, typeArgument);
        }
    }

    public static EntitlementManager newManager(ManagementContext mgmt, BrooklynProperties brooklynProperties) {
        return Entitlements.newGlobalManager(mgmt, brooklynProperties);
    }

    private static EntitlementManager newGlobalManager(ManagementContext mgmt, BrooklynProperties brooklynProperties) {
        return Entitlements.load(mgmt, brooklynProperties, brooklynProperties.getConfig(GLOBAL_ENTITLEMENT_MANAGER));
    }

    public static EntitlementManager load(@Nullable ManagementContext mgmt, BrooklynProperties brooklynProperties, String type) {
        if ("root".equalsIgnoreCase(type)) {
            return Entitlements.root();
        }
        if ("readonly".equalsIgnoreCase(type) || "read_only".equalsIgnoreCase(type)) {
            return Entitlements.readOnly();
        }
        if ("minimal".equalsIgnoreCase(type)) {
            return Entitlements.minimal();
        }
        if ("user".equalsIgnoreCase(type)) {
            return Entitlements.user();
        }
        if (Strings.isNonBlank((CharSequence)type)) {
            try {
                Class<?> clazz = new ClassLoaderUtils(Entitlements.class, mgmt).loadClass(DeserializingClassRenamesProvider.INSTANCE.findMappedName(type));
                return (EntitlementManager)Entitlements.instantiate(clazz, (List<Object[]>)ImmutableList.of((Object)new Object[]{mgmt, brooklynProperties}, (Object)new Object[]{mgmt}, (Object)new Object[]{brooklynProperties}, (Object)new Object[0]));
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        throw new IllegalStateException("Invalid entitlement manager specified: '" + type + "'");
    }

    private static Object instantiate(Class<?> clazz, List<Object[]> constructorArgOptions) {
        try {
            for (Object[] constructorArgOption : constructorArgOptions) {
                Maybe result = Reflections.invokeConstructorFromArgs(clazz, (Object[])constructorArgOption);
                if (!result.isPresent()) continue;
                return result.get();
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        throw new IllegalStateException("No matching constructor to instantiate " + clazz);
    }

    private static class PerThreadEntitlementContextHolder {
        public static final ThreadLocal<EntitlementContext> perThreadEntitlementsContextHolder = new ThreadLocal();

        private PerThreadEntitlementContextHolder() {
        }
    }

    public static class FineGrainedEntitlements {
        private static final Joiner COMMA_JOINER = Joiner.on((char)',');

        public static EntitlementManager anyOf(EntitlementManager ... checkers) {
            return FineGrainedEntitlements.anyOf(Arrays.asList(checkers));
        }

        public static EntitlementManager anyOf(final Iterable<? extends EntitlementManager> checkers) {
            return new EntitlementManager(){

                public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> permission, T typeArgument) {
                    for (EntitlementManager checker : checkers) {
                        if (!checker.isEntitled(context, permission, typeArgument)) continue;
                        return true;
                    }
                    return false;
                }

                public String toString() {
                    return "Entitlements.anyOf(" + COMMA_JOINER.join(checkers) + ")";
                }
            };
        }

        public static EntitlementManager allOf(EntitlementManager ... checkers) {
            return FineGrainedEntitlements.allOf(Arrays.asList(checkers));
        }

        public static EntitlementManager allOf(final Iterable<? extends EntitlementManager> checkers) {
            return new EntitlementManager(){

                public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> permission, T typeArgument) {
                    for (EntitlementManager checker : checkers) {
                        if (!checker.isEntitled(context, permission, typeArgument)) continue;
                        return true;
                    }
                    return false;
                }

                public String toString() {
                    return "Entitlements.allOf(" + COMMA_JOINER.join(checkers) + ")";
                }
            };
        }

        public static <U> EntitlementManager allowing(EntitlementClass<U> permission, Predicate<U> test) {
            return new SinglePermissionEntitlementChecker<U>(permission, test);
        }

        public static <U> EntitlementManager allowing(EntitlementClass<U> permission) {
            return new SinglePermissionEntitlementChecker<U>(permission, Predicates.alwaysTrue());
        }

        public static EntitlementManager seeNonSecretSensors() {
            return FineGrainedEntitlements.allowing(SEE_SENSOR, new NonSecretPredicate());
        }

        public static EntitlementManager seeNonSecretConfig() {
            return FineGrainedEntitlements.allowing(SEE_CONFIG, new NonSecretPredicate());
        }

        private static class NonSecretPredicate
        implements Predicate<EntityAndItem<String>> {
            private NonSecretPredicate() {
            }

            public boolean apply(EntityAndItem<String> input) {
                return input != null && !Sanitizer.IS_SECRET_PREDICATE.apply((Object)input.getItem());
            }

            public String toString() {
                return "Predicates.nonSecret";
            }
        }

        public static class SinglePermissionEntitlementChecker<U>
        implements EntitlementManager {
            final EntitlementClass<U> permission;
            final Predicate<U> test;

            protected SinglePermissionEntitlementChecker(EntitlementClass<U> permission, Predicate<U> test) {
                this.permission = permission;
                this.test = test;
            }

            public <T> boolean isEntitled(EntitlementContext context, EntitlementClass<T> permission, T typeArgument) {
                return Objects.equal(this.permission, permission) && this.test.apply(typeArgument);
            }

            public String toString() {
                return "Entitlements.allowing(" + this.permission + " -> " + this.test + ")";
            }
        }
    }

    @Beta
    public static class LifecycleEffectors {
        public static final String DELETE = "delete";
    }

    public static class StringAndArgument
    extends Pair<String, Object> {
        public StringAndArgument(String string, Object argument) {
            super(string, argument);
        }

        public String getString() {
            return (String)this.p1;
        }

        public Object getArgument() {
            return this.p2;
        }

        public static StringAndArgument of(String string, Object argument) {
            return new StringAndArgument(string, argument);
        }
    }

    public static class TaskAndItem<T>
    extends Pair<Task<?>, T> {
        public static <TT> TypeToken<TaskAndItem<TT>> typeToken(Class<TT> type) {
            return new TypeToken<TaskAndItem<TT>>(){
                private static final long serialVersionUID = 3103447462213439135L;
            };
        }

        public TaskAndItem(Task<?> task, T item) {
            super(task, item);
        }

        public Task<?> getTask() {
            return (Task)this.p1;
        }

        public T getItem() {
            return (T)this.p2;
        }

        public static <T> TaskAndItem<T> of(Task<?> task, T item) {
            return new TaskAndItem<T>(task, item);
        }
    }

    public static class EntityAndItem<T>
    extends Pair<Entity, T> {
        public static <TT> TypeToken<EntityAndItem<TT>> typeToken(Class<TT> type) {
            return new TypeToken<EntityAndItem<TT>>(){
                private static final long serialVersionUID = -738154831809025407L;
            };
        }

        public EntityAndItem(Entity entity, T item) {
            super(entity, item);
        }

        public Entity getEntity() {
            return (Entity)this.p1;
        }

        public T getItem() {
            return (T)this.p2;
        }

        public static <T> EntityAndItem<T> of(Entity entity, T item) {
            return new EntityAndItem<T>(entity, item);
        }
    }

    protected static class Pair<T1, T2> {
        protected final T1 p1;
        protected final T2 p2;

        protected Pair(T1 p1, T2 p2) {
            this.p1 = p1;
            this.p2 = p2;
        }
    }

    public static interface EntitlementClassesHandler<T> {
        public T handleSeeCatalogItem(String var1);

        public T handleSeeServerStatus();

        public T handleAddCatalogItem(Object var1);

        public T handleModifyCatalogItem(StringAndArgument var1);

        public T handleSeeEntity(Entity var1);

        public T handleSeeSensor(EntityAndItem<String> var1);

        public T handleInvokeEffector(EntityAndItem<StringAndArgument> var1);

        public T handleModifyEntity(Entity var1);

        public T handleDeployApplication(Object var1);

        public T handleSeeAllServerInfo();

        public T handleRoot();
    }

    public static enum EntitlementClassesEnum {
        ENTITLEMENT_SEE_CATALOG_ITEM((EntitlementClass)SEE_CATALOG_ITEM){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleSeeCatalogItem((String)argument);
            }
        }
        ,
        ENTITLEMENT_ADD_CATALOG_ITEM((EntitlementClass)ADD_CATALOG_ITEM){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleAddCatalogItem(argument);
            }
        }
        ,
        ENTITLEMENT_MODIFY_CATALOG_ITEM((EntitlementClass)MODIFY_CATALOG_ITEM){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleModifyCatalogItem((StringAndArgument)argument);
            }
        }
        ,
        ENTITLEMENT_SEE_ENTITY((EntitlementClass)SEE_ENTITY){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleSeeEntity((Entity)argument);
            }
        }
        ,
        ENTITLEMENT_SEE_SENSOR((EntitlementClass)SEE_SENSOR){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleSeeSensor((EntityAndItem)argument);
            }
        }
        ,
        ENTITLEMENT_INVOKE_EFFECTOR((EntitlementClass)INVOKE_EFFECTOR){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleInvokeEffector((EntityAndItem)argument);
            }
        }
        ,
        ENTITLEMENT_MODIFY_ENTITY((EntitlementClass)MODIFY_ENTITY){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleModifyEntity((Entity)argument);
            }
        }
        ,
        ENTITLEMENT_DEPLOY_APPLICATION((EntitlementClass)DEPLOY_APPLICATION){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleDeployApplication(argument);
            }
        }
        ,
        ENTITLEMENT_SEE_ALL_SERVER_INFO((EntitlementClass)SEE_ALL_SERVER_INFO){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleSeeAllServerInfo();
            }
        }
        ,
        ENTITLEMENT_SERVER_STATUS((EntitlementClass)SERVER_STATUS){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleSeeServerStatus();
            }
        }
        ,
        ENTITLEMENT_ROOT((EntitlementClass)ROOT){

            @Override
            public <T> T handle(EntitlementClassesHandler<T> handler, Object argument) {
                return handler.handleRoot();
            }
        };

        private EntitlementClass<?> entitlementClass;

        private EntitlementClassesEnum(EntitlementClass<?> specificClass) {
            this.entitlementClass = specificClass;
        }

        public EntitlementClass<?> getEntitlementClass() {
            return this.entitlementClass;
        }

        public abstract <T> T handle(EntitlementClassesHandler<T> var1, Object var2);

        public static EntitlementClassesEnum of(EntitlementClass<?> entitlementClass) {
            for (EntitlementClassesEnum x : EntitlementClassesEnum.values()) {
                if (!entitlementClass.equals(x.getEntitlementClass())) continue;
                return x;
            }
            return null;
        }
    }
}

