/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.entity.group.AbstractGroup;
import org.apache.brooklyn.entity.stock.DelegateEntity;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.concurrent.Locks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGroupImpl
extends AbstractEntity
implements AbstractGroup {
    private static final Logger log = LoggerFactory.getLogger(AbstractGroupImpl.class);
    private Set<Entity> members = Sets.newLinkedHashSet();

    @Override
    public void setManagementContext(ManagementContextInternal managementContext) {
        super.setManagementContext(managementContext);
    }

    @Override
    public void init() {
        super.init();
        this.sensors().set(GROUP_SIZE, 0);
        this.sensors().set(GROUP_MEMBERS, ImmutableList.of());
    }

    @Override
    protected void initEnrichers() {
        super.initEnrichers();
        this.enrichers().add(ServiceStateLogic.newEnricherFromChildrenState().checkChildrenAndMembers().requireRunningChildren((QuorumCheck)this.getConfig(RUNNING_QUORUM_CHECK)).suppressDuplicates(true));
        this.enrichers().add(ServiceStateLogic.newEnricherFromChildrenUp().checkChildrenAndMembers().requireUpChildren((QuorumCheck)this.getConfig(UP_QUORUM_CHECK)).suppressDuplicates(true));
    }

    public boolean addMember(Entity member) {
        return (Boolean)Locks.withLock((Lock)this.getLockInternal(), () -> {
            Set<Entity> set = this.members;
            synchronized (set) {
                if (Entities.isNoLongerManaged(member)) {
                    log.debug("Group {} ignoring new member {}, because it is no longer managed", (Object)this, (Object)member);
                    return false;
                }
                Entity first = (Entity)this.getAttribute(FIRST);
                if (first == null) {
                    this.sensors().set(FIRST, member);
                }
                ((EntityInternal)member).groups().add((Group)this.getProxyIfAvailable());
                boolean changed = this.addMemberInternal(member);
                if (changed) {
                    log.debug("Group {} got new member {}", (Object)this, (Object)member);
                    this.sensors().set(GROUP_SIZE, this.getCurrentSize());
                    this.sensors().set(GROUP_MEMBERS, this.getMembers());
                    this.sensors().emit(MEMBER_ADDED, member);
                    if (Boolean.TRUE.equals(this.getConfig(MEMBER_DELEGATE_CHILDREN))) {
                        log.warn("Use of deprecated ConfigKey {} in {} (as of 0.9.0)", (Object)MEMBER_DELEGATE_CHILDREN.getName(), (Object)this);
                        Optional result = Iterables.tryFind(this.getChildren(), (Predicate)Predicates.equalTo((Object)member));
                        if (!result.isPresent()) {
                            String nameFormat = (String)Optional.fromNullable(this.getConfig(MEMBER_DELEGATE_NAME_FORMAT)).or((Object)"%s");
                            DelegateEntity delegateEntity = (DelegateEntity)this.addChild((EntitySpec)((EntitySpec)EntitySpec.create(DelegateEntity.class).configure(DelegateEntity.DELEGATE_ENTITY, (Object)member)).displayName(String.format(nameFormat, member.getDisplayName())));
                        }
                    }
                    this.getManagementSupport().getEntityChangeListener().onMembersChanged();
                }
                return changed;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMemberInternal(Entity member) {
        Set<Entity> set = this.members;
        synchronized (set) {
            return this.members.add(member);
        }
    }

    public boolean removeMember(final Entity member) {
        return (Boolean)Locks.withLock((Lock)this.getLockInternal(), () -> {
            Set<Entity> set = this.members;
            synchronized (set) {
                boolean changed;
                boolean bl = changed = member != null && this.members.remove(member);
                if (changed) {
                    Optional result;
                    log.debug("Group {} lost member {}", (Object)this, (Object)member);
                    this.sensors().set(GROUP_SIZE, this.getCurrentSize());
                    Collection<Entity> membersNow = this.getMembers();
                    this.sensors().set(GROUP_MEMBERS, membersNow);
                    if (member.equals(this.getAttribute(FIRST))) {
                        this.sensors().set(FIRST, membersNow.isEmpty() ? null : membersNow.iterator().next());
                    }
                    this.sensors().emit(MEMBER_REMOVED, member);
                    if (Boolean.TRUE.equals(this.getConfig(MEMBER_DELEGATE_CHILDREN)) && (result = Iterables.tryFind(this.getChildren(), (Predicate)new Predicate<Entity>(){

                        public boolean apply(Entity input) {
                            Entity delegate = (Entity)input.getConfig(DelegateEntity.DELEGATE_ENTITY);
                            if (delegate == null) {
                                return false;
                            }
                            return delegate.equals(member);
                        }
                    })).isPresent()) {
                        Entity child = (Entity)result.get();
                        this.removeChild(child);
                        Entities.unmanage(child);
                    }
                }
                Exception errorRemoving = null;
                try {
                    ((EntityInternal)member).groups().remove((Group)this.getProxyIfAvailable());
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    errorRemoving = e;
                }
                this.getManagementSupport().getEntityChangeListener().onMembersChanged();
                if (errorRemoving != null) {
                    if (Entities.isNoLongerManaged(member)) {
                        log.debug("Ignoring error when telling group " + this + " unmanaged member " + member + " is is removed: " + errorRemoving);
                    } else {
                        Exceptions.propagate((Throwable)errorRemoving);
                    }
                }
                return changed;
            }
        });
    }

    @Override
    public void setMembers(Collection<Entity> m) {
        this.setMembers(m, null);
    }

    @Override
    public void setMembers(Collection<Entity> mm, Predicate<Entity> filter) {
        Locks.withLock((Lock)this.getLockInternal(), () -> {
            Set<Entity> set = this.members;
            synchronized (set) {
                log.debug("Group {} members set explicitly to {} (of which some possibly filtered)", (Object)this, this.members);
                ArrayList<Entity> mmo = new ArrayList<Entity>(this.getMembers());
                for (Entity m : mmo) {
                    if (mm.contains(m) && (filter == null || filter.apply((Object)m))) continue;
                    this.removeMember(m);
                }
                for (Entity m : mm) {
                    if (mmo.contains(m) || filter != null && !filter.apply((Object)m)) continue;
                    this.addMember(m);
                }
                this.getManagementSupport().getEntityChangeListener().onMembersChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entity> getMembers() {
        Set<Entity> set = this.members;
        synchronized (set) {
            return ImmutableSet.copyOf(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMember(Entity e) {
        Set<Entity> set = this.members;
        synchronized (set) {
            return this.members.contains(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCurrentSize() {
        Set<Entity> set = this.members;
        synchronized (set) {
            return this.members.size();
        }
    }

    public <T extends Entity> T addMemberChild(EntitySpec<T> spec) {
        T child = this.addChild(spec);
        this.addMember((Entity)child);
        return child;
    }

    public <T extends Entity> T addMemberChild(T child) {
        child = this.addChild(child);
        this.addMember(child);
        return child;
    }
}

