/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import com.google.common.annotations.Beta;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.stock.BasicStartable;
import org.apache.brooklyn.entity.stock.LocationEntityImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@ImplementedBy(value=LocationEntityImpl.class)
@Beta
public interface LocationEntity
extends BasicStartable {
    public static final String DEFAULT = "default";
    @SetFromFlag(value="entitySpec")
    public static final ConfigKey<Map<String, EntitySpec<?>>> LOCATION_ENTITY_SPEC_MAP = ConfigKeys.newConfigKey(new TypeToken<Map<String, EntitySpec<?>>>(){}, "location.entity.spec", "The mapping of location properties to the entity specification that will be created. Use the key 'default' to specify an entity specification to use if no match is found.");
    @SetFromFlag(value="propagateSensors")
    public static final ConfigKey<Boolean> PROPAGATE_LOCATION_ENTITY_SENSORS = ConfigKeys.newBooleanConfigKey("location.entity.propagate", "Whether sensors are to be propagated from the child entity", Boolean.TRUE);
    @SetFromFlag(value="sensorsToPropagate")
    public static final ConfigKey<Collection<AttributeSensor<?>>> LOCATION_ENTITY_SENSOR_LIST = ConfigKeys.newConfigKey(new TypeToken<Collection<AttributeSensor<?>>>(){}, "location.entity.sensors", "Collection of sensors that are to be propagated from the child entity (all usual sensors if not set, or empty)");
    public static final AttributeSensor<String> LOCATION_TYPE = Sensors.newStringSensor("location.entity.type", "The class name of the entity location");
    public static final AttributeSensor<String> LOCATION_PROVIDER = Sensors.newStringSensor("location.entity.provider", "The provider name for the entity location");
    public static final AttributeSensor<Set<String>> LOCATION_COUNTRY_CODES = Sensors.newSensor(new TypeToken<Set<String>>(){}, "location.entity.countryCode", "The ISO 3166 country codes for the entity location");
    public static final AttributeSensor<Entity> LOCATION_ENTITY = Sensors.newSensor(Entity.class, "location.entity", "The created entity");
}

