/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskQueueingContext;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.BasicExecutionContext;
import org.apache.brooklyn.util.core.task.BasicTask;
import org.apache.brooklyn.util.core.task.CompoundTask;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSequentialTask<T>
extends BasicTask<T>
implements HasTaskChildren,
TaskQueueingContext {
    private static final Logger log = LoggerFactory.getLogger(CompoundTask.class);
    protected final Queue<Task<?>> secondaryJobsAll = new ConcurrentLinkedQueue();
    protected final Queue<Task<?>> secondaryJobsRemaining = new ConcurrentLinkedQueue();
    protected final Object jobTransitionLock = new Object();
    protected volatile boolean primaryStarted = false;
    protected volatile boolean primaryFinished = false;
    protected volatile boolean secondaryQueueAborted = false;
    protected Thread primaryThread;
    protected DstJob dstJob;
    protected FailureHandlingConfig failureHandlingConfig = FailureHandlingConfig.DEFAULT;

    public DynamicSequentialTask() {
        this((Callable<T>)null);
    }

    public DynamicSequentialTask(Callable<T> mainJob) {
        this((Map<?, ?>)MutableMap.of((Object)"tag", (Object)"compound"), mainJob);
    }

    public DynamicSequentialTask(Map<?, ?> flags, Callable<T> mainJob) {
        super(flags);
        this.dstJob = new DstJob(mainJob);
        this.job = this.dstJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(Task<?> t) {
        Object object = this.jobTransitionLock;
        synchronized (object) {
            if (this.primaryFinished) {
                throw new IllegalStateException("Cannot add a task to " + this + " which is already finished (trying to add " + t + ")");
            }
            if (this.secondaryQueueAborted) {
                throw new QueueAbortedException("Cannot add a task to " + this + " whose queue has been aborted (trying to add " + t + ")");
            }
            this.secondaryJobsAll.add(t);
            this.secondaryJobsRemaining.add(t);
            BrooklynTaskTags.addTagsDynamically(t, "SUB-TASK", new Object[0]);
            ((TaskInternal)t).markQueued();
            this.jobTransitionLock.notifyAll();
        }
    }

    @Override
    protected boolean doCancel(TaskInternal.TaskCancellationMode mode) {
        boolean result = false;
        if (mode.isAllowedToInterruptDependentSubmittedTasks()) {
            for (Task task : this.secondaryJobsAll) {
                result = ((TaskInternal)task).cancel(mode) || result;
            }
        }
        return super.doCancel(mode) || result;
    }

    @Override
    public boolean cancel(TaskInternal.TaskCancellationMode mode) {
        return this.cancel(mode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancel(TaskInternal.TaskCancellationMode mode, Boolean interruptPrimaryThreadOverride) {
        if (this.isDone()) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("cancelling DST {}", (Object)this);
        }
        boolean result = super.cancel(mode);
        if (interruptPrimaryThreadOverride == null) {
            interruptPrimaryThreadOverride = mode.isAllowedToInterruptTask();
        }
        if (log.isTraceEnabled()) {
            log.trace("DST cancelling " + this + " mode " + mode + ", interruptPrimary " + interruptPrimaryThreadOverride);
        }
        Object object = this.jobTransitionLock;
        synchronized (object) {
            if (this.primaryThread != null) {
                if (interruptPrimaryThreadOverride.booleanValue()) {
                    if (log.isTraceEnabled()) {
                        log.trace("cancelling {} - interrupting", (Object)this);
                    }
                    this.primaryThread.interrupt();
                }
                result = true;
            }
        }
        return result;
    }

    @Override
    public synchronized boolean uncancel() {
        this.secondaryQueueAborted = false;
        return super.uncancel();
    }

    public Iterable<Task<?>> getChildren() {
        return Collections.unmodifiableCollection(this.secondaryJobsAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitBackgroundInheritingContext(Task<?> task) {
        BasicExecutionContext ec = BasicExecutionContext.getCurrentExecutionContext();
        if (log.isTraceEnabled()) {
            log.trace("task {} - submitting background task {} ({})", new Object[]{Tasks.current(), task, ec});
        }
        if (ec == null) {
            String message = Tasks.current() != null ? "Task " + this + " submitting background task requires an ExecutionContext (an ExecutionManager is not enough): submitting " + task + " in " + Tasks.current() : "Cannot submit tasks inside DST when not in a task : submitting " + task + " in " + this;
            log.warn(message + " (rethrowing)");
            throw new IllegalStateException(message);
        }
        Task<?> task2 = task;
        synchronized (task2) {
            if (task.isSubmitted()) {
                if (log.isTraceEnabled()) {
                    log.trace("DST " + this + " skipping submission of child " + task + " because it is already submitted");
                }
            } else {
                try {
                    ec.submit(task);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    throw new IllegalStateException("Failure submitting task " + task + " in " + this + ": " + e.getMessage(), e);
                }
            }
        }
    }

    public void setFailureHandlingConfig(FailureHandlingConfig failureHandlingConfig) {
        this.failureHandlingConfig = failureHandlingConfig;
    }

    public void swallowChildrenFailures() {
        this.setFailureHandlingConfig(FailureHandlingConfig.SWALLOWING_CHILDREN_FAILURES);
    }

    public List<Task<?>> getQueue() {
        return ImmutableList.copyOf(this.secondaryJobsAll);
    }

    public void handleException(Throwable throwable, boolean fromChild) throws Exception {
        Exceptions.propagateIfFatal((Throwable)throwable);
        if (fromChild && !this.failureHandlingConfig.failParentOnSecondaryFailure) {
            log.debug("Parent task " + this + " swallowing child error: " + throwable);
            return;
        }
        this.handleException(throwable);
    }

    public void handleException(Throwable throwable) throws Exception {
        Exceptions.propagateIfFatal((Throwable)throwable);
        if (throwable instanceof Exception) {
            throw (Exception)throwable;
        }
        throw Exceptions.propagate((Throwable)throwable);
    }

    public void drain(Duration optionalTimeout, boolean includePrimary, boolean throwFirstError) {
        try {
            this.dstJob.join(includePrimary, optionalTimeout);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (throwFirstError) {
            if (this.isError()) {
                this.getUnchecked();
            }
            for (Task<?> t : this.getQueue()) {
                if (!t.isError() || TaskTags.isInessential(t)) continue;
                t.getUnchecked();
            }
        }
    }

    protected class DstJob
    implements Callable<T> {
        protected Callable<T> primaryJob;
        protected volatile Task<?> currentSecondary = null;
        protected volatile boolean finishedSecondaries = false;

        public DstJob(Callable<T> mainJob) {
            this.primaryJob = mainJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         */
        @Override
        public T call() throws Exception {
            boolean errorIsFromChild;
            Throwable uninterestingSelfError;
            Throwable error;
            List result;
            block47: {
                Object object = DynamicSequentialTask.this.jobTransitionLock;
                synchronized (object) {
                    DynamicSequentialTask.this.primaryStarted = true;
                    DynamicSequentialTask.this.primaryThread = Thread.currentThread();
                    for (Task t : DynamicSequentialTask.this.secondaryJobsAll) {
                        ((TaskInternal)t).markQueued();
                    }
                }
                Task<List<Object>> secondaryJobMaster = Tasks.builder().dynamic(false).displayName("DST manager (internal)").tag("TRANSIENT").body(new Callable<List<Object>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public List<Object> call() throws Exception {
                        ArrayList<Object> result;
                        block30: {
                            Object object;
                            result = new ArrayList<Object>();
                            block20: while (true) {
                                while (!(DynamicSequentialTask.this.secondaryQueueAborted || DynamicSequentialTask.this.primaryFinished && DynamicSequentialTask.this.secondaryJobsRemaining.isEmpty())) {
                                    object = DynamicSequentialTask.this.jobTransitionLock;
                                    synchronized (object) {
                                        if (!DynamicSequentialTask.this.primaryFinished && DynamicSequentialTask.this.secondaryJobsRemaining.isEmpty()) {
                                            DstJob.this.currentSecondary = null;
                                            DynamicSequentialTask.this.jobTransitionLock.wait(1000L);
                                        }
                                    }
                                    Task<?> secondaryJob = DynamicSequentialTask.this.secondaryJobsRemaining.poll();
                                    if (secondaryJob == null) continue;
                                    Object object2 = DynamicSequentialTask.this.jobTransitionLock;
                                    synchronized (object2) {
                                        DstJob.this.currentSecondary = secondaryJob;
                                        DynamicSequentialTask.this.submitBackgroundInheritingContext(secondaryJob);
                                        DynamicSequentialTask.this.jobTransitionLock.notifyAll();
                                    }
                                    try {
                                        result.add(secondaryJob.get());
                                        continue block20;
                                    }
                                    catch (Exception e) {
                                        if (TaskTags.isInessential(secondaryJob)) {
                                            result.add(Tasks.getError(secondaryJob));
                                            if (!log.isDebugEnabled()) continue;
                                            log.debug("Secondary job queue for " + DynamicSequentialTask.this + " ignoring error in inessential task " + secondaryJob + ": " + e);
                                            continue;
                                        }
                                        if (DynamicSequentialTask.this.failureHandlingConfig.cancelSecondariesOnSecondaryFailure) {
                                            if (log.isDebugEnabled()) {
                                                log.debug("Secondary job queue for " + DynamicSequentialTask.this + " cancelling " + DynamicSequentialTask.this.secondaryJobsRemaining.size() + " remaining, due to error in task " + secondaryJob + ": " + e);
                                            }
                                            Object object3 = DynamicSequentialTask.this.jobTransitionLock;
                                            synchronized (object3) {
                                                for (Task task : DynamicSequentialTask.this.secondaryJobsRemaining) {
                                                    task.cancel(true);
                                                }
                                                DynamicSequentialTask.this.jobTransitionLock.notifyAll();
                                            }
                                        }
                                        if (DynamicSequentialTask.this.failureHandlingConfig.abortSecondaryQueueOnSecondaryFailure) {
                                            if (log.isDebugEnabled()) {
                                                log.debug("Aborting secondary job queue for " + DynamicSequentialTask.this + " due to error in child task " + secondaryJob + " (" + e + ", being rethrown)");
                                            }
                                            DynamicSequentialTask.this.secondaryQueueAborted = true;
                                            throw e;
                                        }
                                        if (!DynamicSequentialTask.this.primaryFinished && DynamicSequentialTask.this.failureHandlingConfig.cancelPrimaryOnSecondaryFailure) {
                                            DynamicSequentialTask.this.cancel(TaskInternal.TaskCancellationMode.INTERRUPT_TASK_BUT_NOT_SUBMITTED_TASKS, false);
                                        }
                                        result.add(Tasks.getError(secondaryJob));
                                        if (!log.isDebugEnabled()) continue;
                                        log.debug("Secondary job queue for " + DynamicSequentialTask.this + " continuing in presence of error in child task " + secondaryJob + " (" + e + ", being remembered)");
                                    }
                                }
                                break block30;
                                {
                                    continue block20;
                                    break;
                                }
                                break;
                            }
                            finally {
                                object = DynamicSequentialTask.this.jobTransitionLock;
                                synchronized (object) {
                                    DstJob.this.currentSecondary = null;
                                    DstJob.this.finishedSecondaries = true;
                                    DynamicSequentialTask.this.jobTransitionLock.notifyAll();
                                }
                            }
                        }
                        return result;
                    }
                }).build();
                ((BasicTask)secondaryJobMaster).proxyTargetTask = DynamicSequentialTask.this;
                DynamicSequentialTask.this.submitBackgroundInheritingContext(secondaryJobMaster);
                result = null;
                error = null;
                uninterestingSelfError = null;
                errorIsFromChild = false;
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("calling primary job for {}", (Object)this);
                    }
                    if (this.primaryJob != null) {
                        result = (List)this.primaryJob.call();
                    }
                }
                catch (Throwable selfException222222222) {
                    Exceptions.propagateIfFatal((Throwable)selfException222222222);
                    if (Exceptions.getFirstThrowableOfType((Throwable)selfException222222222, QueueAbortedException.class) != null) {
                        uninterestingSelfError = selfException222222222;
                    } else {
                        error = selfException222222222;
                        errorIsFromChild = false;
                    }
                    if (DynamicSequentialTask.this.failureHandlingConfig.abortSecondaryQueueOnPrimaryFailure) {
                        if (log.isDebugEnabled()) {
                            log.debug("Secondary job queue for " + DynamicSequentialTask.this + " aborting with " + DynamicSequentialTask.this.secondaryJobsRemaining.size() + " remaining, due to error in primary task: " + selfException222222222);
                        }
                        DynamicSequentialTask.this.secondaryQueueAborted = true;
                    }
                    if (!DynamicSequentialTask.this.failureHandlingConfig.cancelSecondariesOnPrimaryFailure) break block47;
                    if (log.isDebugEnabled()) {
                        log.debug(DynamicSequentialTask.this + " cancelling " + DynamicSequentialTask.this.secondaryJobsRemaining.size() + " remaining, due to error in primary task: " + selfException222222222);
                    }
                    Object object2 = DynamicSequentialTask.this.jobTransitionLock;
                    synchronized (object2) {
                        for (Task t : DynamicSequentialTask.this.secondaryJobsRemaining) {
                            t.cancel(true);
                        }
                        DynamicSequentialTask.this.primaryThread = null;
                        DynamicSequentialTask.this.primaryFinished = true;
                    }
                }
                finally {
                    block48: {
                        try {
                            if (log.isTraceEnabled()) {
                                log.trace("cleaning up for {}", (Object)this);
                            }
                            Object object3 = DynamicSequentialTask.this.jobTransitionLock;
                            synchronized (object3) {
                                DynamicSequentialTask.this.primaryThread = null;
                                DynamicSequentialTask.this.primaryFinished = true;
                                DynamicSequentialTask.this.jobTransitionLock.notifyAll();
                            }
                            if (DynamicSequentialTask.this.isCancelled() || Thread.currentThread().isInterrupted()) break block48;
                            if (log.isTraceEnabled()) {
                                log.trace("waiting for secondaries for {}", (Object)this);
                            }
                            DynamicTasks.waitForLast();
                            List result2 = (List)secondaryJobMaster.get();
                            try {
                                if (this.primaryJob == null) {
                                    result = result2;
                                }
                            }
                            catch (ClassCastException classCastException) {}
                        }
                        catch (Throwable childException) {
                            Exceptions.propagateIfFatal((Throwable)childException);
                            if (error == null) {
                                error = childException;
                                errorIsFromChild = true;
                            }
                            if (!log.isDebugEnabled()) break block48;
                            log.debug("Parent task " + this + " ignoring child error (" + childException + ") in presence of our own error (" + error + ")");
                        }
                    }
                }
            }
            if (error != null) {
                DynamicSequentialTask.this.handleException(error, errorIsFromChild);
            }
            if (uninterestingSelfError != null) {
                DynamicSequentialTask.this.handleException(uninterestingSelfError, false);
            }
            return result;
        }

        public String toString() {
            return "DstJob:" + DynamicSequentialTask.this.getId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void join(boolean includePrimary, Duration optionalTimeout) throws InterruptedException {
            CountdownTimer timeLeft = optionalTimeout != null ? CountdownTimer.newInstanceStarted((Duration)optionalTimeout) : null;
            while (true) {
                Duration remaining;
                Task<?> cs;
                Object object = DynamicSequentialTask.this.jobTransitionLock;
                synchronized (object) {
                    cs = this.currentSecondary;
                    if (this.finishedSecondaries) {
                        return;
                    }
                    Duration duration = remaining = timeLeft == null ? Duration.ONE_SECOND : timeLeft.getDurationRemaining();
                    if (!remaining.isPositive()) {
                        return;
                    }
                    if (cs == null) {
                        if (!includePrimary && DynamicSequentialTask.this.secondaryJobsRemaining.isEmpty()) {
                            return;
                        }
                        Tasks.setBlockingTask(DynamicSequentialTask.this);
                        DynamicSequentialTask.this.jobTransitionLock.wait(remaining.toMilliseconds());
                        Tasks.resetBlockingDetails();
                    }
                }
                if (cs == null) continue;
                Tasks.setBlockingTask(cs);
                cs.blockUntilEnded(remaining);
                Tasks.resetBlockingDetails();
            }
        }
    }

    public static class QueueAbortedException
    extends IllegalStateException {
        private static final long serialVersionUID = -7569362887826818524L;

        public QueueAbortedException(String msg) {
            super(msg);
        }

        public QueueAbortedException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    @Beta
    public static class FailureHandlingConfig {
        public final boolean abortSecondaryQueueOnPrimaryFailure;
        public final boolean cancelSecondariesOnPrimaryFailure;
        public final boolean abortSecondaryQueueOnSecondaryFailure;
        public final boolean cancelSecondariesOnSecondaryFailure;
        public final boolean cancelPrimaryOnSecondaryFailure;
        public final boolean failParentOnSecondaryFailure;
        public static final FailureHandlingConfig DEFAULT = new FailureHandlingConfig(false, false, true, false, false, true);
        public static final FailureHandlingConfig SWALLOWING_CHILDREN_FAILURES = new FailureHandlingConfig(false, false, false, false, false, false);

        @Beta
        public FailureHandlingConfig(boolean abortSecondaryQueueOnPrimaryFailure, boolean cancelSecondariesOnPrimaryFailure, boolean abortSecondaryQueueOnSecondaryFailure, boolean cancelSecondariesOnSecondaryFailure, boolean cancelPrimaryOnSecondaryFailure, boolean failParentOnSecondaryFailure) {
            this.abortSecondaryQueueOnPrimaryFailure = abortSecondaryQueueOnPrimaryFailure;
            this.cancelSecondariesOnPrimaryFailure = cancelSecondariesOnPrimaryFailure;
            this.abortSecondaryQueueOnSecondaryFailure = abortSecondaryQueueOnSecondaryFailure;
            this.cancelSecondariesOnSecondaryFailure = cancelSecondariesOnSecondaryFailure;
            this.cancelPrimaryOnSecondaryFailure = cancelPrimaryOnSecondaryFailure;
            this.failParentOnSecondaryFailure = failParentOnSecondaryFailure;
        }
    }
}

