/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl;

import org.apache.felix.inventory.impl.InventoryPrinterManagerImpl;
import org.apache.felix.inventory.impl.webconsole.WebConsoleAdapter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Object logService;
    private ServiceTracker logServiceTracker;
    private InventoryPrinterManagerImpl printerManager;
    private WebConsoleAdapter webAdapter;

    public void start(BundleContext context) throws Exception {
        this.logServiceTracker = new ServiceTracker(context, "org.osgi.service.log.LogService", null){

            public Object addingService(ServiceReference reference) {
                logService = super.addingService(reference);
                return logService;
            }

            public void removedService(ServiceReference reference, Object service) {
                logService = null;
                super.removedService(reference, service);
            }
        };
        this.logServiceTracker.open();
        this.webAdapter = new WebConsoleAdapter(context);
        this.printerManager = new InventoryPrinterManagerImpl(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.printerManager != null) {
            this.printerManager.dispose();
            this.printerManager = null;
        }
        if (this.webAdapter != null) {
            this.webAdapter.dispose();
            this.webAdapter = null;
        }
        logService = null;
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
    }

    public static void log(ServiceReference sr, int level, String message, Throwable exception) {
        Object logService = Activator.logService;
        if (logService != null) {
            ((LogService)logService).log(sr, level, message, exception);
        } else {
            String code;
            switch (level) {
                case 3: {
                    code = "*INFO *";
                    break;
                }
                case 2: {
                    code = "*WARN *";
                    break;
                }
                case 1: {
                    code = "*ERROR*";
                    break;
                }
                default: {
                    code = "*DEBUG*";
                }
            }
            System.err.println(code + " " + message);
            if (exception != null) {
                exception.printStackTrace(System.out);
            }
        }
    }
}

