/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.util.core.flags.MethodCoercions;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.coerce.TryCoercer;
import org.jclouds.json.SerializedNames;

public class JcloudsTypeCoercions {
    private static final AtomicBoolean initialized = new AtomicBoolean(false);

    private JcloudsTypeCoercions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        AtomicBoolean atomicBoolean = initialized;
        synchronized (atomicBoolean) {
            if (initialized.compareAndSet(false, true)) {
                TypeCoercions.registerAdapter((String)"20-jclouds-auto-value-builder", (TryCoercer)new CoercionFromAutoValueBuilder());
                TypeCoercions.registerAdapter((String)"20-jclouds-auto-value-creator", (TryCoercer)new CoercionFromAutoValueCreate());
            }
        }
    }

    static class CoercionFromAutoValueCreate
    implements TryCoercer {
        CoercionFromAutoValueCreate() {
        }

        public <T> Maybe<T> tryCoerce(Object input, TypeToken<T> targetTypeToken) {
            Class targetType = targetTypeToken.getRawType();
            Maybe result = null;
            Maybe firstError = null;
            if (!(input instanceof Map)) {
                return null;
            }
            Optional<Method> method = this.findCreateMethod(targetType);
            if (!method.isPresent()) {
                return null;
            }
            if (method.get().isAnnotationPresent(SerializedNames.class)) {
                Object[] argNames = method.get().getAnnotation(SerializedNames.class).value();
                Sets.SetView extraArgs = Sets.difference(((Map)input).keySet(), (Set)ImmutableSet.copyOf((Object[])argNames));
                if (!extraArgs.isEmpty()) {
                    return Maybe.absent((String)("create() for " + targetType.getCanonicalName() + " does not accept extra args " + extraArgs));
                }
                ArrayList orderedArgs = Lists.newArrayList();
                for (Object argName : argNames) {
                    orderedArgs.add(((Map)input).get(argName));
                }
                result = MethodCoercions.tryFindAndInvokeMultiParameterMethod((Object)targetType, (Iterable)ImmutableList.of((Object)method.get()), (List)orderedArgs);
                if (result != null && result.isPresent()) {
                    return Maybe.of((Object)result.get());
                }
                if (result != null && firstError == null) {
                    firstError = result;
                }
            }
            if (firstError != null) {
                return firstError;
            }
            return null;
        }

        private Optional<Method> findCreateMethod(Class<?> clazz) {
            for (Method m : clazz.getMethods()) {
                if ((m.getModifiers() & 8) != 8 || !m.getName().equals("create") || !clazz.isAssignableFrom(m.getReturnType())) continue;
                return Optional.of(m);
            }
            return Optional.empty();
        }
    }

    static class CoercionFromAutoValueBuilder
    implements TryCoercer {
        CoercionFromAutoValueBuilder() {
        }

        public <T> Maybe<T> tryCoerce(Object input, TypeToken<T> targetTypeToken) {
            Class targetType = targetTypeToken.getRawType();
            if (!(input instanceof Map)) {
                return null;
            }
            Optional<Method> builderMethod = this.findBuilderMethod(targetType);
            if (!builderMethod.isPresent()) {
                return null;
            }
            Maybe builder = MethodCoercions.tryFindAndInvokeMultiParameterMethod((Object)targetType, (Iterable)ImmutableList.of((Object)builderMethod.get()), (List)ImmutableList.of());
            if (builder.isAbsent()) {
                return builder;
            }
            Optional<Method> buildMethod = this.findBuildMethod(builder.get());
            if (!buildMethod.isPresent()) {
                return Maybe.absent((String)("Builder for " + targetType.getCanonicalName() + " has no build() method"));
            }
            for (Map.Entry entry : ((Map)input).entrySet()) {
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                Maybe invoked = MethodCoercions.tryFindAndInvokeBestMatchingMethod((Object)builder.get(), (String)key, val);
                if (!invoked.isAbsent()) continue;
                RuntimeException cause = Maybe.Absent.getException((Maybe)invoked);
                return Maybe.absent((String)("Builder for " + targetType.getCanonicalName() + " failed to call method for " + key), (Throwable)cause);
            }
            Maybe result = MethodCoercions.tryFindAndInvokeMultiParameterMethod((Object)builder.get(), (Iterable)ImmutableList.of((Object)buildMethod.get()), (List)ImmutableList.of());
            if (result.isAbsent()) {
                RuntimeException cause = Maybe.Absent.getException((Maybe)result);
                return Maybe.absent((String)("Builder for " + targetType.getCanonicalName() + " failed to call build method"), (Throwable)cause);
            }
            return result;
        }

        private Optional<Method> findBuilderMethod(Class<?> clazz) {
            for (Method m : clazz.getMethods()) {
                if ((m.getModifiers() & 8) != 8 || !m.getName().equals("builder") || m.getParameterTypes().length != 0) continue;
                return Optional.of(m);
            }
            return Optional.empty();
        }

        private Optional<Method> findBuildMethod(Object instance) {
            for (Method m : instance.getClass().getMethods()) {
                if ((m.getModifiers() & 8) == 8 || !m.getName().equals("build") || m.getParameterTypes().length != 0) continue;
                return Optional.of(m);
            }
            return Optional.empty();
        }
    }
}

