/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.compute.options.IpOptions;
import org.jclouds.azurecompute.arm.domain.AvailabilitySet;
import org.jclouds.azurecompute.arm.domain.DataDisk;
import org.jclouds.azurecompute.arm.domain.OSProfile;
import org.jclouds.azurecompute.arm.domain.Secrets;
import org.jclouds.compute.options.TemplateOptions;

public class AzureTemplateOptions
extends TemplateOptions
implements Cloneable {
    private AvailabilitySet availabilitySet;
    private String availabilitySetName;
    private List<DataDisk> dataDisks = ImmutableList.of();
    private String resourceGroup;
    private List<IpOptions> ipOptions = ImmutableList.of();
    private OSProfile.WindowsConfiguration windowsConfiguration;
    private List<Secrets> secrets = ImmutableList.of();
    private String customData;

    public AzureTemplateOptions availabilitySet(AvailabilitySet availabilitySet) {
        this.availabilitySet = availabilitySet;
        return this;
    }

    public AzureTemplateOptions availabilitySet(String availabilitySetName) {
        this.availabilitySetName = availabilitySetName;
        return this;
    }

    public AzureTemplateOptions resourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
        return this;
    }

    public AzureTemplateOptions dataDisks(Iterable<DataDisk> dataDisks) {
        for (DataDisk dataDisk : (Iterable)Preconditions.checkNotNull(dataDisks, (Object)"dataDisks")) {
            Preconditions.checkNotNull((Object)dataDisk, (Object)"all dataDisks must be non-empty");
        }
        this.dataDisks = ImmutableList.copyOf(dataDisks);
        return this;
    }

    public AzureTemplateOptions dataDisks(DataDisk ... dataDisks) {
        return this.dataDisks((Iterable<DataDisk>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)dataDisks, (Object)"dataDisks"))));
    }

    public AzureTemplateOptions ipOptions(Iterable<IpOptions> ipOptions) {
        for (IpOptions ipOption : (Iterable)Preconditions.checkNotNull(ipOptions, (Object)"ipOptions")) {
            Preconditions.checkNotNull((Object)ipOption, (Object)"all ipOptions must be non-empty");
        }
        this.ipOptions = ImmutableList.copyOf(ipOptions);
        return this;
    }

    public AzureTemplateOptions ipOptions(IpOptions ... ipOptions) {
        return this.ipOptions((Iterable<IpOptions>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)ipOptions, (Object)"ipOptions"))));
    }

    public AzureTemplateOptions windowsConfiguration(OSProfile.WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    public AzureTemplateOptions secrets(Iterable<? extends Secrets> secrets) {
        for (Secrets secret : (Iterable)Preconditions.checkNotNull(secrets, (Object)"secrets")) {
            Preconditions.checkNotNull((Object)secret, (Object)"secrets can not be empty");
        }
        this.secrets = ImmutableList.copyOf(secrets);
        return this;
    }

    public AzureTemplateOptions customData(String customData) {
        this.customData = customData;
        return this;
    }

    public AvailabilitySet getAvailabilitySet() {
        return this.availabilitySet;
    }

    public String getAvailabilitySetName() {
        return this.availabilitySetName;
    }

    public List<DataDisk> getDataDisks() {
        return this.dataDisks;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public List<IpOptions> getIpOptions() {
        return this.ipOptions;
    }

    public OSProfile.WindowsConfiguration getWindowsConfiguration() {
        return this.windowsConfiguration;
    }

    public List<Secrets> getSecrets() {
        return this.secrets;
    }

    public String getCustomData() {
        return this.customData;
    }

    public AzureTemplateOptions clone() {
        AzureTemplateOptions options = new AzureTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof AzureTemplateOptions) {
            AzureTemplateOptions eTo = (AzureTemplateOptions)AzureTemplateOptions.class.cast(to);
            eTo.availabilitySet(this.availabilitySet);
            eTo.availabilitySet(this.availabilitySetName);
            eTo.dataDisks(this.dataDisks);
            eTo.resourceGroup(this.resourceGroup);
            eTo.ipOptions(this.ipOptions);
            eTo.windowsConfiguration(this.windowsConfiguration);
            eTo.secrets(this.secrets);
            eTo.customData(this.customData);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AzureTemplateOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureTemplateOptions that = (AzureTemplateOptions)o;
        return Objects.equal((Object)this.availabilitySetName, (Object)that.availabilitySetName) && Objects.equal((Object)this.resourceGroup, (Object)that.resourceGroup) && Objects.equal((Object)this.availabilitySet, (Object)that.availabilitySet) && Objects.equal(this.dataDisks, that.dataDisks) && Objects.equal(this.ipOptions, that.ipOptions) && Objects.equal((Object)this.windowsConfiguration, (Object)that.windowsConfiguration) && Objects.equal(this.secrets, that.secrets) && Objects.equal((Object)this.customData, (Object)that.customData);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.availabilitySet, this.availabilitySetName, this.dataDisks, this.resourceGroup, this.ipOptions, this.customData});
    }

    public MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = super.string();
        if (this.availabilitySet != null) {
            toString.add("availabilitySet", (Object)this.availabilitySet);
        }
        if (this.availabilitySetName != null) {
            toString.add("availabilitySetName", (Object)this.availabilitySetName);
        }
        if (!this.dataDisks.isEmpty()) {
            toString.add("dataDisks", this.dataDisks);
        }
        if (this.resourceGroup != null) {
            toString.add("resourceGroup", (Object)this.resourceGroup);
        }
        if (!this.ipOptions.isEmpty()) {
            toString.add("ipOptions", this.ipOptions);
        }
        if (this.windowsConfiguration != null) {
            toString.add("windowsConfiguration", (Object)this.windowsConfiguration);
        }
        if (!this.secrets.isEmpty()) {
            toString.add("secrets", this.secrets);
        }
        if (this.customData != null) {
            toString.add("customData", (Object)this.customData);
        }
        return toString;
    }

    public static class Builder {
        public static AzureTemplateOptions availabilitySet(AvailabilitySet availabilitySet) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.availabilitySet(availabilitySet);
        }

        public static AzureTemplateOptions availabilitySet(String availabilitySetName) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.availabilitySet(availabilitySetName);
        }

        public static AzureTemplateOptions dataDisks(DataDisk ... dataDisks) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.dataDisks(dataDisks);
        }

        public static AzureTemplateOptions dataDisks(Iterable<DataDisk> dataDisks) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.dataDisks(dataDisks);
        }

        public static AzureTemplateOptions resourceGroup(String resourceGroup) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.resourceGroup(resourceGroup);
        }

        public static AzureTemplateOptions ipOptions(IpOptions ... ipOptions) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.ipOptions(ipOptions);
        }

        public static AzureTemplateOptions ipOptions(Iterable<IpOptions> ipOptions) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.ipOptions(ipOptions);
        }

        public static AzureTemplateOptions windowsConfiguration(OSProfile.WindowsConfiguration windowsConfiguration) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.windowsConfiguration(windowsConfiguration);
        }

        public static AzureTemplateOptions secrets(Iterable<? extends Secrets> secrets) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.secrets(secrets);
        }

        public static AzureTemplateOptions customData(String customData) {
            AzureTemplateOptions options = new AzureTemplateOptions();
            return options.customData(customData);
        }
    }
}

