/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ReflectionUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;

public final class LoggingUtils {
    private LoggingUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static Map<Integer, String> generateMnemonicMap(Class<?> clazz, String commonPrefix) {
        return LoggingUtils.generateMnemonicMap(clazz, (? super Field f) -> {
            String name = f.getName();
            return name.startsWith(commonPrefix);
        });
    }

    public static Map<Integer, String> generateMnemonicMap(Class<?> clazz, Predicate<? super Field> acceptor) {
        Collection<Field> fields = LoggingUtils.getMnemonicFields(clazz, acceptor);
        if (GenericUtils.isEmpty(fields)) {
            return Collections.emptyMap();
        }
        TreeMap<Integer, String> result = new TreeMap<Integer, String>(Comparator.naturalOrder());
        for (Field f : fields) {
            String name = f.getName();
            try {
                Number value = (Number)f.get(null);
                String prev = result.put(NumberUtils.toInteger(value), name);
                if (prev == null) continue;
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static Map<String, Integer> getAmbiguousMenmonics(Class<?> clazz, String commonPrefix) {
        return LoggingUtils.getAmbiguousMenmonics(clazz, (? super Field f) -> {
            String name = f.getName();
            return name.startsWith(commonPrefix);
        });
    }

    public static Map<String, Integer> getAmbiguousMenmonics(Class<?> clazz, Predicate<? super Field> acceptor) {
        Collection<Field> fields = LoggingUtils.getMnemonicFields(clazz, acceptor);
        if (GenericUtils.isEmpty(fields)) {
            return Collections.emptyMap();
        }
        TreeMap<String, Integer> result = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        TreeMap opcodesMap = new TreeMap(Comparator.naturalOrder());
        for (Field f : fields) {
            String name = f.getName();
            try {
                Number value = (Number)f.get(null);
                Integer key = NumberUtils.toInteger(value);
                ArrayList<String> nameList = (ArrayList<String>)opcodesMap.get(key);
                if (nameList == null) {
                    nameList = new ArrayList<String>();
                    opcodesMap.put(key, nameList);
                }
                nameList.add(name);
                int numOpcodes = nameList.size();
                if (numOpcodes <= 1) continue;
                result.put(name, key);
                if (numOpcodes != 2) continue;
                result.put((String)nameList.get(0), key);
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static Collection<Field> getMnemonicFields(Class<?> clazz, Predicate<? super Field> acceptor) {
        return ReflectionUtils.getMatchingFields(clazz, f -> {
            int mods = f.getModifiers();
            if (!(Modifier.isPublic(mods) && Modifier.isStatic(mods) && Modifier.isFinal(mods))) {
                return false;
            }
            Class<?> type = f.getType();
            if (!NumberUtils.isNumericClass(type)) {
                return false;
            }
            return acceptor.test((Field)f);
        });
    }

    public static boolean isLoggable(Level level, Level threshold) {
        if (level == null || threshold == null) {
            return false;
        }
        if (Level.OFF.equals(level) || Level.OFF.equals(threshold)) {
            return false;
        }
        if (Level.ALL.equals(threshold)) {
            return true;
        }
        return level.intValue() >= threshold.intValue();
    }

    public static SimplifiedLog wrap(final Logger logger) {
        if (logger == null) {
            return SimplifiedLog.EMPTY;
        }
        return new SimplifiedLog(){

            @Override
            public void log(Level level, Object message, Throwable t) {
                if (this.isEnabled(level)) {
                    LoggingUtils.logMessage(logger, level, message, t);
                }
            }

            @Override
            public boolean isEnabled(Level level) {
                return LoggingUtils.isLoggable(logger, level);
            }
        };
    }

    public static void logMessage(Logger logger, Level level, Object message, Throwable t) {
        if (logger == null || level == null || Level.OFF.equals(level)) {
            return;
        }
        if (Level.SEVERE.equals(level)) {
            logger.error(Objects.toString(message), t);
        } else if (Level.WARNING.equals(level)) {
            logger.warn(Objects.toString(message), t);
        } else if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            logger.info(Objects.toString(message), t);
        } else if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            logger.debug(Objects.toString(message), t);
        } else {
            logger.trace(Objects.toString(message), t);
        }
    }

    public static boolean isLoggable(Logger logger, Level level) {
        if (logger == null || level == null || Level.OFF.equals(level)) {
            return false;
        }
        if (Level.SEVERE.equals(level)) {
            return logger.isErrorEnabled();
        }
        if (Level.WARNING.equals(level)) {
            return logger.isWarnEnabled();
        }
        if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            return logger.isInfoEnabled();
        }
        if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            return logger.isDebugEnabled();
        }
        return logger.isTraceEnabled();
    }
}

