/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.domain.Credentials;

public final class SessionCredentials
extends Credentials {
    private final String sessionToken;
    private final Optional<Date> expiration;

    private SessionCredentials(String accessKeyId, String secretAccessKey, String sessionToken, Optional<Date> expiration) {
        super((String)Preconditions.checkNotNull((Object)accessKeyId, (Object)"accessKeyId"), (String)Preconditions.checkNotNull((Object)secretAccessKey, (String)"secretAccessKey for %s", (Object[])new Object[]{accessKeyId}));
        this.sessionToken = (String)Preconditions.checkNotNull((Object)sessionToken, (String)"sessionToken for %s", (Object[])new Object[]{accessKeyId});
        this.expiration = (Optional)Preconditions.checkNotNull(expiration, (String)"expiration for %s", (Object[])new Object[]{accessKeyId});
    }

    public String getAccessKeyId() {
        return this.identity;
    }

    public String getSecretAccessKey() {
        return this.credential;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public Optional<Date> getExpiration() {
        return this.expiration;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.identity, this.credential, this.sessionToken, this.expiration});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SessionCredentials other = (SessionCredentials)((Object)obj);
        return Objects.equal((Object)this.identity, (Object)other.identity) && Objects.equal((Object)this.credential, (Object)other.credential) && Objects.equal((Object)this.sessionToken, (Object)other.sessionToken) && Objects.equal(this.expiration, other.expiration);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("accessKeyId", (Object)this.identity).add("sessionToken", (Object)this.sessionToken).add("expiration", this.expiration.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SessionCredentials.builder().from(this);
    }

    public static final class Builder
    extends Credentials.Builder<SessionCredentials> {
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;
        private Optional<Date> expiration = Optional.absent();

        public Builder identity(String identity) {
            return this.accessKeyId(identity);
        }

        public Builder credential(String credential) {
            return this.secretAccessKey(credential);
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public Builder expiration(Date expiration) {
            this.expiration = Optional.fromNullable((Object)expiration);
            return this;
        }

        public SessionCredentials build() {
            return new SessionCredentials(this.accessKeyId, this.secretAccessKey, this.sessionToken, this.expiration);
        }

        public Builder from(SessionCredentials in) {
            return this.accessKeyId(in.identity).secretAccessKey(in.credential).sessionToken(in.sessionToken).expiration((Date)in.expiration.orNull());
        }
    }
}

