/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.kafka;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.trait.Resizable;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.sensor.BasicAttributeSensor;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.group.Cluster;
import org.apache.brooklyn.entity.group.DynamicCluster;
import org.apache.brooklyn.entity.messaging.kafka.KafkaBroker;
import org.apache.brooklyn.entity.messaging.kafka.KafkaClusterImpl;
import org.apache.brooklyn.entity.messaging.kafka.KafkaZooKeeper;
import org.apache.brooklyn.entity.zookeeper.ZooKeeperNode;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Kafka", description="Apache Kafka is a distributed publish-subscribe messaging system", iconUrl="classpath://org/apache/brooklyn/entity/messaging/kafka/kafka-google-doorway.jpg")
@ImplementedBy(value=KafkaClusterImpl.class)
public interface KafkaCluster
extends Entity,
Startable,
Resizable,
Group {
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = BrooklynConfigKeys.START_TIMEOUT;
    @SetFromFlag(value="initialSize")
    public static final ConfigKey<Integer> INITIAL_SIZE = ConfigKeys.newConfigKeyWithDefault((ConfigKey)Cluster.INITIAL_SIZE, (Object)1);
    @SetFromFlag(value="zookeeper")
    public static final BasicAttributeSensorAndConfigKey<ZooKeeperNode> ZOOKEEPER = new BasicAttributeSensorAndConfigKey(ZooKeeperNode.class, "kafka.cluster.zookeeper", "The zookeeper for the cluster; if null a default be will created");
    @SetFromFlag(value="zookeeperSpec")
    public static final BasicAttributeSensorAndConfigKey<EntitySpec<KafkaZooKeeper>> ZOOKEEPER_SPEC = new BasicAttributeSensorAndConfigKey(EntitySpec.class, "kafka.cluster.zookeeperSpec", "Spec for creating the kafka zookeeper");
    @SetFromFlag(value="brokerSpec")
    public static final BasicAttributeSensorAndConfigKey<EntitySpec<KafkaBroker>> BROKER_SPEC = new BasicAttributeSensorAndConfigKey(EntitySpec.class, "kafka.cluster.brokerSpec", "Spec for Kafka broker entiites to be created");
    public static final AttributeSensor<DynamicCluster> CLUSTER = new BasicAttributeSensor(DynamicCluster.class, "kafka.cluster.brokerCluster", "Underlying Kafka broker cluster");

    public ZooKeeperNode getZooKeeper();

    public DynamicCluster getCluster();
}

