/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.networking;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.core.location.geo.LocalhostExternalIpLoader;
import org.apache.brooklyn.location.jclouds.BasicJcloudsLocationCustomizer;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.networking.SecurityGroupDefinition;
import org.apache.brooklyn.location.jclouds.networking.SecurityGroupEditor;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Cidr;
import org.apache.brooklyn.util.time.Duration;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.Providers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsLocationSecurityGroupCustomizer
extends BasicJcloudsLocationCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsLocationSecurityGroupCustomizer.class);
    private static final LoadingCache<String, JcloudsLocationSecurityGroupCustomizer> CUSTOMISERS = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, JcloudsLocationSecurityGroupCustomizer>(){

        public JcloudsLocationSecurityGroupCustomizer load(String appContext) throws Exception {
            return new JcloudsLocationSecurityGroupCustomizer(appContext);
        }
    });
    private final Cache<Location, SecurityGroup> sharedGroupCache = CacheBuilder.newBuilder().build();
    private final Cache<String, SecurityGroup> uniqueGroupCache = CacheBuilder.newBuilder().build();
    private final String applicationId;
    private Supplier<Cidr> sshCidrSupplier;
    private Predicate<Exception> isExceptionRetryable = Predicates.alwaysFalse();

    protected JcloudsLocationSecurityGroupCustomizer(String applicationId) {
        this(applicationId, (Supplier<Cidr>)Suppliers.ofInstance((Object)new Cidr("0.0.0.0/0")));
    }

    protected JcloudsLocationSecurityGroupCustomizer(String applicationId, Supplier<Cidr> sshCidrSupplier) {
        this.applicationId = applicationId;
        this.sshCidrSupplier = sshCidrSupplier;
    }

    public static JcloudsLocationSecurityGroupCustomizer getInstance(String applicationId) {
        return (JcloudsLocationSecurityGroupCustomizer)CUSTOMISERS.getUnchecked((Object)applicationId);
    }

    public static JcloudsLocationSecurityGroupCustomizer getInstance(Entity entity) {
        return JcloudsLocationSecurityGroupCustomizer.getInstance(entity.getApplicationId());
    }

    public JcloudsLocationSecurityGroupCustomizer setRetryExceptionPredicate(Predicate<Exception> predicate) {
        this.isExceptionRetryable = (Predicate)Preconditions.checkNotNull(predicate, (Object)"predicate");
        return this;
    }

    public JcloudsLocationSecurityGroupCustomizer setSshCidrSupplier(Supplier<Cidr> cidrSupplier) {
        this.sshCidrSupplier = (Supplier)Preconditions.checkNotNull(cidrSupplier, (Object)"cidrSupplier");
        return this;
    }

    public JcloudsLocationSecurityGroupCustomizer addPermissionsToLocation(JcloudsMachineLocation location, IpPermission ... permissions) {
        this.addPermissionsToLocation(location, (Iterable<IpPermission>)ImmutableList.copyOf((Object[])permissions));
        return this;
    }

    public JcloudsLocationSecurityGroupCustomizer addPermissionsToLocation(JcloudsMachineLocation location, SecurityGroupDefinition securityGroupDefinition) {
        this.addPermissionsToLocation(location, securityGroupDefinition.getPermissions());
        return this;
    }

    private SecurityGroup getMachineUniqueSecurityGroup(final String nodeId, final String locationId, final SecurityGroupEditor groupEditor) {
        SecurityGroup machineUniqueSecurityGroup;
        Tasks.setBlockingDetails((String)("Loading unique security group for node: " + nodeId));
        try {
            machineUniqueSecurityGroup = (SecurityGroup)this.uniqueGroupCache.get((Object)nodeId, (Callable)new Callable<SecurityGroup>(){

                @Override
                public SecurityGroup call() throws Exception {
                    SecurityGroup sg = JcloudsLocationSecurityGroupCustomizer.this.getUniqueSecurityGroupForNodeCachingSharedGroupIfUnknown(nodeId, locationId, groupEditor);
                    if (sg == null) {
                        throw new IllegalStateException("Failed to find machine-unique group on node: " + nodeId);
                    }
                    return sg;
                }
            });
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)new Exception(e.getCause()));
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)new Exception(e.getCause()));
        }
        finally {
            Tasks.resetBlockingDetails();
        }
        return machineUniqueSecurityGroup;
    }

    public JcloudsLocationSecurityGroupCustomizer addPermissionsToLocation(JcloudsMachineLocation location, Iterable<IpPermission> permissions) {
        this.addPermissionsToLocationAndReturnSecurityGroup(location, permissions);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SecurityGroup> addPermissionsToLocationAndReturnSecurityGroup(JcloudsMachineLocation location, Iterable<IpPermission> permissions) {
        Class<JcloudsLocationSecurityGroupCustomizer> clazz = JcloudsLocationSecurityGroupCustomizer.class;
        synchronized (JcloudsLocationSecurityGroupCustomizer.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.addPermissionsInternal(permissions, location).values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePermissionsFromLocation(JcloudsMachineLocation location, Iterable<IpPermission> permissions) {
        Class<JcloudsLocationSecurityGroupCustomizer> clazz = JcloudsLocationSecurityGroupCustomizer.class;
        synchronized (JcloudsLocationSecurityGroupCustomizer.class) {
            this.removePermissionsInternal(location, permissions);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void removePermissionsInternal(JcloudsMachineLocation location, Iterable<IpPermission> permissions) {
        ComputeService computeService = location.getParent().getComputeService();
        String nodeId = location.getNode().getId();
        Optional securityApi = computeService.getSecurityGroupExtension();
        if (!securityApi.isPresent()) {
            LOG.warn("Security group extension for {} absent; cannot update node {} with {}", new Object[]{computeService, nodeId, permissions});
            return;
        }
        SecurityGroupEditor editor = this.createSecurityGroupEditor((SecurityGroupExtension)securityApi.get(), location.getNode().getLocation());
        String locationId = computeService.getContext().unwrap().getId();
        SecurityGroup machineUniqueSecurityGroup = this.getMachineUniqueSecurityGroup(nodeId, locationId, editor);
        editor.removePermissions(machineUniqueSecurityGroup, permissions);
    }

    private Map<String, SecurityGroup> addPermissionsInternal(Iterable<IpPermission> permissions, JcloudsMachineLocation location) {
        String nodeId = location.getNode().getId();
        Location nodeLocation = location.getNode().getLocation();
        ComputeService computeService = location.getParent().getComputeService();
        Optional securityApi = computeService.getSecurityGroupExtension();
        if (!securityApi.isPresent()) {
            LOG.warn("Security group extension for {} absent; cannot update node {} with {}", new Object[]{computeService, nodeId, permissions});
            return ImmutableMap.of();
        }
        SecurityGroupEditor groupEditor = this.createSecurityGroupEditor((SecurityGroupExtension)securityApi.get(), nodeLocation);
        String locationId = computeService.getContext().unwrap().getId();
        SecurityGroup machineUniqueSecurityGroup = this.getMachineUniqueSecurityGroup(nodeId, locationId, groupEditor);
        MutableList newPermissions = MutableList.copyOf(permissions);
        Iterables.removeAll((Iterable)newPermissions, (Collection)machineUniqueSecurityGroup.getIpPermissions());
        machineUniqueSecurityGroup = groupEditor.addPermissions(machineUniqueSecurityGroup, (Iterable<IpPermission>)newPermissions);
        return MutableMap.of((Object)machineUniqueSecurityGroup.getId(), (Object)machineUniqueSecurityGroup);
    }

    private SecurityGroup getUniqueSecurityGroupForNodeCachingSharedGroupIfUnknown(String nodeId, String locationId, SecurityGroupEditor groupEditor) {
        Set<SecurityGroup> groupsOnNode = groupEditor.listSecurityGroupsForNode(nodeId);
        if (groupsOnNode.isEmpty()) {
            return null;
        }
        if (locationId.equals("aws-ec2")) {
            if (groupsOnNode.size() == 2) {
                SecurityGroup unique;
                String expectedSharedName = this.getNameForSharedSecurityGroup();
                Iterator<SecurityGroup> it = groupsOnNode.iterator();
                SecurityGroup shared = it.next();
                if (shared.getName().endsWith(expectedSharedName)) {
                    unique = it.next();
                } else {
                    unique = shared;
                    shared = it.next();
                }
                if (!shared.getName().endsWith(expectedSharedName)) {
                    LOG.warn("Couldn't determine which security group is shared between instances in app {}. Expected={}, found={}", new Object[]{this.applicationId, expectedSharedName, groupsOnNode});
                    return null;
                }
                SecurityGroup old = this.sharedGroupCache.asMap().putIfAbsent(shared.getLocation(), shared);
                LOG.info("Loaded unique security group for node {} (in {}): {}", new Object[]{nodeId, this.applicationId, unique});
                if (old == null) {
                    LOG.info("Proactively set shared group for app {} to: {}", (Object)this.applicationId, (Object)shared);
                }
                return unique;
            }
            LOG.warn("Expected to find two security groups on node {} in app {} (one shared, one unique). Found {}: {}", new Object[]{nodeId, this.applicationId, groupsOnNode.size(), groupsOnNode});
        }
        return (SecurityGroup)Iterables.getOnlyElement(groupsOnNode);
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, Template template) {
        Optional securityApi = computeService.getSecurityGroupExtension();
        if (!securityApi.isPresent()) {
            LOG.warn("Security group extension for {} absent; cannot configure security groups in context: {}", (Object)computeService, (Object)this.applicationId);
        } else if (template.getLocation() == null) {
            LOG.warn("No location has been set on {}; cannot configure security groups in context: {}", (Object)template, (Object)this.applicationId);
        } else {
            LOG.info("Configuring security groups on location {} in context {}", (Object)location, (Object)this.applicationId);
            SecurityGroupEditor groupEditor = this.createSecurityGroupEditor((SecurityGroupExtension)securityApi.get(), template.getLocation());
            this.setSecurityGroupOnTemplate(location, template, groupEditor);
        }
    }

    private SecurityGroupEditor createSecurityGroupEditor(SecurityGroupExtension securityApi, Location location) {
        return new SecurityGroupEditor(location, securityApi, this.isExceptionRetryable);
    }

    private void setSecurityGroupOnTemplate(JcloudsLocation location, final Template template, final SecurityGroupEditor groupEditor) {
        SecurityGroup shared;
        Tasks.setBlockingDetails((String)("Loading security group shared by instances in " + template.getLocation() + " in app " + this.applicationId));
        try {
            shared = (SecurityGroup)this.sharedGroupCache.get((Object)template.getLocation(), (Callable)new Callable<SecurityGroup>(){

                @Override
                public SecurityGroup call() throws Exception {
                    return JcloudsLocationSecurityGroupCustomizer.this.getOrCreateSharedSecurityGroup(template.getLocation(), groupEditor);
                }
            });
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)new Exception(e.getCause()));
        }
        finally {
            Tasks.resetBlockingDetails();
        }
        Set originalGroups = template.getOptions().getGroups();
        template.getOptions().securityGroups(new String[]{shared.getName()});
        if (!originalGroups.isEmpty()) {
            LOG.info("Replaced configured security groups: configured={}, replaced with={}", (Object)originalGroups, (Object)template.getOptions().getGroups());
        } else {
            LOG.debug("Configured security groups at {} to: {}", (Object)location, (Object)template.getOptions().getGroups());
        }
    }

    private SecurityGroup getOrCreateSharedSecurityGroup(Location location, SecurityGroupEditor groupEditor) {
        String groupName = this.getNameForSharedSecurityGroup();
        Optional<SecurityGroup> shared = groupEditor.findSecurityGroupByName(groupName);
        if (shared.isPresent()) {
            LOG.info("Found existing shared security group in {} for app {}: {}", new Object[]{location, this.applicationId, groupName});
            return (SecurityGroup)shared.get();
        }
        LOG.info("Creating new shared security group in {} for app {}: {}", new Object[]{location, this.applicationId, groupName});
        return this.createBaseSecurityGroupInLocation(groupName, groupEditor);
    }

    private SecurityGroup createBaseSecurityGroupInLocation(String groupName, SecurityGroupEditor groupEditor) {
        SecurityGroup group = groupEditor.createSecurityGroup(groupName);
        String groupId = group.getProviderId();
        int fromPort = 0;
        if (this.isOpenstackNova(groupEditor.getLocation())) {
            groupId = group.getId();
            fromPort = 1;
        }
        IpPermission.Builder allWithinGroup = IpPermission.builder().groupId(groupId).fromPort(fromPort).toPort(65535);
        group = groupEditor.addPermission(group, allWithinGroup.ipProtocol(IpProtocol.TCP).build());
        group = groupEditor.addPermission(group, allWithinGroup.ipProtocol(IpProtocol.UDP).build());
        if (!this.isAzure(groupEditor.getLocation())) {
            group = groupEditor.addPermission(group, allWithinGroup.ipProtocol(IpProtocol.ICMP).fromPort(-1).toPort(-1).build());
        }
        IpPermission sshPermission = IpPermission.builder().fromPort(22).toPort(22).ipProtocol(IpProtocol.TCP).cidrBlock(this.getBrooklynCidrBlock()).build();
        group = groupEditor.addPermission(group, sshPermission);
        return group;
    }

    private Set<String> getJcloudsLocationIds(String jcloudsApiId) {
        return this.getJcloudsLocationIds((Collection<? extends String>)ImmutableList.of((Object)jcloudsApiId));
    }

    private Set<String> getJcloudsLocationIds(final Collection<? extends String> jcloudsApiIds) {
        ImmutableSet openstackNovaProviders = FluentIterable.from((Iterable)Providers.all()).filter((Predicate)new Predicate<ProviderMetadata>(){

            public boolean apply(ProviderMetadata providerMetadata) {
                return jcloudsApiIds.contains(providerMetadata.getApiMetadata().getId());
            }
        }).transform((Function)new Function<ProviderMetadata, String>(){

            @Nullable
            public String apply(ProviderMetadata input) {
                return input.getId();
            }
        }).toSet();
        return new ImmutableSet.Builder().addAll((Iterable)openstackNovaProviders).addAll(jcloudsApiIds).build();
    }

    private boolean isOpenstackNova(Location location) {
        Set<String> computeIds = this.getJcloudsLocationIds((Collection<? extends String>)ImmutableList.of((Object)"openstack-nova", (Object)"openstack-mitaka-nova", (Object)"openstack-devtest-compute"));
        return location.getParent() != null && Iterables.contains(computeIds, (Object)location.getParent().getId());
    }

    private boolean isAzure(Location location) {
        Set<String> computeIds = this.getJcloudsLocationIds("azurecompute");
        return location.getParent() != null && Iterables.contains(computeIds, (Object)location.getParent().getId());
    }

    public String getBrooklynCidrBlock() {
        return ((Cidr)this.sshCidrSupplier.get()).toString();
    }

    @VisibleForTesting
    String getNameForSharedSecurityGroup() {
        return "brooklyn-" + this.applicationId.toLowerCase() + "-shared";
    }

    @VisibleForTesting
    void clearSecurityGroupCaches() {
        LOG.info("Clearing security group caches");
        this.sharedGroupCache.invalidateAll();
        this.uniqueGroupCache.invalidateAll();
    }

    public static Predicate<Exception> newAwsExceptionRetryPredicate() {
        return new AwsExceptionRetryPredicate();
    }

    private static class LocalhostExternalIpCidrSupplier
    implements Supplier<Cidr> {
        private volatile Cidr cidr;

        private LocalhostExternalIpCidrSupplier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Cidr get() {
            Cidr local = this.cidr;
            if (local == null) {
                LocalhostExternalIpCidrSupplier localhostExternalIpCidrSupplier = this;
                synchronized (localhostExternalIpCidrSupplier) {
                    local = this.cidr;
                    if (local == null) {
                        String externalIp = LocalhostExternalIpLoader.getLocalhostIpWithin((Duration)Duration.seconds((Number)5));
                        this.cidr = local = new Cidr(externalIp + "/32");
                    }
                }
            }
            return local;
        }
    }

    private static class AwsExceptionRetryPredicate
    implements Predicate<Exception> {
        private static final Set<String> AWS_ERRORS_TO_RETRY = ImmutableSet.of((Object)"InvalidGroup.InUse", (Object)"DependencyViolation", (Object)"RequestLimitExceeded");

        private AwsExceptionRetryPredicate() {
        }

        public boolean apply(Exception input) {
            AWSResponseException exception = (AWSResponseException)Exceptions.getFirstThrowableOfType((Throwable)input, AWSResponseException.class);
            if (exception != null) {
                String code = exception.getError().getCode();
                return AWS_ERRORS_TO_RETRY.contains(code);
            }
            return false;
        }
    }
}

