/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.nosql.redis;

import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.AttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.nosql.redis.RedisStoreImpl;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.util.core.ResourcePredicates;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="Redis Server", description="Redis is an open-source, networked, in-memory, key-value data store with optional durability", iconUrl="classpath:///redis-logo.png")
@ImplementedBy(value=RedisStoreImpl.class)
public interface RedisStore
extends SoftwareProcess {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"2.8.4");
    @SetFromFlag(value="archiveNameFormat")
    public static final ConfigKey<String> ARCHIVE_DIRECTORY_NAME_FORMAT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.ARCHIVE_DIRECTORY_NAME_FORMAT, (Object)"redis-%s");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = ConfigKeys.newSensorAndConfigKeyWithDefault((AttributeSensorAndConfigKey)SoftwareProcess.DOWNLOAD_URL, (Object)"http://download.redis.io/releases/redis-${version}.tar.gz");
    @SetFromFlag(value="redisPort")
    public static final PortAttributeSensorAndConfigKey REDIS_PORT = ConfigKeys.newPortSensorAndConfigKey((String)"redis.port", (String)"Redis port number", (Object)"6379+");
    @SetFromFlag(value="redisConfigTemplateUrl")
    public static final ConfigKey<String> REDIS_CONFIG_TEMPLATE_URL = ConfigKeys.builder(String.class).name("redis.config.templateUrl").description("Template file (in freemarker format) for the redis.conf config file").defaultValue((Object)"classpath://org/apache/brooklyn/entity/nosql/redis/redis.conf").constraint(ResourcePredicates.urlExists()).build();
    public static final AttributeSensor<Integer> UPTIME = Sensors.newIntegerSensor((String)"redis.uptime", (String)"Redis uptime in seconds");
    public static final AttributeSensor<Integer> TOTAL_CONNECTIONS_RECEIVED = Sensors.newIntegerSensor((String)"redis.connections.received.total", (String)"Total number of connections accepted by the server");
    public static final AttributeSensor<Integer> TOTAL_COMMANDS_PROCESSED = Sensors.newIntegerSensor((String)"redis.commands.processed.total", (String)"Total number of commands processed by the server");
    public static final AttributeSensor<Integer> EXPIRED_KEYS = Sensors.newIntegerSensor((String)"redis.keys.expired", (String)"Total number of key expiration events");
    public static final AttributeSensor<Integer> EVICTED_KEYS = Sensors.newIntegerSensor((String)"redis.keys.evicted", (String)"Number of evicted keys due to maxmemory limit");
    public static final AttributeSensor<Integer> KEYSPACE_HITS = Sensors.newIntegerSensor((String)"redis.keyspace.hits", (String)"Number of successful lookup of keys in the main dictionary");
    public static final AttributeSensor<Integer> KEYSPACE_MISSES = Sensors.newIntegerSensor((String)"redis.keyspace.misses", (String)"Number of failed lookup of keys in the main dictionary");

    public String getAddress();

    public Integer getRedisPort();
}

