/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.spi.resolve;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.camp.CampPlatform;
import org.apache.brooklyn.camp.spi.AssemblyTemplate;
import org.apache.brooklyn.camp.spi.instantiate.BasicAssemblyTemplateInstantiator;
import org.apache.brooklyn.camp.spi.pdp.Artifact;
import org.apache.brooklyn.camp.spi.pdp.AssemblyTemplateConstructor;
import org.apache.brooklyn.camp.spi.pdp.DeploymentPlan;
import org.apache.brooklyn.camp.spi.pdp.Service;
import org.apache.brooklyn.camp.spi.resolve.PdpMatcher;
import org.apache.brooklyn.camp.spi.resolve.PlanInterpreter;
import org.apache.brooklyn.camp.spi.resolve.interpret.PlanInterpretationContext;
import org.apache.brooklyn.camp.spi.resolve.interpret.PlanInterpretationNode;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.yaml.Yamls;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.yaml.snakeyaml.error.YAMLException;

public class PdpProcessor {
    final CampPlatform campPlatform;
    final List<PdpMatcher> matchers = new ArrayList<PdpMatcher>();
    final List<PlanInterpreter> interpreters = new ArrayList<PlanInterpreter>();

    public PdpProcessor(CampPlatform campPlatform) {
        this.campPlatform = campPlatform;
    }

    public DeploymentPlan parseDeploymentPlan(Reader yaml) {
        return this.parseDeploymentPlan(Streams.readFully((Reader)yaml));
    }

    public DeploymentPlan parseDeploymentPlan(String yaml) {
        Iterable template = Yamls.parseAll((String)yaml);
        Map dpRootUninterpreted = null;
        try {
            dpRootUninterpreted = (Map)Yamls.getAs((Object)template, Map.class);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new YAMLException("Plan not in acceptable format: " + (e.getMessage() != null ? e.getMessage() : "" + e), (Throwable)e);
        }
        Map<String, Object> dpRootInterpreted = this.applyInterpreters(dpRootUninterpreted);
        return DeploymentPlan.of(dpRootInterpreted, yaml);
    }

    public AssemblyTemplate registerDeploymentPlan(Reader yaml) {
        DeploymentPlan plan = this.parseDeploymentPlan(yaml);
        return this.registerDeploymentPlan(plan);
    }

    public AssemblyTemplate registerDeploymentPlan(DeploymentPlan plan) {
        return this.resolveDeploymentPlanInternal(plan).construct(true);
    }

    public AssemblyTemplate resolveDeploymentPlan(Reader yaml) {
        DeploymentPlan plan = this.parseDeploymentPlan(yaml);
        return this.resolveDeploymentPlan(plan);
    }

    public AssemblyTemplate resolveDeploymentPlan(DeploymentPlan plan) {
        return this.resolveDeploymentPlanInternal(plan).construct(false);
    }

    protected AssemblyTemplateConstructor resolveDeploymentPlanInternal(DeploymentPlan plan) {
        MutableMap attrs;
        AssemblyTemplateConstructor atc = new AssemblyTemplateConstructor(this.campPlatform);
        if (plan.getName() != null) {
            atc.name(plan.getName());
        }
        if (plan.getDescription() != null) {
            atc.description(plan.getDescription());
        }
        if (plan.getSourceCode() != null) {
            atc.sourceCode(plan.getSourceCode());
        }
        if (plan.getServices() != null) {
            for (Service svc : plan.getServices()) {
                this.applyMatchers(svc, atc);
            }
        }
        if (plan.getArtifacts() != null) {
            for (Artifact art : plan.getArtifacts()) {
                this.applyMatchers(art, atc);
            }
        }
        if ((attrs = plan.getCustomAttributes()) != null && !attrs.isEmpty()) {
            MutableMap customAttrs = attrs;
            if (customAttrs.containsKey("id")) {
                customAttrs = MutableMap.copyOf(attrs);
                customAttrs.put("planId", customAttrs.remove("id"));
            }
            atc.addCustomAttributes((Map<String, Object>)customAttrs);
        }
        if (atc.getInstantiator() == null) {
            atc.instantiator(BasicAssemblyTemplateInstantiator.class);
        }
        return atc;
    }

    public AssemblyTemplate registerPdpFromArchive(InputStream archiveInput) {
        try {
            ArchiveEntry entry;
            ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream(archiveInput);
            while ((entry = input.getNextEntry()) != null) {
            }
            throw new UnsupportedOperationException("in progress");
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void addMatcher(PdpMatcher m) {
        this.matchers.add(m);
    }

    public List<PdpMatcher> getMatchers() {
        return this.matchers;
    }

    protected void applyMatchers(Object deploymentPlanItem, AssemblyTemplateConstructor atc) {
        for (PdpMatcher matcher : this.getMatchers()) {
            if (!matcher.accepts(deploymentPlanItem) || !matcher.apply(deploymentPlanItem, atc)) continue;
            return;
        }
        throw new UserFacingException("Unable to match plan item: " + deploymentPlanItem);
    }

    public void addInterpreter(PlanInterpreter interpreter) {
        this.interpreters.add(interpreter);
    }

    @VisibleForTesting
    public Map<String, Object> applyInterpreters(Map<String, ?> originalDeploymentPlan) {
        PlanInterpretationNode interpretation = new PlanInterpretationNode(new PlanInterpretationContext(originalDeploymentPlan, this.interpreters));
        return (Map)interpretation.getNewValue();
    }
}

