/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.MoreObjects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.brooklyn.api.location.OsDetails;

@Immutable
public class BasicOsDetails
implements OsDetails {
    final String name;
    final String arch;
    final String version;
    final boolean is64bit;
    public static final String UNIX_OS_NAME_PATTERNS = "(?i).*linux.*|centos|debian|fedora|gentoo|rhel|slackware|solaris|suse|ubuntu|coreos";

    public BasicOsDetails(String name, String arch, String version) {
        this(name, arch, version, arch != null && arch.contains("64"));
    }

    public BasicOsDetails(String name, String arch, String version, boolean is64Bit) {
        this.name = name;
        this.arch = arch;
        this.version = version;
        this.is64bit = is64Bit;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getArch() {
        return this.arch;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean isWindows() {
        return this.getName() != null && this.getName().toLowerCase().contains("microsoft");
    }

    public boolean isLinux() {
        return this.getName() != null && Pattern.matches(UNIX_OS_NAME_PATTERNS, this.getName());
    }

    public boolean isMac() {
        return this.getName() != null && this.getName().equals("Mac OS X");
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public String toString() {
        return MoreObjects.toStringHelper(OsDetails.class).omitNullValues().add("name", (Object)this.name).add("version", (Object)this.version).add("arch", (Object)this.arch).toString();
    }

    public static class Factory {
        public static final OsDetails ANONYMOUS_LINUX = new BasicOsDetails("linux", "i386", "unknown");
        public static final OsDetails ANONYMOUS_LINUX_64 = new BasicOsDetails("linux", "x86_64", "unknown");

        public static OsDetails newLocalhostInstance() {
            return new BasicOsDetails(System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"));
        }
    }

    public static class OsVersions {
        public static final String MAC_10_8 = "10.8";
        public static final String MAC_10_9 = "10.9";
    }

    public static class OsArchs {
        public static final String X_86_64 = "x86_64";
        public static final String I386 = "i386";
    }

    public static class OsNames {
        public static final String MAC_OS_X = "Mac OS X";
    }
}

