/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.network;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.location.access.PortForwardManager;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.text.StringPredicates;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractOnNetworkEnricher
extends AbstractEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOnNetworkEnricher.class);
    public static ConfigKey<Collection<? extends AttributeSensor<?>>> SENSORS = ConfigKeys.newConfigKey(new TypeToken<Collection<? extends AttributeSensor<?>>>(){}, "sensors", "The multiple sensors whose mapped values are to be re-published (with suffix \"mapped.networkName\"); if 'sensors' is not specified, defaults to 'mapMatching'");
    public static ConfigKey<String> MAP_MATCHING = ConfigKeys.newStringConfigKey("mapMatching", "Whether to map all, based on a sensor naming convention (re-published with suffix \"mapped.networkName\"); if 'sensors' is not specified, defaults to matching case-insensitive suffix of 'port', 'uri', 'url', 'endpoint' or 'hostAndPort'", "(?i)(.+\\.)?(port|uri|url|endpoint|hostandport)");
    public static ConfigKey<Function<? super String, String>> SENSOR_NAME_CONVERTER = ConfigKeys.newConfigKey(new TypeToken<Function<? super String, String>>(){}, "sensorNameConverter", "The converter to use, to map from the original sensor name to the re-published sensor name");
    protected Collection<AttributeSensor<?>> sensors;
    protected Optional<Predicate<Sensor<?>>> mapMatching;
    protected Function<? super String, String> sensorNameConverter;
    protected PortForwardManager.AssociationListener pfmListener;

    protected abstract Optional<HostAndPort> getMappedEndpoint(Entity var1, MachineLocation var2, int var3);

    @Override
    public void setEntity(final EntityLocal entity) {
        super.setEntity(entity);
        this.checkConfig();
        this.sensors = this.resolveSensorsConfig();
        this.mapMatching = this.sensors.isEmpty() ? Optional.of(this.resolveMapMatchingConfig()) : Optional.absent();
        this.sensorNameConverter = this.getRequiredConfig(SENSOR_NAME_CONVERTER);
        this.subscriptions().subscribe((Entity)entity, AbstractEntity.LOCATION_ADDED, new SensorEventListener<Location>(){

            public void onEvent(SensorEvent<Location> event) {
                LOG.debug("{} attempting transformations, triggered by location-added {}, to {}", new Object[]{AbstractOnNetworkEnricher.this, event.getValue(), entity});
                AbstractOnNetworkEnricher.this.tryTransformAll();
            }
        });
        for (AttributeSensor<?> sensor : this.sensors) {
            this.subscriptions().subscribe((Entity)entity, sensor, new SensorEventListener<Object>(){

                public void onEvent(SensorEvent<Object> event) {
                    LOG.debug("{} attempting transformations, triggered by sensor-event {}->{}, to {}", new Object[]{AbstractOnNetworkEnricher.this, event.getSensor().getName(), event.getValue(), entity});
                    AbstractOnNetworkEnricher.this.tryTransform((AttributeSensor)event.getSensor());
                }
            });
        }
        if (this.mapMatching.isPresent()) {
            Sensor wildcardSensor = null;
            this.subscriptions().subscribe((Entity)entity, wildcardSensor, new SensorEventListener<Object>(){

                public void onEvent(SensorEvent<Object> event) {
                    if (((Predicate)AbstractOnNetworkEnricher.this.mapMatching.get()).apply((Object)event.getSensor())) {
                        LOG.debug("{} attempting transformations, triggered by sensor-event {}->{}, to {}", new Object[]{AbstractOnNetworkEnricher.this, event.getSensor().getName(), event.getValue(), entity});
                        AbstractOnNetworkEnricher.this.tryTransform((AttributeSensor)event.getSensor());
                    }
                }
            });
        }
        this.tryTransformAll();
    }

    protected void tryTransformAll() {
        if (!this.isRunning()) {
            return;
        }
        Maybe<MachineLocation> machine = this.getMachine();
        if (machine.isAbsent()) {
            return;
        }
        for (AttributeSensor<?> attributeSensor : this.sensors) {
            try {
                this.tryTransform((MachineLocation)machine.get(), attributeSensor);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                LOG.warn("Problem transforming sensor " + attributeSensor + " of " + this.entity, (Throwable)e);
            }
        }
        if (this.mapMatching.isPresent()) {
            for (Sensor sensor : this.entity.getEntityType().getSensors()) {
                if (!(sensor instanceof AttributeSensor) || !((Predicate)this.mapMatching.get()).apply((Object)sensor)) continue;
                try {
                    this.tryTransform((MachineLocation)machine.get(), (AttributeSensor)sensor);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    LOG.warn("Problem transforming sensor " + sensor + " of " + this.entity, (Throwable)e);
                }
            }
        }
    }

    protected void tryTransform(AttributeSensor<?> sensor) {
        if (!this.isRunning()) {
            return;
        }
        Maybe<MachineLocation> machine = this.getMachine();
        if (machine.isAbsent()) {
            return;
        }
        this.tryTransform((MachineLocation)machine.get(), sensor);
    }

    protected void tryTransform(MachineLocation machine, AttributeSensor<?> sensor) {
        Object sensorVal = this.entity.sensors().get(sensor);
        if (sensorVal == null) {
            return;
        }
        Maybe<String> newVal = this.transformVal(machine, sensor, sensorVal);
        if (newVal.isAbsent()) {
            return;
        }
        AttributeSensor<String> mappedSensor = Sensors.newStringSensor((String)this.sensorNameConverter.apply((Object)sensor.getName()));
        if (((String)newVal.get()).equals(this.entity.sensors().get(mappedSensor))) {
            return;
        }
        LOG.debug("{} publishing value {} (original sensor value {}) for mapped sensor {}, of entity {}", new Object[]{this, newVal.get(), sensorVal, mappedSensor, this.entity});
        this.entity.sensors().set(mappedSensor, newVal.get());
    }

    protected Maybe<String> transformVal(MachineLocation machine, AttributeSensor<?> sensor, Object sensorVal) {
        if (sensorVal == null) {
            return Maybe.absent();
        }
        if (this.isPort(sensorVal)) {
            int port = this.toInteger(sensorVal);
            return this.transformPort((Entity)this.entity, machine, port);
        }
        if (this.isUri(sensorVal)) {
            return this.transformUri((Entity)this.entity, machine, sensorVal.toString());
        }
        if (this.isHostAndPort(sensorVal)) {
            return this.transformHostAndPort((Entity)this.entity, machine, sensorVal.toString());
        }
        return Maybe.absent();
    }

    protected boolean isUri(Object sensorVal) {
        if (sensorVal instanceof URI || sensorVal instanceof URL) {
            return true;
        }
        try {
            URI uri = new URI(sensorVal.toString());
            return uri.getScheme() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected boolean isPort(Object sensorVal) {
        if (sensorVal instanceof Integer || sensorVal instanceof Long) {
            return Networking.isPortValid((Integer)((Number)sensorVal).intValue());
        }
        if (sensorVal instanceof CharSequence) {
            String val = sensorVal.toString().trim();
            return val.matches("[0-9]+") && val.length() <= 5 && Networking.isPortValid((Integer)Integer.parseInt(val));
        }
        return false;
    }

    protected int toInteger(Object sensorVal) {
        if (sensorVal instanceof Number) {
            return ((Number)sensorVal).intValue();
        }
        if (sensorVal instanceof CharSequence) {
            return Integer.parseInt(sensorVal.toString().trim());
        }
        throw new IllegalArgumentException("Expected number but got " + sensorVal + " of type " + (sensorVal != null ? sensorVal.getClass() : null));
    }

    protected boolean isHostAndPort(Object sensorVal) {
        if (sensorVal instanceof HostAndPort) {
            return true;
        }
        if (sensorVal instanceof String) {
            try {
                HostAndPort hostAndPort = HostAndPort.fromString((String)((String)sensorVal));
                return hostAndPort.hasPort();
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    protected Maybe<String> transformUri(Entity source, MachineLocation machine, String sensorVal) {
        URI uri = URI.create(sensorVal);
        int port = uri.getPort();
        if (port == -1 && "http".equalsIgnoreCase(uri.getScheme())) {
            port = 80;
        }
        if (port == -1 && "https".equalsIgnoreCase(uri.getScheme())) {
            port = 443;
        }
        if (port != -1) {
            URI result;
            Optional<HostAndPort> mappedEndpoint = this.getMappedEndpoint(source, machine, port);
            if (!mappedEndpoint.isPresent()) {
                LOG.trace("network-facing enricher not transforming {} URI {}, because no port-mapping for {}", new Object[]{source, sensorVal, machine});
                return Maybe.absent();
            }
            if (!((HostAndPort)mappedEndpoint.get()).hasPort()) {
                LOG.debug("network-facing enricher not transforming {} URI {}, because no port in target {} for {}", new Object[]{source, sensorVal, mappedEndpoint, machine});
                return Maybe.absent();
            }
            try {
                result = new URI(uri.getScheme(), uri.getUserInfo(), ((HostAndPort)mappedEndpoint.get()).getHostText(), ((HostAndPort)mappedEndpoint.get()).getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                LOG.debug("Error transforming URI " + uri + ", using target " + mappedEndpoint + "; rethrowing");
                throw Exceptions.propagateAnnotated((String)("Error transforming URI " + uri + ", using target " + mappedEndpoint), (Throwable)e);
            }
            return Maybe.of((Object)result.toString());
        }
        LOG.debug("sensor mapper not transforming URI " + uri + " because no port defined");
        return Maybe.absent();
    }

    protected Maybe<String> transformHostAndPort(Entity source, MachineLocation machine, String sensorVal) {
        HostAndPort hostAndPort = HostAndPort.fromString((String)sensorVal);
        if (hostAndPort.hasPort()) {
            int port = hostAndPort.getPort();
            Optional<HostAndPort> mappedEndpoint = this.getMappedEndpoint(source, machine, port);
            if (!mappedEndpoint.isPresent()) {
                LOG.debug("network-facing enricher not transforming {} host-and-port {}, because no port-mapping for {}", new Object[]{source, sensorVal, machine});
                return Maybe.absent();
            }
            if (!((HostAndPort)mappedEndpoint.get()).hasPort()) {
                LOG.debug("network-facing enricher not transforming {} host-and-port {}, because no port in target {} for {}", new Object[]{source, sensorVal, mappedEndpoint, machine});
                return Maybe.absent();
            }
            return Maybe.of((Object)((HostAndPort)mappedEndpoint.get()).toString());
        }
        LOG.debug("network-facing enricher not transforming {} host-and-port {} because defines no port", (Object)source, (Object)hostAndPort);
        return Maybe.absent();
    }

    protected Maybe<String> transformPort(Entity source, MachineLocation machine, int sensorVal) {
        if (Networking.isPortValid((Integer)sensorVal)) {
            Optional<HostAndPort> mappedEndpoint = this.getMappedEndpoint(source, machine, sensorVal);
            if (!mappedEndpoint.isPresent()) {
                LOG.debug("network-facing enricher not transforming {} port {}, because no port-mapping for {}", new Object[]{source, sensorVal, machine});
                return Maybe.absent();
            }
            if (!((HostAndPort)mappedEndpoint.get()).hasPort()) {
                LOG.debug("network-facing enricher not transforming {} port {}, because no port in target {} for {}", new Object[]{source, sensorVal, mappedEndpoint, machine});
                return Maybe.absent();
            }
            return Maybe.of((Object)((HostAndPort)mappedEndpoint.get()).toString());
        }
        LOG.debug("network-facing enricher not transforming {} port {} because not a valid port", (Object)source, (Object)sensorVal);
        return Maybe.absent();
    }

    protected Maybe<MachineLocation> getMachine() {
        return Machines.findUniqueMachineLocation(this.entity.getLocations());
    }

    protected void checkConfig() {
        Collection<AttributeSensor<?>> sensors = this.getConfig(SENSORS);
        Maybe<Object> rawMapMatching = this.config().getRaw(MAP_MATCHING);
        String mapMatching = (String)this.config().get(MAP_MATCHING);
        if (sensors == null || sensors.isEmpty()) {
            if (Strings.isBlank((CharSequence)mapMatching)) {
                throw new IllegalStateException(this + " requires 'sensors' config (when 'mapMatching' is explicitly blank)");
            }
        } else if (rawMapMatching.isPresent()) {
            throw new IllegalStateException(this + " must not have explicit 'mapMatching' and 'sensors' config");
        }
    }

    protected Collection<AttributeSensor<?>> resolveSensorsConfig() {
        Collection<AttributeSensor<?>> sensors = this.getConfig(SENSORS);
        ArrayList result = Lists.newArrayList();
        if (sensors != null) {
            for (AttributeSensor<?> s : sensors) {
                AttributeSensor coercedSensor = TypeCoercions.coerce(s, AttributeSensor.class);
                AttributeSensor typedSensor = (AttributeSensor)this.entity.getEntityType().getSensor(coercedSensor.getName());
                result.add(typedSensor != null ? typedSensor : coercedSensor);
            }
        }
        return result;
    }

    protected Predicate<Sensor<?>> resolveMapMatchingConfig() {
        String regex = this.getConfig(MAP_MATCHING);
        final Predicate namePredicate = StringPredicates.matchesRegex((String)regex);
        return new Predicate<Sensor<?>>(){

            public boolean apply(Sensor<?> input) {
                return input != null && namePredicate.apply((Object)input.getName());
            }
        };
    }

    public static class SensorNameConverter
    implements Function<String, String> {
        private final String network;

        public SensorNameConverter(String network) {
            this.network = network;
        }

        public String apply(String input) {
            if (input == null) {
                throw new NullPointerException("Sensor name must not be null");
            }
            String lowerInput = input.toLowerCase();
            if (lowerInput.endsWith("uri")) {
                return input + ".mapped." + this.network;
            }
            if (lowerInput.endsWith("url")) {
                return input + ".mapped." + this.network;
            }
            if (lowerInput.endsWith("endpoint")) {
                return input + ".mapped." + this.network;
            }
            if (lowerInput.endsWith("hostandport")) {
                return input + ".mapped." + this.network;
            }
            if (lowerInput.endsWith("port")) {
                String prefix = input.substring(0, input.length() - "port".length());
                boolean includeDot = !prefix.isEmpty() && !prefix.endsWith(".");
                return prefix + (includeDot ? "." : "") + "endpoint.mapped." + this.network;
            }
            return input + ".mapped." + this.network;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.network + ")";
        }
    }
}

