/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.sensor.BasicSensorEvent;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Combiner", description="Combines and apply a transformation to sensors of an entity")
public class Combiner<T, U>
extends AbstractEnricher
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Combiner.class);
    public static ConfigKey<Function<?, ?>> TRANSFORMATION = ConfigKeys.newConfigKey(new TypeToken<Function<?, ?>>(){}, "enricher.transformation", "The function to be applied, to combine the sensor values");
    public static ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer", "The entity that has the source sensors (defaults to the entity that the enricher is attached to)");
    public static ConfigKey<Set<Sensor<?>>> SOURCE_SENSORS = ConfigKeys.newConfigKey(new TypeToken<Set<Sensor<?>>>(){}, "enricher.sourceSensors", "The source sensors to be combined");
    public static ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor", "The sensor to be set on the associated entity with the value computed here");
    public static final ConfigKey<Predicate<?>> VALUE_FILTER = ConfigKeys.newConfigKey(new TypeToken<Predicate<?>>(){}, "enricher.aggregating.valueFilter", "A filter of the source sensors to include, based on their sensor values");
    protected Function<? super Collection<T>, ? extends U> transformation;
    protected Entity producer;
    protected Set<Sensor<T>> sourceSensors;
    protected Sensor<U> targetSensor;
    protected Predicate<? super T> valueFilter;
    protected final Map<Sensor<T>, T> values = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.transformation = this.getRequiredConfig(TRANSFORMATION);
        this.producer = this.getConfig(PRODUCER) == null ? entity : this.getConfig(PRODUCER);
        this.sourceSensors = this.getRequiredConfig(SOURCE_SENSORS);
        this.targetSensor = this.getRequiredConfig(TARGET_SENSOR);
        this.valueFilter = this.getConfig(VALUE_FILTER) == null ? Predicates.alwaysTrue() : this.getConfig(VALUE_FILTER);
        Preconditions.checkState((this.sourceSensors.size() > 0 ? 1 : 0) != 0, (Object)"must specify at least one sourceSensor");
        for (Sensor<T> sourceSensor : this.sourceSensors) {
            this.subscriptions().subscribe(this.producer, sourceSensor, this);
        }
        for (Sensor<T> sourceSensor : this.sourceSensors) {
            Object value;
            if (!(sourceSensor instanceof AttributeSensor) || (value = this.producer.getAttribute((AttributeSensor)sourceSensor)) == null) continue;
            this.onEvent(new BasicSensorEvent<Object>(sourceSensor, this.producer, value, -1L));
        }
        this.highlightTriggers(this.sourceSensors, (Object)this.producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(SensorEvent<T> event) {
        Map<Sensor<T>, T> map = this.values;
        synchronized (map) {
            this.values.put(event.getSensor(), event.getValue());
        }
        this.onUpdated();
    }

    protected void onUpdated() {
        try {
            this.emit(this.targetSensor, this.compute());
        }
        catch (Throwable t) {
            LOG.warn("Error calculating and setting combination for enricher " + this, t);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object compute() {
        Map<Sensor<T>, T> map = this.values;
        synchronized (map) {
            MutableList vs = MutableList.copyOf((Iterable)Iterables.filter(this.values.values(), this.valueFilter));
            return this.transformation.apply((Object)vs);
        }
    }
}

