/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.feed.ssh;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.feed.AbstractCommandFeed;
import org.apache.brooklyn.feed.CommandPollConfig;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshFeed
extends AbstractCommandFeed {
    public static final Logger log = LoggerFactory.getLogger(SshFeed.class);

    public static Builder builder() {
        return new Builder();
    }

    public SshFeed() {
    }

    public SshFeed(Builder builder) {
        super(builder);
    }

    @Override
    protected SshPollValue exec(String command, Map<String, String> env) throws IOException {
        SshMachineLocation machine = (SshMachineLocation)this.getMachine();
        Boolean execAsCommand = (Boolean)this.config().get(EXEC_AS_COMMAND);
        if (log.isTraceEnabled()) {
            log.trace("Ssh polling for {}, executing {} with env {}", new Object[]{machine, command, env});
        }
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        ConfigBag flags = ConfigBag.newInstanceExtending(this.config().getBag()).configure(SshTool.PROP_NO_EXTRA_OUTPUT, true).configure(SshTool.PROP_OUT_STREAM, stdout).configure(SshTool.PROP_ERR_STREAM, stderr);
        int exitStatus = Boolean.TRUE.equals(execAsCommand) ? machine.execCommands(flags.getAllConfig(), "ssh-feed", (List<String>)ImmutableList.of((Object)command), env) : machine.execScript(flags.getAllConfig(), "ssh-feed", (List<String>)ImmutableList.of((Object)command), env);
        return new SshPollValue(machine, exitStatus, new String(stdout.toByteArray()), new String(stderr.toByteArray()));
    }

    public static class Builder
    extends AbstractCommandFeed.Builder<SshFeed, Builder> {
        private List<CommandPollConfig<?>> polls = Lists.newArrayList();

        @Override
        public Builder poll(CommandPollConfig<?> config) {
            this.polls.add(config);
            return this.self();
        }

        @Override
        public List<CommandPollConfig<?>> getPolls() {
            return this.polls;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected SshFeed instantiateFeed() {
            return new SshFeed(this);
        }
    }
}

