/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.localhost;

import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationRegistry;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.AbstractLocationResolver;
import org.apache.brooklyn.core.location.LocationConfigKeys;
import org.apache.brooklyn.core.location.LocationConfigUtils;
import org.apache.brooklyn.location.localhost.LocalhostMachineProvisioningLocation;
import org.apache.brooklyn.location.localhost.LocalhostPropertiesFromBrooklynProperties;
import org.apache.brooklyn.util.core.config.ConfigBag;

public class LocalhostLocationResolver
extends AbstractLocationResolver {
    private static String BROOKLYN_LOCATION_LOCALHOST_PREFIX = LocationConfigUtils.BROOKLYN_LOCATION_PREFIX + ".localhost";
    public static ConfigKey<Boolean> LOCALHOST_ENABLED = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_LOCATION_LOCALHOST_PREFIX + ".", LocationConfigKeys.ENABLED);
    public static final String LOCALHOST = "localhost";

    public String getPrefix() {
        return LOCALHOST;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && LocationConfigUtils.isEnabled(this.managementContext, BROOKLYN_LOCATION_LOCALHOST_PREFIX);
    }

    @Override
    protected Class<? extends Location> getLocationType() {
        return LocalhostMachineProvisioningLocation.class;
    }

    @Override
    protected AbstractLocationResolver.SpecParser getSpecParser() {
        return new AbstractLocationResolver.SpecParser(this.getPrefix()).setExampleUsage("\"localhost\" or \"localhost(displayName=abc)\"");
    }

    @Override
    protected Map<String, Object> getFilteredLocationProperties(String provider, String namedLocation, Map<String, ?> prioritisedProperties, Map<String, ?> globalProperties) {
        return new LocalhostPropertiesFromBrooklynProperties().getLocationProperties(LOCALHOST, namedLocation, globalProperties);
    }

    @Override
    protected ConfigBag extractConfig(Map<?, ?> locationFlags, String spec, LocationRegistry registry) {
        ConfigBag config = super.extractConfig(locationFlags, spec, registry);
        config.putAsStringKeyIfAbsent("name", LOCALHOST);
        return config;
    }
}

