/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ResolvingConfigBag
extends ConfigBag {
    private static final Logger log = LoggerFactory.getLogger(ResolvingConfigBag.class);
    private final ManagementContext mgmt;
    protected final ConfigBag parentBag;
    protected volatile transient Function<Object, Object> transformer;

    @Beta
    public static ConfigBag newInstanceExtending(ManagementContext mgmt, ConfigBag parentBag) {
        return new ResolvingConfigBag(mgmt, parentBag);
    }

    public ResolvingConfigBag(ManagementContext mgmt, ConfigBag parentBag) {
        this.mgmt = mgmt;
        this.parentBag = parentBag;
        this.copy(parentBag);
    }

    protected Function<Object, Object> getTransformer() {
        if (this.transformer == null) {
            this.transformer = new Function<Object, Object>(){

                public Object apply(Object input) {
                    if (input instanceof DeferredSupplier) {
                        try {
                            return Tasks.resolveValue(input, Object.class, this.getExecutionContext());
                        }
                        catch (Exception e) {
                            throw Exceptions.propagate((Throwable)e);
                        }
                    }
                    return input;
                }

                protected ExecutionContext getExecutionContext() {
                    Entity contextEntity = BrooklynTaskTags.getTargetOrContextEntity(Tasks.current());
                    if (contextEntity instanceof EntityInternal) {
                        return ((EntityInternal)contextEntity).getExecutionContext();
                    }
                    log.debug("No entity context found, will use global execution context. Could lead to NPE on DSL resolving in location config.");
                    return ResolvingConfigBag.this.mgmt.getServerExecutionContext();
                }
            };
        }
        return this.transformer;
    }

    @Override
    public void markUsed(String key) {
        super.markUsed(key);
        if (this.parentBag != null) {
            this.parentBag.markUsed(key);
        }
    }

    @Override
    protected ConfigBag copyWhileSynched(ConfigBag otherRaw) {
        if (otherRaw instanceof ResolvingConfigBag) {
            ResolvingConfigBag other = (ResolvingConfigBag)otherRaw;
            if (this.isSealed()) {
                throw new IllegalStateException("Cannot copy " + other + " to " + this + ": this config bag has been sealed and is now immutable.");
            }
            this.putAll(other.getAllConfigUntransformed());
            this.markAll((Iterable<String>)Sets.difference(other.getAllConfigUntransformed().keySet(), other.getUnusedConfigUntransformed().keySet()));
            this.setDescription(other.getDescription());
            return this;
        }
        return super.copyWhileSynched(otherRaw);
    }

    protected Map<String, Object> getAllConfigUntransformed() {
        return super.getAllConfig();
    }

    protected Map<String, Object> getUnusedConfigUntransformed() {
        return super.getUnusedConfig();
    }

    @Override
    protected <T> T get(ConfigKey<T> key, boolean markUsed) {
        return (T)this.getTransformer().apply(super.get(key, markUsed));
    }

    @Override
    public Map<String, Object> getAllConfig() {
        return Maps.transformValues(super.getAllConfig(), this.getTransformer());
    }

    @Override
    public Map<ConfigKey<?>, ?> getAllConfigAsConfigKeyMap() {
        return Maps.transformValues(super.getAllConfigAsConfigKeyMap(), this.getTransformer());
    }

    @Override
    public Map<String, Object> getUnusedConfig() {
        return Maps.transformValues(super.getUnusedConfig(), this.getTransformer());
    }

    @Override
    public Map<String, Object> getUnusedConfigMutable() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected synchronized Maybe<Object> getStringKeyMaybe(String key, boolean markUsed) {
        Maybe result = super.getStringKeyMaybe(key, markUsed);
        return result.isPresent() ? Maybe.of((Object)this.getTransformer().apply(result.get())) : result;
    }

    @Override
    protected synchronized Maybe<Object> getKeyMaybe(ConfigKey<?> key, boolean markUsed) {
        Maybe result = super.getKeyMaybe(key, markUsed);
        return result.isPresent() ? Maybe.of((Object)this.getTransformer().apply(result.get())) : result;
    }

    @Override
    public Map<String, Object> getAllConfigMutable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getAllConfigRaw() {
        return this.getAllConfigMutable();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", this.size()).toString();
    }
}

