/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task.system.internal;

import com.google.common.base.Function;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.internal.ssh.ShellAbstractTool;
import org.apache.brooklyn.util.core.internal.ssh.ShellTool;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.stream.LoggingOutputStream;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;

public abstract class ExecWithLoggingHelpers {
    public static final ConfigKey<OutputStream> STDOUT = SshMachineLocation.STDOUT;
    public static final ConfigKey<OutputStream> STDERR = SshMachineLocation.STDERR;
    public static final ConfigKey<Boolean> NO_STDOUT_LOGGING = SshMachineLocation.NO_STDOUT_LOGGING;
    public static final ConfigKey<Boolean> NO_STDERR_LOGGING = SshMachineLocation.NO_STDERR_LOGGING;
    public static final ConfigKey<String> LOG_PREFIX = SshMachineLocation.LOG_PREFIX;
    protected final String shortName;
    protected Logger commandLogger = null;

    protected abstract <T> T execWithTool(MutableMap<String, Object> var1, Function<ShellTool, T> var2);

    protected abstract void preExecChecks();

    protected abstract String getTargetName();

    protected abstract String constructDefaultLoggingPrefix(ConfigBag var1);

    public ExecWithLoggingHelpers(String shortName) {
        this.shortName = shortName;
    }

    public ExecWithLoggingHelpers logger(Logger commandLogger) {
        this.commandLogger = commandLogger;
        return this;
    }

    public int execScript(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        String scriptHeader = ShellAbstractTool.getOptionalVal(props, ShellTool.PROP_SCRIPT_HEADER);
        return this.execWithLogging(props, summaryForLogging, commands, env, scriptHeader, new ExecRunner(){

            @Override
            public int exec(ShellTool ssh, Map<String, ?> flags, List<String> cmds, Map<String, ?> env) {
                return ssh.execScript(flags, cmds, env);
            }
        });
    }

    protected static <T> T getOptionalVal(Map<String, ?> map, ConfigKey<T> keyC) {
        if (keyC == null) {
            return null;
        }
        String key = keyC.getName();
        if (map != null && map.containsKey(key)) {
            return TypeCoercions.coerce(map.get(key), keyC.getTypeToken());
        }
        return (T)keyC.getDefaultValue();
    }

    public int execCommands(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env) {
        return this.execWithLogging(props, summaryForLogging, commands, env, new ExecRunner(){

            @Override
            public int exec(ShellTool tool, Map<String, ?> flags, List<String> cmds, Map<String, ?> env) {
                return tool.execCommands(flags, cmds, env);
            }
        });
    }

    public int execWithLogging(Map<String, ?> props, String summaryForLogging, List<String> commands, Map<String, ?> env, ExecRunner execCommand) {
        return this.execWithLogging(props, summaryForLogging, commands, env, null, execCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execWithLogging(Map<String, ?> props, final String summaryForLogging, final List<String> commands, final Map<String, ?> env, String expectedCommandHeaders, final ExecRunner execCommand) {
        if (this.commandLogger != null && this.commandLogger.isDebugEnabled()) {
            String allcmds = (Strings.isBlank((CharSequence)expectedCommandHeaders) ? "" : expectedCommandHeaders + " ; ") + Strings.join(commands, (String)" ; ");
            this.commandLogger.debug("{}, initiating " + this.shortName.toLowerCase() + " on machine {}{}: {}", new Object[]{summaryForLogging, this.getTargetName(), env != null && !env.isEmpty() ? " (env " + Sanitizer.sanitize(env) + ")" : "", allcmds});
        }
        if (commands.isEmpty()) {
            if (this.commandLogger != null && this.commandLogger.isDebugEnabled()) {
                this.commandLogger.debug("{}, on machine {}, ending: no commands to run", (Object)summaryForLogging, (Object)this.getTargetName());
            }
            return 0;
        }
        final ConfigBag execFlags = new ConfigBag().putAll(props);
        ConfigBag toolFlags = new ConfigBag().putAll(props).removeAll(LOG_PREFIX, STDOUT, STDERR, ShellTool.PROP_NO_EXTRA_OUTPUT);
        execFlags.configure(ShellTool.PROP_SUMMARY, summaryForLogging);
        this.preExecChecks();
        String logPrefix = execFlags.get(LOG_PREFIX);
        if (logPrefix == null) {
            logPrefix = this.constructDefaultLoggingPrefix(execFlags);
        }
        if (!execFlags.get(NO_STDOUT_LOGGING).booleanValue()) {
            String stdoutLogPrefix = "[" + (logPrefix != null ? logPrefix + ":stdout" : "stdout") + "] ";
            LoggingOutputStream outO = LoggingOutputStream.builder().outputStream(execFlags.get(STDOUT)).logger(this.commandLogger).logPrefix(stdoutLogPrefix).build();
            execFlags.put(STDOUT, outO);
        }
        if (!execFlags.get(NO_STDERR_LOGGING).booleanValue()) {
            String stderrLogPrefix = "[" + (logPrefix != null ? logPrefix + ":stderr" : "stderr") + "] ";
            LoggingOutputStream outE = LoggingOutputStream.builder().outputStream(execFlags.get(STDERR)).logger(this.commandLogger).logPrefix(stderrLogPrefix).build();
            execFlags.put(STDERR, outE);
        }
        Tasks.setBlockingDetails(this.shortName + " executing, " + summaryForLogging);
        try {
            int n = this.execWithTool((MutableMap<String, Object>)MutableMap.copyOf(toolFlags.getAllConfig()), new Function<ShellTool, Integer>(){

                public Integer apply(ShellTool tool) {
                    int result = execCommand.exec(tool, (Map<String, ?>)MutableMap.copyOf(execFlags.getAllConfig()), commands, env);
                    if (ExecWithLoggingHelpers.this.commandLogger != null && ExecWithLoggingHelpers.this.commandLogger.isDebugEnabled()) {
                        ExecWithLoggingHelpers.this.commandLogger.debug("{}, on machine {}, completed: return status {}", new Object[]{summaryForLogging, ExecWithLoggingHelpers.this.getTargetName(), result});
                    }
                    return result;
                }
            });
            return n;
        }
        finally {
            Tasks.setBlockingDetails(null);
        }
    }

    public static interface ExecRunner {
        public int exec(ShellTool var1, Map<String, ?> var2, List<String> var3, Map<String, ?> var4);
    }
}

