/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.jmx;

import java.io.IOException;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AbstractHandlerMBean
extends ObjectMBean {
    private static final Logger LOG = Log.getLogger(AbstractHandlerMBean.class);

    public AbstractHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    @Override
    public String getObjectContextBasis() {
        if (this._managed != null) {
            ContextHandler context;
            AbstractHandler handler;
            Server server;
            String basis = null;
            if (this._managed instanceof ContextHandler) {
                return null;
            }
            if (this._managed instanceof AbstractHandler && (server = (handler = (AbstractHandler)this._managed).getServer()) != null && (context = AbstractHandlerContainer.findContainerOf(server, ContextHandler.class, handler)) != null) {
                basis = this.getContextName(context);
            }
            if (basis != null) {
                return basis;
            }
        }
        return super.getObjectContextBasis();
    }

    @Override
    public String getObjectNameBasis() {
        if (this._managed != null) {
            String name = null;
            if (this._managed instanceof ContextHandler) {
                ContextHandler context = (ContextHandler)this._managed;
                name = this.getContextName(context);
            }
            if (name != null) {
                return name;
            }
        }
        return super.getObjectNameBasis();
    }

    protected String getContextName(ContextHandler context) {
        String name = null;
        if (context.getContextPath() != null && context.getContextPath().length() > 0) {
            int idx = context.getContextPath().lastIndexOf(47);
            String string = name = idx < 0 ? context.getContextPath() : context.getContextPath().substring(++idx);
            if (name == null || name.length() == 0) {
                name = "ROOT";
            }
        }
        if (name == null && context.getBaseResource() != null) {
            try {
                if (context.getBaseResource().getFile() != null) {
                    name = context.getBaseResource().getFile().getName();
                }
            }
            catch (IOException e) {
                LOG.ignore(e);
                name = context.getBaseResource().getName();
            }
        }
        return name;
    }
}

