/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock.aggregator;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.core.sensor.BasicAttributeSensorAndConfigKey;
import org.apache.commons.lang3.StringUtils;

@Beta
public final class AggregationJob
implements Runnable {
    public static BasicAttributeSensorAndConfigKey<Map<String, String>> DASHBOARD_COST_PER_MONTH = new BasicAttributeSensorAndConfigKey<Map>(Map.class, "dashboard.costPerMonth", "A map of VM ID to monthly cost. Please note if the same VM ID is reported more than once, only one of the sensors will be propagated");
    public static BasicAttributeSensorAndConfigKey<List<Map<String, String>>> DASHBOARD_HA_PRIMARIES = new BasicAttributeSensorAndConfigKey<List>(List.class, "dashboard.ha.primaries", "A list of high availability primaries ");
    public static BasicAttributeSensorAndConfigKey<List<Map<String, String>>> DASHBOARD_LICENSES = new BasicAttributeSensorAndConfigKey<List>(List.class, "dashboard.licenses", "The licences in use for the running entities. This is a list of maps. The map should contain two keys: product and key");
    public static BasicAttributeSensorAndConfigKey<Map<String, List<Map<String, Object>>>> DASHBOARD_LOCATIONS = new BasicAttributeSensorAndConfigKey<Map>(Map.class, "dashboard.locations", "Locations in which the VMs are running. A map where the key is category of location (e.g. server) and the value is a list of maps containing name/icon/count");
    public static BasicAttributeSensorAndConfigKey<List<Map<String, String>>> DASHBOARD_POLICY_HIGHLIGHTS = new BasicAttributeSensorAndConfigKey<List>(List.class, "dashboard.policyHighlights", "Highlights from policies. List of Maps, where each map should contain text and category");
    private final Entity entity;
    private static final String NAME_STRING = "name";
    private static final String COUNT_STRING = "count";

    public AggregationJob(Entity entity) {
        this.entity = entity;
    }

    private void updateFromConfig(Entity entity, BasicAttributeSensorAndConfigKey<List<Map<String, String>>> sensorAndConfigKey, List<Map<String, String>> list) {
        List listFromEntity = (List)entity.sensors().get(sensorAndConfigKey);
        if (listFromEntity == null || listFromEntity.isEmpty()) {
            listFromEntity = (List)entity.config().get(sensorAndConfigKey);
        }
        if (listFromEntity != null) {
            list.addAll(listFromEntity);
        }
    }

    @Override
    public void run() {
        HashMap costPerMonth = new HashMap();
        ArrayList haPrimaries = new ArrayList();
        ArrayList dashboardLicences = new ArrayList();
        HashMap dashboardLocations = new HashMap();
        ArrayList dashboardPolicyHighlights = new ArrayList();
        this.entity.getChildren().forEach(childEntity -> this.scanEntity((Entity)childEntity, costPerMonth, haPrimaries, dashboardLicences, dashboardLocations, dashboardPolicyHighlights));
        this.entity.sensors().set(DASHBOARD_COST_PER_MONTH, costPerMonth);
        this.entity.sensors().set(DASHBOARD_HA_PRIMARIES, haPrimaries);
        this.entity.sensors().set(DASHBOARD_LICENSES, dashboardLicences);
        this.entity.sensors().set(DASHBOARD_LOCATIONS, dashboardLocations);
        this.entity.sensors().set(DASHBOARD_POLICY_HIGHLIGHTS, dashboardPolicyHighlights);
    }

    protected void scanEntity(Entity entityToScan, Map<String, String> costPerMonth, List<Map<String, String>> haPrimaries, List<Map<String, String>> licences, Map<String, List<Map<String, Object>>> locations, List<Map<String, String>> policyHighlights) {
        Map outerLocationMapFromEntity;
        this.updateFromConfig(entityToScan, DASHBOARD_HA_PRIMARIES, haPrimaries);
        this.updateFromConfig(entityToScan, DASHBOARD_LICENSES, licences);
        this.updateFromConfig(entityToScan, DASHBOARD_POLICY_HIGHLIGHTS, policyHighlights);
        Map costPerMonthFromEntity = (Map)entityToScan.sensors().get(DASHBOARD_COST_PER_MONTH);
        if (costPerMonthFromEntity == null || costPerMonthFromEntity.isEmpty()) {
            costPerMonthFromEntity = (Map)entityToScan.config().get(DASHBOARD_COST_PER_MONTH);
        }
        if (costPerMonthFromEntity != null) {
            costPerMonth.putAll(costPerMonthFromEntity);
        }
        if ((outerLocationMapFromEntity = (Map)entityToScan.sensors().get(DASHBOARD_LOCATIONS)) == null || outerLocationMapFromEntity.isEmpty()) {
            outerLocationMapFromEntity = (Map)entityToScan.config().get(DASHBOARD_LOCATIONS);
        }
        if (outerLocationMapFromEntity != null) {
            outerLocationMapFromEntity.forEach((outerLocationMapFromEntityKey, outerLocationMapFromEntityValue) -> {
                boolean found = false;
                for (Map.Entry outerLocationMapFromMethodParam : locations.entrySet()) {
                    if (!StringUtils.equals((CharSequence)((CharSequence)outerLocationMapFromMethodParam.getKey()), (CharSequence)outerLocationMapFromEntityKey)) continue;
                    found = true;
                    for (Map innerMapFromEntity : outerLocationMapFromEntityValue) {
                        boolean foundInner = false;
                        for (Map innerMapFromMethodParam : (List)outerLocationMapFromMethodParam.getValue()) {
                            if (!StringUtils.equals((CharSequence)((String)innerMapFromEntity.get(NAME_STRING)), (CharSequence)((String)innerMapFromMethodParam.get(NAME_STRING)))) continue;
                            innerMapFromMethodParam.put(COUNT_STRING, (Integer)innerMapFromEntity.get(COUNT_STRING) + (Integer)innerMapFromMethodParam.get(COUNT_STRING));
                            foundInner = true;
                            break;
                        }
                        if (foundInner) continue;
                        ((List)outerLocationMapFromMethodParam.getValue()).add(new HashMap(innerMapFromEntity));
                    }
                }
                if (!found) {
                    ArrayList clonedList = new ArrayList();
                    outerLocationMapFromEntityValue.forEach(mapToClone -> clonedList.add(new HashMap(mapToClone)));
                    locations.put((String)outerLocationMapFromEntityKey, clonedList);
                }
            });
        }
        entityToScan.getChildren().forEach(childEntity -> this.scanEntity((Entity)childEntity, costPerMonth, haPrimaries, licences, locations, policyHighlights));
    }
}

