/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.entity.stock.BasicStartable;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStartableImpl
extends AbstractEntity
implements BasicStartable {
    private static final Logger log = LoggerFactory.getLogger(BasicStartableImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Collection<? extends Location> locations) {
        try {
            ServiceStateLogic.setExpectedState(this, Lifecycle.STARTING);
            Object val = this.config().get(START_LATCH);
            if (val != null) {
                log.debug("{} finished waiting for start-latch; continuing...", (Object)this);
            }
            this.addLocations(locations);
            locations = Locations.getLocationsCheckingAncestors(locations, this);
            log.info("Starting entity " + this + " at " + locations);
            Locations.LocationsFilter filter = (Locations.LocationsFilter)this.getConfig(LOCATIONS_FILTER);
            Iterable<Entity> startables = BasicStartableImpl.filterStartableManagedEntities(this.getChildren());
            if (!Iterables.isEmpty(startables)) {
                ArrayList tasks = Lists.newArrayListWithCapacity((int)Iterables.size(startables));
                for (Entity entity : startables) {
                    Collection<? extends Location> l2 = locations;
                    if (filter != null) {
                        l2 = filter.filterForContext(new ArrayList<Location>(locations), entity);
                        log.debug("Child " + entity + " of " + this + " being started in filtered location list: " + l2);
                    }
                    tasks.add(Entities.invokeEffectorWithArgs(this, entity, Startable.START, l2));
                }
                for (Task t : tasks) {
                    t.getUnchecked();
                }
            }
            this.sensors().set(Attributes.SERVICE_UP, true);
        }
        finally {
            ServiceStateLogic.setExpectedState(this, Lifecycle.RUNNING);
        }
    }

    @Override
    public void stop() {
        ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPING);
        this.sensors().set(SERVICE_UP, false);
        try {
            StartableMethods.stop(this);
            ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPED);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public void restart() {
        StartableMethods.restart(this);
    }

    @Override
    protected void initEnrichers() {
        super.initEnrichers();
        this.enrichers().add(ServiceStateLogic.newEnricherFromChildrenUp().checkChildrenOnly().requireUpChildren(QuorumCheck.QuorumChecks.all()).suppressDuplicates(true));
    }

    private static Iterable<Entity> filterStartableManagedEntities(Iterable<Entity> contenders) {
        return Iterables.filter(contenders, (Predicate)Predicates.and((Predicate)Predicates.instanceOf(Startable.class), EntityPredicates.isManaged()));
    }
}

