/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import java.util.List;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.typereg.AbstractFormatSpecificTypeImplementationPlan;
import org.apache.brooklyn.core.typereg.AbstractTypePlanTransformer;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;

public class JavaClassNameTypePlanTransformer
extends AbstractTypePlanTransformer {
    public static final String FORMAT = "java-type-name";

    public JavaClassNameTypePlanTransformer() {
        super(FORMAT, "Java type name", "Expects a java type name in a format suitable for use with ClassLoader.loadClass");
    }

    @Override
    protected double scoreForNullFormat(Object planData, RegisteredType type, RegisteredTypeLoadingContext context) {
        if (type.getPlan().getPlanData() instanceof String && ((String)type.getPlan().getPlanData()).matches("([ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]*\\.)*[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_][ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]*(\\$[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890]+)*")) {
            return 0.1;
        }
        return 0.0;
    }

    @Override
    protected double scoreForNonmatchingNonnullFormat(String planFormat, Object planData, RegisteredType type, RegisteredTypeLoadingContext context) {
        return 0.0;
    }

    @Override
    protected AbstractBrooklynObjectSpec<?, ?> createSpec(RegisteredType type, RegisteredTypeLoadingContext context) throws Exception {
        return RegisteredTypes.newSpecInstance(this.mgmt, this.getType(type, context));
    }

    @Override
    protected Object createBean(RegisteredType type, RegisteredTypeLoadingContext context) throws Exception {
        return this.getType(type, context).newInstance();
    }

    private Class<?> getType(RegisteredType type, RegisteredTypeLoadingContext context) throws Exception {
        return RegisteredTypes.loadActualJavaType((String)type.getPlan().getPlanData(), this.mgmt, type, context);
    }

    @Override
    public double scoreForTypeDefinition(String formatCode, Object catalogData) {
        return 0.0;
    }

    @Override
    public List<RegisteredType> createFromTypeDefinition(String formatCode, Object catalogData) {
        throw new UnsupportedTypePlanException("this transformer does not support YAML catalog additions");
    }

    public static class JavaClassNameTypeImplementationPlan
    extends AbstractFormatSpecificTypeImplementationPlan<String> {
        public JavaClassNameTypeImplementationPlan(String javaType) {
            super(JavaClassNameTypePlanTransformer.FORMAT, javaType);
        }
    }
}

