/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.flags;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import groovy.lang.Closure;
import groovy.time.TimeDuration;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.internal.BrooklynInitialization;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.javalang.coerce.CommonAdaptorTryCoercions;
import org.apache.brooklyn.util.javalang.coerce.CommonAdaptorTypeCoercions;
import org.apache.brooklyn.util.javalang.coerce.EnumTypeCoercions;
import org.apache.brooklyn.util.javalang.coerce.PrimitiveStringTypeCoercions;
import org.apache.brooklyn.util.javalang.coerce.TryCoercer;
import org.apache.brooklyn.util.javalang.coerce.TypeCoercer;
import org.apache.brooklyn.util.javalang.coerce.TypeCoercerExtensible;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCoercions {
    private static final Logger log = LoggerFactory.getLogger(TypeCoercions.class);
    private static final TypeCoercerExtensible coercer = TypeCoercerExtensible.newEmpty();
    @Deprecated
    public static final Map<Class, Class> BOXED_TO_UNBOXED_TYPES;
    @Deprecated
    public static final Map<Class, Class> UNBOXED_TO_BOXED_TYPES;

    private TypeCoercions() {
    }

    public static void initStandardAdapters() {
        new BrooklynCommonAdaptorTypeCoercions(coercer).registerAllAdapters();
        new CommonAdaptorTryCoercions(coercer).registerAllAdapters();
        TypeCoercions.registerDeprecatedBrooklynAdapters();
        TypeCoercions.registerBrooklynAdapters();
        TypeCoercions.registerGroovyAdapters();
    }

    public static <T> T coerce(Object input, Class<T> type) {
        return (T)coercer.coerce(input, type);
    }

    public static <T> T coerce(Object input, TypeToken<T> type) {
        return (T)coercer.coerce(input, type);
    }

    public static <T> Maybe<T> tryCoerce(Object input, Class<T> type) {
        return coercer.tryCoerce(input, type);
    }

    public static <T> Maybe<T> tryCoerce(Object input, TypeToken<T> type) {
        return coercer.tryCoerce(input, type);
    }

    public static <A, B> Function<? super A, B> registerAdapter(Class<A> sourceType, Class<B> targetType, Function<? super A, B> fn) {
        return coercer.registerAdapter(sourceType, targetType, fn);
    }

    @Beta
    public static void registerAdapter(String nameAndOrder, TryCoercer fn) {
        coercer.registerAdapter(nameAndOrder, fn);
    }

    @Deprecated
    @Beta
    public static void registerAdapter(TryCoercer fn) {
        coercer.registerAdapter(fn);
    }

    public static <T> Function<Object, T> function(Class<T> type) {
        return new CoerceFunction<T>(type);
    }

    public static void registerDeprecatedBrooklynAdapters() {
    }

    public static void registerBrooklynAdapters() {
        TypeCoercions.registerAdapter(String.class, AttributeSensor.class, new Function<String, AttributeSensor>(){

            public AttributeSensor apply(String input) {
                Sensor result;
                Entity entity = BrooklynTaskTags.getContextEntity(Tasks.current());
                if (entity != null && (result = entity.getEntityType().getSensor(input)) instanceof AttributeSensor) {
                    return (AttributeSensor)result;
                }
                return Sensors.newSensor(Object.class, input);
            }
        });
        TypeCoercions.registerAdapter(String.class, Sensor.class, new Function<String, Sensor>(){

            public AttributeSensor apply(String input) {
                Sensor result;
                Entity entity = BrooklynTaskTags.getContextEntity(Tasks.current());
                if (entity != null && (result = entity.getEntityType().getSensor(input)) != null) {
                    return (AttributeSensor)result;
                }
                return Sensors.newSensor(Object.class, input);
            }
        });
    }

    @Deprecated
    public static void registerGroovyAdapters() {
        TypeCoercions.registerAdapter(Closure.class, Predicate.class, new Function<Closure, Predicate>(){

            public Predicate<?> apply(final Closure closure) {
                log.warn("Use of groovy.lang.Closure is deprecated, in TypeCoercions Closure->Predicate");
                return new Predicate<Object>(){

                    public boolean apply(Object input) {
                        return (Boolean)closure.call(input);
                    }
                };
            }
        });
        TypeCoercions.registerAdapter(Closure.class, Function.class, new Function<Closure, Function>(){

            public Function apply(final Closure closure) {
                log.warn("Use of groovy.lang.Closure is deprecated, in TypeCoercions Closure->Function");
                return new Function(){

                    public Object apply(Object input) {
                        return closure.call(input);
                    }
                };
            }
        });
        TypeCoercions.registerAdapter(Object.class, TimeDuration.class, new Function<Object, TimeDuration>(){

            public TimeDuration apply(Object input) {
                log.warn("deprecated automatic coercion of Object to TimeDuration (set breakpoint in TypeCoercions to inspect, convert to Duration)");
                return JavaGroovyEquivalents.toTimeDuration((Object)input);
            }
        });
        TypeCoercions.registerAdapter(TimeDuration.class, Long.class, new Function<TimeDuration, Long>(){

            public Long apply(TimeDuration input) {
                log.warn("deprecated automatic coercion of TimeDuration to Long (set breakpoint in TypeCoercions to inspect, use Duration instead of Long!)");
                return input.toMilliseconds();
            }
        });
    }

    @Deprecated
    public static <E extends Enum<E>> Function<String, E> stringToEnum(Class<E> type, @Nullable E defaultValue) {
        return EnumTypeCoercions.stringToEnum(type, defaultValue);
    }

    @Deprecated
    public static <T> T castPrimitive(Object value, Class<T> targetType) {
        return (T)PrimitiveStringTypeCoercions.castPrimitive((Object)value, targetType);
    }

    @Deprecated
    public static boolean isPrimitiveOrBoxer(Class<?> type) {
        return PrimitiveStringTypeCoercions.isPrimitiveOrBoxer(type);
    }

    @Deprecated
    public static <T> T stringToPrimitive(String value, Class<T> targetType) {
        return (T)PrimitiveStringTypeCoercions.stringToPrimitive((String)value, targetType);
    }

    @Deprecated
    public static String getVerySimpleName(Class c) {
        return JavaClassNames.verySimpleClassName((Class)c);
    }

    @Deprecated
    public static Object getMatchingConstructor(Class target, Object ... arguments) {
        Constructor<?>[] cc;
        for (Constructor<?> c : cc = target.getConstructors()) {
            if (c.getParameterTypes().length != arguments.length) continue;
            boolean matches = true;
            Class<?>[] tt = c.getParameterTypes();
            for (int i = 0; i < tt.length; ++i) {
                if (arguments[i] == null || tt[i].isInstance(arguments[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return c;
        }
        return null;
    }

    public static TypeCoercer asTypeCoercer() {
        return new TypeCoercer(){

            public <T> T coerce(Object input, Class<T> type) {
                return TypeCoercions.coerce(input, type);
            }

            public <T> Maybe<T> tryCoerce(Object input, Class<T> type) {
                return TypeCoercions.tryCoerce(input, type);
            }

            public <T> Maybe<T> tryCoerce(Object input, TypeToken<T> type) {
                return TypeCoercions.tryCoerce(input, type);
            }
        };
    }

    static {
        BrooklynInitialization.initTypeCoercionStandardAdapters();
        BOXED_TO_UNBOXED_TYPES = ImmutableMap.builder().put(Integer.class, Integer.TYPE).put(Long.class, Long.TYPE).put(Boolean.class, Boolean.TYPE).put(Byte.class, Byte.TYPE).put(Double.class, Double.TYPE).put(Float.class, Float.TYPE).put(Character.class, Character.TYPE).put(Short.class, Short.TYPE).build();
        UNBOXED_TO_BOXED_TYPES = ImmutableMap.builder().put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Character.TYPE, Character.class).put(Short.TYPE, Short.class).build();
    }

    public static class BrooklynCommonAdaptorTypeCoercions
    extends CommonAdaptorTypeCoercions {
        public BrooklynCommonAdaptorTypeCoercions(TypeCoercerExtensible coercer) {
            super(coercer);
        }

        public void registerClassForNameAdapters() {
            this.registerAdapter(String.class, Class.class, (Function)new Function<String, Class>(){

                public Class apply(String input) {
                    try {
                        return new ClassLoaderUtils(this.getClass()).loadClass(input);
                    }
                    catch (ClassNotFoundException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
            });
        }

        public static <T> void registerInstanceForClassnameAdapter(final ClassLoaderUtils loader, final Class<T> supertype) {
            TypeCoercions.registerAdapter(String.class, supertype, new Function<String, T>(){

                public T apply(String input) {
                    Class<?> clazz;
                    try {
                        clazz = loader.loadClass(input);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Failed to load " + supertype.getSimpleName() + " class " + input, e);
                    }
                    Maybe result = Reflections.invokeConstructorFromArgs(clazz, (Object[])new Object[0]);
                    if (result.isPresentAndNonNull() && supertype.isInstance(result.get())) {
                        Object rT = result.get();
                        return rT;
                    }
                    if (result.isPresent()) {
                        throw new IllegalStateException("Object is not a " + supertype.getSimpleName() + ": " + result.get());
                    }
                    throw new IllegalStateException("Failed to create " + supertype.getSimpleName() + " from class name '" + input + "' using no-arg constructor");
                }
            });
        }
    }

    private static class CoerceFunction<T>
    implements Function<Object, T> {
        private final Class<T> type;

        public CoerceFunction(Class<T> type) {
            this.type = type;
        }

        public T apply(Object input) {
            return TypeCoercions.coerce(input, this.type);
        }
    }
}

